************************************************************************
** This is a revised version of the kinetics code from the St.Johns   **
** model.  Droop kinetics, coagulation and nitrogen fixation removed. **
** Revised algal ammonium preference installed.                       **
**                                                                    **
** Original code in                                                   **
** /home/cerco/disk2/new_ches_bay/Jan_27_06/wqm_kin.F                 **
** Features incorporated from                                         **
** /home/cerco/disk2/oysters/source_code/ches_bay_50000/PARWQM_KIN.f  **
**                                                                    **
**                Kinetics Subroutines for CE-QUAL-IC                 **
**                                                                    **
**                            Version 2.0                             **
**                         January 27, 2006                           **
**                                                                    **
**                    Water Quality Modeling Group                    **
**                    U.S. Army Corps of Engineers                    **
**                    Waterways Experiment Station                    **
**                    Vicksburg, Mississippi 39180                    **
**                                                                    **
************************************************************************


************************************************************************
**                 S U B R O U T I N E   T E M P E R                  **
************************************************************************

      SUBROUTINE TEMPER
        USE WQM
        DATA     RHO /1.0E6/, CP /4.1796/

        DO 10000 B=1,NSB
          DTT(SBN(B)) = KT/(RHO*CP*BL(SBN(B),3))*(TE-T(SBN(B)))
10000   CONTINUE

      END

************************************************************************
**                 S U B R O U T I N E   S O L I D S                  **
************************************************************************

      SUBROUTINE SOLIDS
        USE WQM

******* Settling through water column

        DO 10000 B=1,NB
          FLXSSSI(B) = WSS(B)*SSI(B)*V2(B)/(BL(B,3)*86400.)
          DTSSI(B)   = (WSS(BU(B))*SSI(BU(B))-WSS(B)*SSI(B))
     .                 /(BL(B,3)*86400.)
10000   CONTINUE

******  Net Settling

        IF (SEDIMENT_CALC) THEN
          DO B=1,NBB
            DTSSI(BBN(B)) = DTSSI(BBN(B))+(WSS(BBN(B))-WSSNET(B))
     .                      *SSI(BBN(B))/BL(BBN(B),3)/86400.
          END DO
        END IF

      END

************************************************************************
**                 S U B R O U T I N E   C A R B O N                  **
************************************************************************

      SUBROUTINE CARBON
        USE WQM
        REAL     LPOC1, LPOC2, LPOC3, LPSETL, LDOC1, LDOC2, LDOC3
        REAL     G3POC1, G3POC2, G3POC3
        INTEGER F

        DO 10000 B=1,NB

********* Algal contribution

          DOCBM1 = KHR1/(KHR1+DO(B))
          DOCBM2 = KHR2/(KHR2+DO(B))
          DOCBM3 = KHR3/(KHR3+DO(B))
          CP1 = (P1(B)*PRSP1+BM1(B))*B1(B)
          CP2 = (P2(B)*PRSP2+BM2(B))*B2(B)
          CP3 = (P3(B)*PRSP3+BM3(B))*B3(B)
          LDOC1 = FCLD1*CP1+(1.-FCLD1-FCRD1-FCLP1-FCRP1-FCG31)*DOCBM1
     $         *CP1 + (FCLDP+FDOP*DOCBM1)*PR1(B)
          LDOC2 = FCLD2*CP2+(1.-FCLD2-FCRD2-FCLP2-FCRP2-FCG32)*DOCBM2
     $         *CP2 + (FCLDP+FDOP*DOCBM2)*PR2(B)
          LDOC3 = FCLD3*CP3+(1.-FCLD3-FCRD3-FCLP3-FCRP3-FCG33)*DOCBM3
     $         *CP3 + (FCLDP+FDOP*DOCBM3)*PR3(B)
          RDOC1 = FCRD1*CP1+FCRDP*PR1(B)
          RDOC2 = FCRD2*CP2+FCRDP*PR2(B)
          RDOC3 = FCRD3*CP3+FCRDP*PR3(B)
          LPOC1      = FCLP1*CP1+FCLPP*PR1(B)
          LPOC2      = FCLP2*CP2+FCLPP*PR2(B)
          LPOC3      = FCLP3*CP3+FCLPP*PR3(B)
          RPOC1      = FCRP1*CP1+FCRPP*PR1(B)
          RPOC2      = FCRP2*CP2+FCRPP*PR2(B)
          RPOC3      = FCRP3*CP3+FCRPP*PR3(B)
          G3POC1     = FCG31*CP1+FCG3P*PR1(B)
          G3POC2     = FCG32*CP2+FCG3P*PR2(B)
          G3POC3     = FCG33*CP3+FCG3P*PR3(B)
          ALGDOC(B)  = LDOC1+LDOC2+LDOC3+RDOC1+RDOC2+RDOC3
          ALGPOC(B)  = LPOC1+LPOC2+LPOC3+RPOC1+RPOC2+RPOC3
     $                 +G3POC1+G3POC2+G3POC3
 
********* Mineralization and hydrolysis

          FTMNL(B)    = EXP(KTMNL*(T(B)-TRMNL))
          FTHDR(B)    = EXP(KTHDR*(T(B)-TRHDR))
          DENIT(B)    = (KLDC(B)*LDOC(B)+KRDC(B)*RDOC(B))*FTMNL(B)
     $                * KHODOC/(KHODOC+DO(B))
     $                * NO3(B)/(KHNDN+NO3(B))   ! USE NO3 IF NO DO AVAILABLE
          CODMNL(B)   = (KLDC(B)*LDOC(B)+KRDC(B)*RDOC(B))*FTMNL(B)
     $                * KHODOC/(KHODOC+DO(B))
     $                * KHNDN/(KHNDN+NO3(B))    ! PRODUCE COD IF NO NO3 AVAILABLE
          MNLLDOC(B)  = KLDC(B)*FTMNL(B)*DO(B)/(KHODOC+DO(B))*LDOC(B)
          MNLRDOC(B)  = KRDC(B)*FTMNL(B)*DO(B)/(KHODOC+DO(B))*RDOC(B)
          HDRLPOC(B)  = KLPC(B)*FTHDR(B)*LPOC(B)
          HDRRPOC(B)  = KRPC(B)*FTHDR(B)*RPOC(B)
          HDRG3POC(B) = KG3C(B)*FTHDR(B)*G3POC(B)

********* Change in carbon species

          DTLDOC(B) = (LDOC1+LDOC2+LDOC3-KLDC(B)*FTMNL(B)*LDOC(B)
     .              + HDRLPOC(B)+HDRRPOC(B)+HDRG3POC(B))/86400.
          DTRDOC(B) = (RDOC1+RDOC2+RDOC3-KRDC(B)*FTMNL(B)*RDOC(B))
     $              / 86400.
          DTLPOC(B) = (LPOC1+LPOC2+LPOC3-HDRLPOC(B))/86400.
          DTRPOC(B) = (RPOC1+RPOC2+RPOC3-HDRRPOC(B))/86400.
          DTG3POC(B) = (G3POC1+G3POC2+G3POC3-HDRG3POC(B))/86400.

10000   CONTINUE 

        DO B=1,NB

********* Settling

          LPSETL = (WSL(BU(B))*LPOC(BU(B))-WSL(B)*LPOC(B))/BL(B,3)
          RPSETL = (WSR(BU(B))*RPOC(BU(B))-WSR(B)*RPOC(B))/BL(B,3)
          G3SETL = (WSG3(BU(B))*G3POC(BU(B))-WSG3(B)*G3POC(B))/BL(B,3)
          DTLPOC(B) = DTLPOC(B)+LPSETL/86400.
          DTRPOC(B) = DTRPOC(B)+RPSETL/86400.
          DTG3POC(B) = DTG3POC(B)+G3SETL/86400.

        END DO  

********* Settling flux      g/s

      IF (S_TRANS_FLUX) THEN
        DO F=NHQF+1,NQF
	  B = JB(F)
          FLXSLPOC(F) = -WSL(B)*LPOC(B)*V2(B)/(BL(B,3)*86400.)     
          FLXSRPOC(F) = -WSR(B)*RPOC(B)*V2(B)/(BL(B,3)*86400.)
          FLXSG3POC(F) = -WSG3(B)*G3POC(B)*V2(B)/(BL(B,3)*86400.)
        END DO
      END IF  
     
******* Benthic fluxes

        DO 10010 B=1,NBB
          DTLDOC(BBN(B))  = DTLDOC(BBN(B))+BENDOC(B)/BL(BBN(B),3)/86400.
10010   CONTINUE

******* Net Settling

        IF (SEDIMENT_CALC) THEN

          DO 10020 B=1,NBB
            DTLPOC(BBN(B)) = DTLPOC(BBN(B))+(WSL(BBN(B))-WSLNET(B))
     .                       *LPOC(BBN(B))/BL(BBN(B),3)/86400.
            DTRPOC(BBN(B)) = DTRPOC(BBN(B))+(WSR(BBN(B))-WSRNET(B))
     .                       *RPOC(BBN(B))/BL(BBN(B),3)/86400.
            DTG3POC(BBN(B)) = DTG3POC(BBN(B))+(WSG3(BBN(B))-WSG3NET(B))
     .                       *G3POC(BBN(B))/BL(BBN(B),3)/86400.
10020     CONTINUE

        END IF

******* SAV and epiphytes

cvjp modified 11/3/2005
        IF (SAV_CALC) THEN
          DO 10030 I=1,NSAVCELL
            B=SAVCELL(I)
            DTLDOC(B)  = DTLDOC(B)+(LDOCSAV(B)+LDOCEPI(B))
     $                      /BL(B,3)/86400.
            DTRDOC(B)  = DTRDOC(B)+(RDOCSAV(B)+RDOCEPI(B))
     $                      /BL(B,3)/86400.
            DTLPOC(B)  = DTLPOC(B)+(LPOCSAV(B)+LPOCEPI(B))
     $                      /BL(B,3)/86400.
            DTRPOC(B)  = DTRPOC(B)+(RPOCSAV(B)+RPOCEPI(B))
     $                      /BL(B,3)/86400.
            DTG3POC(B) = DTG3POC(B)+(G3CSAV(B)+G3CEPI(B))
     $                      /BL(B,3)/86400.
10030     CONTINUE
        END IF

      END

************************************************************************
**                 S U B R O U T I N E   N I T R O G                  **
************************************************************************

      SUBROUTINE NITROG
        USE WQM
        REAL     LPON1, LPON2, LPON3,
     .           NH4A1, NH4A2,  NH4A3,  NO3A1,  NO3A2,  NO3A3,  LPSETL,
     .           NP1,  NP2,   NP3,   LDON1, LDON2, LDON3, NL1MOD,
     .           RNH4, RNO3
        INTEGER  F


C NITRIFICATION

        DO B=1,NB
        
********* Temperature effect

          IF (T(B).LT.TMNT) THEN
            FTN = EXP(-KTNT1*(T(B)-TMNT)**2)
          ELSE
            FTN = EXP(-KTNT2*(TMNT-T(B))**2)
          END IF

          NT(B) = DO(B)/(KHONT+DO(B))*NH4(B)/(KHNNT+NH4(B))*FTN*NTM(B)

        END DO

        DO 10000 B=1,NB

********* Algal nitrogen preference

          RNH4 = MAX(NH4(B),0.)
	  RNO3 = MAX(NO3(B),0.)
          PN1(B) = RNH4*(RNO3/((KHNH41+RNH4)*(KHNH41+RNO3))
     .           + KHNH41/((1.E-10+RNH4+RNO3)*(KHNH41+RNO3)))
          PN2(B) = RNH4*(RNO3/((KHNH42+RNH4)*(KHNH42+RNO3))
     .           + KHNH42/((1.E-10+RNH4+RNO3)*(KHNH42+RNO3)))
          PN3(B) = RNH4*(RNO3/((KHNH43+RNH4)*(KHNH43+RNO3))
     .           + KHNH43/((1.E-10+RNH4+RNO3)*(KHNH43+RNO3)))


********* Algal sources/sinks

          NP1 = ANC1*(P1(B)*PRSP1+BM1(B))*B1(B)
          NP2 = ANC2*(P2(B)*PRSP2+BM2(B))*B2(B)          
          NP3 = ANC3*(P3(B)*PRSP3+BM3(B))*B3(B)          
          NH4A1 = FNI1*NP1-PN1(B)*P1(B)*ANC1*B1(B)+FNIP*PR1(B)*ANC1
          NH4A2 = FNI2*NP2-PN2(B)*P2(B)*ANC2*B2(B)+FNIP*PR2(B)*ANC2
          NH4A3 = FNI3*NP3-PN3(B)*P3(B)*ANC3*B3(B)+FNIP*PR3(B)*ANC3
          NO3A1      = (PN1(B)-1.)*P1(B)*ANC1*B1(B)
          NO3A2      = (PN2(B)-1.)*P2(B)*ANC2*B2(B)
          NO3A3      = (PN3(B)-1.)*P3(B)*ANC3*B3(B)
          LDON1      = FNLD1*NP1+FNLDP*PR1(B)*ANC1
          LDON2      = FNLD2*NP2+FNLDP*PR2(B)*ANC2
          LDON3      = FNLD3*NP3+FNLDP*PR3(B)*ANC3
          RDON1      = FNRD1*NP1+FNRDP*PR1(B)*ANC1
          RDON2      = FNRD2*NP2+FNRDP*PR2(B)*ANC2
          RDON3      = FNRD3*NP3+FNRDP*PR3(B)*ANC3
          LPON1     = FNLP1*NP1+FNLPP*PR1(B)*ANC1
          LPON2     = FNLP2*NP2+FNLPP*PR2(B)*ANC2
          LPON3     = FNLP3*NP3+FNLPP*PR3(B)*ANC3
          RPON1     = FNRP1*NP1+FNRPP*PR1(B)*ANC1
          RPON2     = FNRP2*NP2+FNRPP*PR2(B)*ANC2
          RPON3     = FNRP3*NP3+FNRPP*PR3(B)*ANC3
          G3PON1    = FNG31*NP1+FNG3P*PR1(B)*ANC1
          G3PON2    = FNG32*NP2+FNG3P*PR2(B)*ANC2
          G3PON3    = FNG33*NP3+FNG3P*PR3(B)*ANC3
          ALGNH4(B) = NH4A1+NH4A2+NH4A3
          ALGNO3(B) = NO3A1+NO3A2+NO3A3
          ALGDON(B) = LDON1+LDON2+LDON3+RDON1+RDON2+RDON3
          ALGPON(B) = LPON1+LPON2+LPON3+RPON1+RPON2+RPON3
     $                +G3PON1+G3PON2+G3PON3

********* Mineralization and hydrolysis

          MNLLDON(B) = KLDN(B)*FTMNL(B)*LDON(B)
          MNLRDON(B) = KRDN(B)*FTMNL(B)*RDON(B)
          HDRLPON(B) = KLPN(B)*FTHDR(B)*LPON(B)
          HDRRPON(B) = KRPN(B)*FTHDR(B)*RPON(B)
          HDRG3PON(B)= KG3N(B)*FTHDR(B)*G3PON(B)
          DENNO3(B)  = -ANDC*DENIT(B)

********* Change in nitrogen species

          DTNH4(B)  = (NH4A1+NH4A2+NH4A3+MNLLDON(B)+MNLRDON(B)-NT(B))
     $                /86400.
          DTNO3(B)  = (NT(B)-ANDC*DENIT(B)+NO3A1+NO3A2+NO3A3)/86400.
          DTLDON(B) = (LDON1+LDON2+LDON3-MNLLDON(B)+HDRLPON(B)
     $                +HDRRPON(B)+HDRG3PON(B))/86400.
          DTRDON(B) = (RDON1+RDON2+RDON3-MNLRDON(B))/86400.
          DTLPON(B) = (LPON1+LPON2+LPON3-HDRLPON(B))/86400.
          DTRPON(B) = (RPON1+RPON2+RPON3-HDRRPON(B))/86400.
          DTG3PON(B) = (G3PON1+G3PON2+G3PON3-HDRG3PON(B))/86400.

10000   CONTINUE

        DO B=1,NB

********* Settling

          LPSETL = (WSL(BU(B))*LPON(BU(B))-WSL(B)*LPON(B))/BL(B,3)
          RPSETL = (WSR(BU(B))*RPON(BU(B))-WSR(B)*RPON(B))/BL(B,3)
          G3SETL = (WSG3(BU(B))*G3PON(BU(B))-WSG3(B)*G3PON(B))/BL(B,3)
          DTLPON(B) = DTLPON(B)+LPSETL/86400.
          DTRPON(B) = DTRPON(B)+RPSETL/86400.
          DTG3PON(B) = DTG3PON(B)+G3SETL/86400.

        END DO

********* Settling flux   g/s

      IF (S_TRANS_FLUX) THEN
        DO F=NHQF+1,NQF
	  B = JB(F)
          FLXSLPON(F) = -WSL(B)*LPON(B)*V2(B)/(BL(B,3)*86400.)
          FLXSRPON(F) = -WSR(B)*RPON(B)*V2(B)/(BL(B,3)*86400.)
          FLXSG3PON(F) = -WSG3(B)*G3PON(B)*V2(B)/(BL(B,3)*86400.)
        END DO
      END IF

******* Benthic fluxes

        DO 10010 B=1,NBB
          DTNH4(BBN(B))  = DTNH4(BBN(B))+BENNH4(B)/BL(BBN(B),3)/86400.
          DTNO3(BBN(B))  = DTNO3(BBN(B))+BENNO3(B)/BL(BBN(B),3)/86400.
          DTLDON(BBN(B)) = DTLDON(BBN(B))+BENDON(B)/BL(BBN(B),3)/86400.
10010   CONTINUE

******* Net Settling

        IF (SEDIMENT_CALC) THEN

          DO 10020 B=1,NBB
            DTLPON(BBN(B)) = DTLPON(BBN(B))+(WSL(BBN(B))-WSLNET(B))
     .                       *LPON(BBN(B))/BL(BBN(B),3)/86400.
            DTRPON(BBN(B)) = DTRPON(BBN(B))+(WSR(BBN(B))-WSRNET(B))
     .                       *RPON(BBN(B))/BL(BBN(B),3)/86400.
            DTG3PON(BBN(B)) = DTG3PON(BBN(B))+(WSG3(BBN(B))-WSG3NET(B))
     .                       *G3PON(BBN(B))/BL(BBN(B),3)/86400.

10020     CONTINUE
        END IF

******* SAV and epiphytes

cvjp modified 11/3/2005
        IF (SAV_CALC) THEN
          DO 10030 I=1,NSAVCELL
            B=SAVCELL(I)
            DTNH4(B)   = DTNH4(B)+(NH4SAVW(B)+NH4EPI(B))
     $                      /BL(B,3)/86400.
            DTNO3(B)   = DTNO3(B)+(NO3SAVW(B)+NO3EPI(B))
     $                      /BL(B,3)/86400.
            DTLDON(B)  = DTLDON(B)+(LDONSAVW(B)+LDONEPI(B))
     $                      /BL(B,3)/86400.
            DTRDON(B)  = DTRDON(B)+(RDONSAVW(B)+RDONEPI(B))
     $                      /BL(B,3)/86400.
            DTLPON(B)  = DTLPON(B)+(LPONSAVW(B)+LPONEPI(B))
     $                      /BL(B,3)/86400.
            DTRPON(B)  = DTRPON(B)+(RPONSAVW(B)+RPONEPI(B))
     $                      /BL(B,3)/86400.
            DTG3PON(B) = DTG3PON(B)+(G3NSAVW(B)+G3NEPI(B))
     $                      /BL(B,3)/86400.
10030     CONTINUE
        END IF

******* Atmospheric Loads

        DO 10040 B=1,NSB
          DTNH4(SBN(B)) = DTNH4(SBN(B))+PRECIP*ATMNH4/BL(SBN(B),3)
          DTNO3(SBN(B)) = DTNO3(SBN(B))+PRECIP*ATMNO3/BL(SBN(B),3)
          DTLDON(SBN(B))= DTLDON(SBN(B))+PRECIP*ATMLDON/BL(SBN(B),3)
          DTRDON(SBN(B))= DTRDON(SBN(B))+PRECIP*ATMRDON/BL(SBN(B),3)
10040   CONTINUE

      END

************************************************************************
**                 S U B R O U T I N E   P H O S P H                  **
************************************************************************

      SUBROUTINE PHOSPH
        USE WQM
	USE MOD_SEDIMENT
        REAL     KLDOP, LPOP1, LPOP2, LPOP3, LPSETL,
     $           LDOP1, LDOP2, LDOP3, ISS,   DSPO4, JD
        INTEGER  F

C DETERMINE JULIAN DAY FOR PO4 SETTLING
        JD    = AMOD(JDAY,365.25)
	IF (JD .GE. JBSPO4 .AND. JD .LE. JESPO4) THEN
	  SPO4 = 1.0
	ELSE
	  SPO4 = 0.0
	END IF   

        DO 10000 B=1,NB

********* Algae sources/sinks

          PP1 = APC1*(P1(B)*PRSP1+BM1(B))*B1(B)
          PP2 = APC2*(P2(B)*PRSP2+BM2(B))*B2(B)
          PP3 = APC3*(P3(B)*PRSP3+BM3(B))*B3(B)
          PO41 = FPI1*PP1-P1(B)*APC1*B1(B)+FPIP*PR1(B)*APC1
          PO42 = FPI2*PP2-P2(B)*APC2*B2(B)+FPIP*PR2(B)*APC2
          PO43 = FPI3*PP3-P3(B)*APC3*B3(B)+FPIP*PR3(B)*APC3
          LDOP1     = FPLD1*PP1+FPLDP*PR1(B)*APC1 
          LDOP2     = FPLD2*PP2+FPLDP*PR2(B)*APC2
          LDOP3     = FPLD3*PP3+FPLDP*PR3(B)*APC3
          RDOP1     = FPRD1*PP1+FPRDP*PR1(B)*APC1 
          RDOP2     = FPRD2*PP2+FPRDP*PR2(B)*APC2
          RDOP3     = FPRD3*PP3+FPRDP*PR3(B)*APC3
          LPOP1     = FPLP1*PP1+FPLPP*PR1(B)*APC1
          LPOP2     = FPLP2*PP2+FPLPP*PR2(B)*APC2
          LPOP3     = FPLP3*PP3+FPLPP*PR3(B)*APC3
          RPOP1     = FPRP1*PP1+FPRPP*PR1(B)*APC1
          RPOP2     = FPRP2*PP2+FPRPP*PR2(B)*APC2
          RPOP3     = FPRP3*PP3+FPRPP*PR3(B)*APC3
          G3POP1    = FPG31*PP1+FPG3P*PR1(B)*APC1
          G3POP2    = FPG32*PP2+FPG3P*PR2(B)*APC2
          G3POP3    = FPG33*PP3+FPG3P*PR3(B)*APC3
          ALGPO4(B) = PO41+PO42+PO43
          ALGDOP(B) = LDOP1+LDOP2+LDOP3+RDOP1+RDOP2+RDOP3
          ALGPOP(B) = LPOP1+LPOP2+LPOP3+RPOP1+RPOP2+RPOP3
     $                 +G3POP1+G3POP2+G3POP3

********* Mineralization and hydrolysis

          ALGCAR  = B1(B)+B2(B)+B3(B)
	  IF (SEDKIN .EQ. 'SSI') THEN
            DF      = 1./(1.+KADPO4*SSI(B))
	  ELSE
            DF      = 1./(1.+KADPO4*SEDCLY(B))
	  END IF
          PO4AVL  = MAX(1.E-6,DF*PO4(B))
          KLDOP   = KLDP(B)+KDPALG(B)*ALGCAR*KHPAVG/(KHPAVG+PO4AVL)
          MNLLDOP(B) = KLDOP*FTMNL(B)*LDOP(B)
          MNLRDOP(B) = KRDP(B)*FTMNL(B)*RDOP(B)
          HDRLPOP(B) = KLPP(B)*FTHDR(B)*LPOP(B)
          HDRRPOP(B) = KRPP(B)*FTHDR(B)*RPOP(B)
          HDRG3POP(B) = KG3P(B)*FTHDR(B)*G3POP(B)

********* Change in phosphorus species

          DTPO4(B)  = (PO41+PO42+PO43+MNLLDOP(B)+MNLRDOP(B))
     $                /86400.
          DTLDOP(B) = (LDOP1+LDOP2+LDOP3-MNLLDOP(B)+HDRLPOP(B)
     $                +HDRRPOP(B)+HDRG3POP(B))/86400.
          DTRDOP(B) = (RDOP1+RDOP2+RDOP3-MNLRDOP(B))/86400.
          DTLPOP(B) = (LPOP1+LPOP2+LPOP3-HDRLPOP(B))/86400.
          DTRPOP(B) = (RPOP1+RPOP2+RPOP3-HDRRPOP(B))/86400.
          DTG3POP(B) = (G3POP1+G3POP2+G3POP3-HDRG3POP(B))/86400.
         
10000   CONTINUE

        DO B=1,NB

********* Settling

          IF (SEDKIN .EQ. 'SSI') THEN
            PFU    = KADPO4*SSI(BU(B))/(1.+KADPO4*SSI(BU(B)))
            PPU    = PFU*PO4(BU(B))
            PFD    = KADPO4*SSI(B)/(1.+KADPO4*SSI(B))
            PPD    = PFD*PO4(B)
            PO4SET = (WSS(BU(B))*PPU-WSS(B)*PPD)/BL(B,3)/86400.
	  ELSE
            PFU    = KADPO4*SEDCLY(BU(B))*PO4(BU(B))*WSED(1,1)
     $               /(1.+KADPO4*SEDCLY(BU(B)))
            PFD    = KADPO4*SEDCLY(B)*PO4(B)*WSED(1,1)
     $               /(1.+KADPO4*SEDCLY(B))
            PO4SET = (PFU - PFD)/BL(B,3)
            FLXSPO4(B) = PFD*V2(B)/BL(B,3)
	  END IF	
	  
C direct settling (removal) of PO4

          DSPO4  = SPO4 * (WSPO4(BU(B))*PO4(BU(B))-WSPO4(B)*PO4(B))
     $              /BL(B,3)/86400.
          LPSETL = (WSL(BU(B))*LPOP(BU(B))-WSL(B)*LPOP(B))/BL(B,3)
          RPSETL = (WSR(BU(B))*RPOP(BU(B))-WSR(B)*RPOP(B))/BL(B,3)
          G3SETL = (WSG3(BU(B))*G3POP(BU(B))-WSG3(B)*G3POP(B))/BL(B,3)          
          DTPO4(B)  = DTPO4(B)+PO4SET+DSPO4
          DTLPOP(B) = DTLPOP(B)+LPSETL/86400.
          DTRPOP(B) = DTRPOP(B)+RPSETL/86400.
          DTG3POP(B) = DTG3POP(B)+G3SETL/86400.

        END DO

********* Settling flux   g/s

      IF (S_TRANS_FLUX) THEN
        DO F=NHQF+1,NQF
	  B = JB(F)
          FLXSLPOP(F) = -WSL(B)*LPOP(B)*V2(B)/(BL(B,3)*86400.)
          FLXSRPOP(F) = -WSR(B)*RPOP(B)*V2(B)/(BL(B,3)*86400.)
          FLXSG3POP(F) = -WSG3(B)*G3POP(B)*V2(B)/(BL(B,3)*86400.)
          PPU    = PO4(B)*KADPO4*SSI(B)/(1.+KADPO4*SSI(B))
	  FLXSPO4(F)  = -WSS(B)*PPU*V2(B)/(BL(B,3)*86400.)
     $      -SPO4*WSPO4(B)*PO4(B)*V2(B)/(BL(B,3)*86400.)
        END DO
      END IF
     
******* Benthic fluxes

        DO 10010 B=1,NBB
          DTPO4(BBN(B))  = DTPO4(BBN(B))+BENPO4(B)/BL(BBN(B),3)/86400.
          DTLDOP(BBN(B)) = DTLDOP(BBN(B))+BENDOP(B)/BL(BBN(B),3)/86400.
10010   CONTINUE

******* Net Settling

C        IF (SEDIMENT_CALC .AND. SEDKIN .EQ. 'SSI') THEN
        IF (SEDIMENT_CALC) THEN

          DO 10020 B=1,NBB
            PF = KADPO4*SSI(BBN(B))/(1.+KADPO4*SSI(BBN(B)))
            PP = PF*PO4(BBN(B))
            DTPO4(BBN(B))  = DTPO4(BBN(B))+(WSS(BBN(B))-WSSNET(B))*PP
     .                       /BL(BBN(B),3)/86400.
            DTLPOP(BBN(B)) = DTLPOP(BBN(B))+(WSL(BBN(B))-WSLNET(B))
     .                       *LPOP(BBN(B))/BL(BBN(B),3)/86400.
            DTRPOP(BBN(B)) = DTRPOP(BBN(B))+(WSR(BBN(B))-WSRNET(B))
     .                       *RPOP(BBN(B))/BL(BBN(B),3)/86400.
            DTG3POP(BBN(B)) = DTG3POP(BBN(B))+(WSG3(BBN(B))-WSG3NET(B))
     .                       *G3POP(BBN(B))/BL(BBN(B),3)/86400.
10020     CONTINUE

        END IF

******* SAV and epiphytes

cvjp modified 11/3/2005
        IF (SAV_CALC) THEN
          DO 10030 I=1,NSAVCELL
            B=SAVCELL(I)
            DTPO4(B)   = DTPO4(B)+(PO4SAVW(B)+PO4EPI(B))
     $                      /BL(B,3)/86400.
            DTLDOP(B)  = DTLDOP(B)+(LDOPSAVW(B)+LDOPEPI(B))
     $                      /BL(B,3)/86400.
            DTRDOP(B)  = DTRDOP(B)+(RDOPSAVW(B)+RDOPEPI(B))
     $                      /BL(B,3)/86400.
            DTLPOP(B)  = DTLPOP(B)+(LPOPSAVW(B)+LPOPEPI(B))
     $                      /BL(B,3)/86400.
            DTRPOP(B)  = DTRPOP(B)+(RPOPSAVW(B)+RPOPEPI(B))
     $                      /BL(B,3)/86400.
            DTG3POP(B) = DTG3POP(B)+(G3PSAVW(B)+G3PEPI(B))
     $                      /BL(B,3)/86400.
10030     CONTINUE
        END IF

******* Atmospheric loads

        DO 10040 B=1,NSB
          DTPO4(SBN(B)) = DTPO4(SBN(B))+PRECIP*ATMPO4/BL(SBN(B),3)
          DTLDOP(SBN(B))= DTLDOP(SBN(B))+PRECIP*ATMLDOP/BL(SBN(B),3)
          DTRDOP(SBN(B))= DTRDOP(SBN(B))+PRECIP*ATMRDOP/BL(SBN(B),3)
10040   CONTINUE

******* Particulate Inorganic Phosphorus

        IF (PIP_CALC) THEN

******  Settling and PO4 release
          DO B=1,NB
              DTPIP(B)  = (WSPIP(BU(B))*PIP(BU(B))-WSPIP(B)*PIP(B))
     .                 /(BL(B,3)*86400.)
     .                 - KDPIP(B)*PIP(B)/86400.
              DTPO4(B) = DTPO4(B) + KDPIP(B)*PIP(B)/86400.
          END DO

          IF (S_TRANS_FLUX) THEN    !g/s
            DO F=NHQF+1,NQF
	      B = JB(F)
              FLXSPIP(F) = -WSPIP(B)*PIP(B)*V2(B)/(BL(B,3)*86400.)
            END DO
          END IF
	  
******  Net Settling

          IF (SEDIMENT_CALC) THEN
            DO B=1,NBB
                DTPIP(BBN(B)) = DTPIP(BBN(B))+(WSPIP(BBN(B))
     .         -WSPIPNET(B))*PIP(BBN(B))/BL(BBN(B),3)/86400.
            END DO
          END IF

        END IF
        
      END
      

************************************************************************
**                S U B R O U T I N E   C O D M N D                   **
************************************************************************

      SUBROUTINE CODMND
        USE WQM

******* Change in chemical oxygen demand

        DO 10000 B=1,NB
          FTCOD(B) = KCOD(B)*EXP(KTCOD*(T(B)-TRCOD))
          DTCOD(B) = (-DO(B)/(KHOCOD+DO(B))*FTCOD(B)*COD(B)
     $             + AOCR*CODMNL(B))/86400.
10000   CONTINUE

******* Sediment demand

        DO 10010 B=1,NBB
          DTCOD(BBN(B)) = DTCOD(BBN(B))+BENCOD(B)/BL(BBN(B),3)/86400.
10010   CONTINUE

      END

************************************************************************
**                 S U B R O U T I N E   O X Y G E N                  **
************************************************************************

      SUBROUTINE OXYGEN
        USE WQM
        real :: satdo

        DO 10000 B=1,NB

********* Nitrification

          NITRIF(B) = AONT*NT(B)

********* Uptake/respiration

          FRDO1  = (1.-FCLD1-FCRD1-FCLP1-FCRP1-FCG31)*DO(B)/(KHR1+DO(B))
          FRDO2  = (1.-FCLD2-FCRD2-FCLP2-FCRP2-FCG32)*DO(B)/(KHR2+DO(B))
          FRDO3  = (1.-FCLD3-FCRD3-FCLP3-FCRP3-FCG33)*DO(B)/(KHR3+DO(B))
          CP1    = P1(B)*PRSP1+BM1(B)
          CP2    = P2(B)*PRSP2+BM2(B)
          CP3    = P3(B)*PRSP3+BM3(B)
          ALGDO  = (FRDO1*CP1*B1(B)+FRDO2*CP2*B2(B)              !            CFC 10/20/99
     $               +FRDO3*CP3*B3(B))*AOCR
          DOR1   = ((1.3-0.3*PN1(B))*P1(B)-FRDO1*CP1)*AOCR*B1(B)
          DOR2   = ((1.3-0.3*PN2(B))*P2(B)-FRDO2*CP2)*AOCR*B2(B)          
          DOR3   = ((1.3-0.3*PN3(B))*P3(B)-FRDO3*CP3)*AOCR*B3(B)
          DOP1   = FDOP*PR1(B)*AOCR*DO(B)/(KHR1+DO(B))
          DOP2   = FDOP*PR2(B)*AOCR*DO(B)/(KHR2+DO(B))
          DOP3   = FDOP*PR3(B)*AOCR*DO(B)/(KHR3+DO(B))
          DOPR(B)  = DOP1+DOP2+DOP3
          DCOD(B)  = DO(B)/(KHOCOD+DO(B))*FTCOD(B)*COD(B)
          DDOC(B)  = AOCR*(MNLLDOC(B)+MNLRDOC(B))
          DORALG(B)= DOR1+DOR2+DOR3

********* Change in dissolved oxygen

          DTDO(B)  = (DOR1+DOR2+DOR3-DOP1-DOP2-DOP3-DDOC(B)-DCOD(B)
     $               -NITRIF(B))/86400.
          RESP(B)  = ALGDO + DOPR(B)
     $               +DDOC(B)+DCOD(B)+NITRIF(B)                  !         CFC 10/20/99

10000   CONTINUE

******* Reaeration

        DO 10010 B=1,NSB
          DOS     = satdo(salt(b),t(b))
          DTDO(B) = DTDO(B)+KRDO(B)/BL(SBN(B),3)*(DOS-DO(B))/86400.
10010   CONTINUE

******* Sediment oxygen demand

        DO 10020 B=1,NBB
          DTDO(BBN(B)) = DTDO(BBN(B))+BENDO(B)/BL(BBN(B),3)/86400.
10020   CONTINUE


******* SAV and epiphytes

cvjp modified 11/3/2005
        IF (SAV_CALC) THEN
          DO 10030 I=1,NSAVCELL
            B=SAVCELL(I)
            DTDO(B) = DTDO(B)+(DOSAV(B)+DOEPI(B)+SEDDOSAV(B))
     $                  /BL(B,3)/86400.
10030     CONTINUE
        END IF

      END

************************************************************************
**               S U B R O U T I N E   B E N C O M P                  **
************************************************************************

      SUBROUTINE BEN_FLUX
        USE WQM

        DO 10000 B=1,NBB

          BB = BBN(B)

******* Calculate temperature effects

          FTSOD    = EXP(KSO*(T(BB)-TRSO))
          FTNH4    = EXP(KSNH4*(T(BB)-TRSNH4))
          FTNO3    = EXP(KSNO3*(T(BB)-TRSNO3))
          FTPO4    = EXP(KSPO4*(T(BB)-TRSPO4))
          FTDOC    = EXP(KSDOC*(T(BB)-TRSDOC))

********* Dissolved oxygen effect on sediment oxygen demand

          BENDO(B) = BENDOB(B)*FTSOD*DO(BB)/(KHSO+DO(BB))
          BENCOD(B) = BENCODB(B)-BENDOB(B)*FTSOD*KHSO/(KHSO+DO(BB))

********* Balance of nutrients

          BENNH4(B) = BENNH4B(B)*FTNH4
          BENNO3(B) = BENNO3B(B)+FTNO3*MTCNO3*(SEDNO3-NO3(BB))
          BENPO4(B) = BENPO4B(B)*FTPO4
          BENDOC(B) = BENDOCB(B)*FTDOC

10000   CONTINUE

******* Compute particle flux to sediments for mass-balance purposes

      DO 10060 B=1,NBB

        BB = BBN(B)

******* First zero flux accumlators

        PCFWS(B) = 0.
        PNFWS(B) = 0.
        PPFWS(B) = 0.

******* Now accumulate fluxes of labile and refractory particles

        PPFWS(B) = PPFWS(B)-WSL(BB)*LPOP(BB)-WSR(BB)*RPOP(BB)-WSG3(BB)*G3POP(BB)
        PNFWS(B) = PNFWS(B)-WSL(BB)*LPON(BB)-WSR(BB)*RPON(BB)-WSG3(BB)*G3PON(BB)
        PCFWS(B) = PCFWS(B)-WSL(BB)*LPOC(BB)-WSR(BB)*RPOC(BB)-WSG3(BB)*G3POC(BB)

******* Now accumulate fluxes of algal biomass

        PPFWS(B) = PPFWS(B)-APC1*WS1(BB)*B1(BB)-APC2*WS2(BB)*B2(BB)
     .                 -APC3*WS3(BB)*B3(BB)
        PNFWS(B) = PNFWS(B)-WS1(BB)*ANC1*B1(BB)-WS3(BB)*ANC3*B3(BB)
     .                 -WS2(BB)*ANC2*B2(BB)
        PCFWS(B) = PCFWS(B)-WS1(BB)*B1(BB)-WS2(BB)*B3(BB)
     .                 -WS2(BB)*B2(BB)

******* Accumulate adsorbed phosphate

        PF           = KADPO4*SSI(BB)/(1.+KADPO4*SSI(BB))
        PIOP          = PF*PO4(BB)
        PPFWS(B)     = PPFWS(B)-WSS(BB)*PIOP

10060 CONTINUE

      END

      SUBROUTINE KE_CALC
      USE WQM
      IMPLICIT NONE
      INTEGER SB, F
      real totchl, totpoc, iattop, optdepth, ISS

C EVALUATE ATTENUATION FOR EACH SURFACE CELL
C MODIFIED BY CFC FOR Ches_2015_Run_2.  KE NOW DEPENDS ON SALINITY  01/18/13

      DO B=1,NSB
        TOTCHL   = B1(B)/CCHLC1 + B2(B)/CCHLC2 + B3(B)/CCHLC3
        TOTPOC   = B1(B)+B2(B)+B3(B)+LPOC(B)+RPOC(B)+G3POC(B)
	IF (SEDKIN .EQ. 'SSI') THEN
          ISS = SSI(B)  
	ELSE
	  ISS = SEDCLY(B)+SEDSLT(B)+SEDSND(B)+SEDORG(B) 
	END IF
        KESS(B)  = KE(B) + KEISS(B)*ISS + KEVSS(B)*VSStoPOC*TOTPOC
     $               + KECHL*TOTCHL + KESAL*SALT(B)  
        KESS(B) = MAX(0.15,KESS(B))
      END DO
      
C ASSIGN SURFACE ATTENUATION TO SUB-SURFACE CELLS

      DO SB=1,NSB
        DO F=1,NVF(SB)
          KESS(IB(VFN(F,SB))) = KESS(SB)
        END DO
      END DO
      
C       *** Compute irradiance in each cell 

      DO B=1,NSB
        IATTOP = I0
        OPTDEPTH = KESS(B)*BL(B,3)
        IATBOT(B) = IATTOP*EXP(-OPTDEPTH)
        IAVG(B) = (IATTOP-IATBOT(B))/OPTDEPTH
      END DO 

      IF (NB .GT. NSB) THEN
        DO B=NSB+1,NB
          IATTOP = IATBOT(BU(B))
          OPTDEPTH = KESS(B)*BL(B,3)
          IATBOT(B) = IATTOP*EXP(-OPTDEPTH)
          IAVG(B) = (IATTOP-IATBOT(B))/OPTDEPTH
        END DO
      END IF
      
      END

************************************************************************
**         S U B R O U T I N E   R E A E R A T I O N                  **
************************************************************************

      SUBROUTINE REAERATION
        USE WQM
        integer f 
        REAL vel(0:nsbp)

        vel(0:nsb) = 0.0
        FACTOR = AREAR*(BREAR*WMS)**CREAR

        if (erear .eq. '    WIND') then
          do b=1,nsb
            RNU          = 0.54 + 0.7*T(B)/30 - 0.07*SALT(B)/35.
            KRDO(b)      = FACTOR*RNU
          end do
        else if (erear .eq. '    VELO') then        

c base reaeration on the maximum velocity at all flow faces in a cell
c I see no way to find a meaningful average velocity for a cell
          do f=1,nsqf
            vel(ib(f)) = max(vel(ib(f)),abs(q(f))/a(f))
            vel(jb(f)) = max(vel(jb(f)),abs(q(f))/a(f))
          end do

c take velocity over depth
          do b=1,nsb
            krdo(b) = drear*sqrt(vel(b)/(zd(bbn(b))+bl(bbn(b),3)))
          end do
        end if
   
c        do b=1,nsb
c          write(666,*) b, vel(b), zd(bbn(b))+bl(bbn(b),3),
c     $      krdo(b)          
c        end do

      end


