************************************************************************
**                                                                    **
**                           CE-QUAL-IC                               **
**                                                                    **
**                    An Integrated Compartment                       **
**                       Water Quality Model                          **
**                                                                    **
**                          Version 2.0.2                             **
**                          Feb. 8, 2011                              **
**                                                                    **
**                           Developed by                             **
**                                                                    **
**             Carl F. Cerco      : Water quality scheme              **
**             Raymond S. Chapman : Numerical solution scheme         **
**             Thomas M. Cole     : Computer algorithms & coding      **
**             Hydroqual          : Sediment compartment              **
**             MPI code           : Victor Parr                       **
**                                                                    **
**                    Water Quality Modeling Group                    **
**                    U.S. Army Corps of Engineers                    **
**                    Waterways Experiment Station                    **
**                    Vicksburg, Mississippi 39180                    **
**                                                                    **
************************************************************************

      PROGRAM  PARWQM      
      USE FILE_INFO; USE WQM; USE WQM_INIT
      USE ALGAL; USE SED; USE sediment_mod
!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
      USE MESSENGER
#endif
!.... PARALLEL SECTION ENDS
      IMPLICIT NONE
      integer :: j, jf, jg, jc, k, l, n
      integer :: i, ii, isf, jp, jnp
      integer :: js1, js2, js3
      real     vtheta                           ! TKG 8-2001
      real :: satdo

************************************************************************
**                       Program Initialization                       **
************************************************************************


!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
      CALL COMM_INIT(MYPROC)   !  Init MPI, get MPI_rank, Read Comm Tables
#endif
!.... PARALLEL SECTION ENDS

      ! <ezpp-begin>

      CALL INIT_FILE_INFO()    !  Setup WQM file information

      CALL INPUTS()            !  Initialze WQM

************************************************************************
**                          Begin Simulation                          **
************************************************************************

!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
      CALL COMM_CONCS()      ! Initialize concentrations in ghost blocks
      CALL WAIT_CONCS()
#endif
!.... PARALLEL SECTION ENDS
 
      
10500 IF (.NOT.END_RUN) THEN

        ! <ezpp-user name="timestep">

*******  time-varying kinetics data

        IF (JDAY.GE.NXTVD) CALL TVDS (NXTVD)

******* Interpolate boundary concentrations

        IF (.NOT.STEP_BOUNDARY) THEN
          RATIO = (JDAY-OLDNXCBC)/(NXCBC-OLDNXCBC)  
          DO 10503 JC=1,NAC
             II=AC(JC)
             DO 10502 JCB=1,NCB
             CB(JCB,II) = (1.0-RATIO)*CBOLD(JCB,II)+RATIO*CBNX(JCB,II)
10502        CONTINUE
10503     CONTINUE
        END IF
      
        dltn = dlt                                          !TKG 4-2002
           
******* Update flows


        IF (NINT(ELTMS) >= NXHYD)  THEN
            CALL HYDRO()
!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
            CALL COMM_CONCS
            CALL WAIT_CONCS
#endif
!.... PARALLEL SECTION ENDS

            IF (AUTO_STEPPING) CALL AUTOSTEP()
        ENDIF

        ELTMS1 = REAL(ELTMS,8)
        !DLT8   = MIN(DLT8,NXHYDDP-ELTMS1) flag
        DLT8   = MIN(DLT8,NXHYD-ELTMS1)
        DLT    = REAL(DLT8,4)

c       if (myproc == 0)
c    .     write(*,'(A30,2(2X,F8.3))') "dlt8  nxhyddp-eltms1 = ",
c    .     DLT8,NXHYDDP-ELTMS1   

******* Time-variable solar radiation

C       TIME OF DAY (SECONDS)
        RELTMS = ELTMS
        TODS = MOD(RELTMS,86400.)
        IF (TODS .LT. TTSS) THEN
          I0 = 0.
        ELSE
C         DAYS SINCE SUNRISE (DAYS)
          DSSR = (TODS-TTSS)/86400.
          I0 = 3.1416*IT*SIN(3.1416*DSSR/FD)/2./FD
          I0 = MAX(I0,0.)
        END IF

C HARDWIRE LIGHT HERE
C        I0 = 1.0

******* Light Attenuation

        IF (SAV_CALC .OR. ALGAE_CALC) THEN
          IF (I0 .GT. 0.) CALL KE_CALC
        END IF

******* SAV Submodel

        IF (SAV_CALC) THEN
          CALL SAV_COMP
        ENDIF

******* Sediment kinetics

        IF (SEDIMENT_CALC) THEN
           CALL SED_CALC
        ELSE IF (BENTHIC_FLUXES) THEN
           CALL BEN_FLUX
        END IF

******* Sediment Transport

        IF (SEDTR_CALC) THEN
          CALL SED_STL        ! calculate settling
          CALL SEDIMENT()     ! calculate resuspension and bed
        ENDIF


******* Water column kinetics
        ! <ezpp-user name = "wc_kinetics">
        IF (TEMPERATURE_CALC) CALL TEMPER
        IF (SOLIDS_CALC)      CALL SOLIDS
        IF (ALGAE_CALC)       CALL ALGAE
        IF (CARBON_CALC)      CALL CARBON
        IF (NITROGEN_CALC)    CALL NITROG
        IF (PHOSPHORUS_CALC)  CALL PHOSPH
        IF (COD_CALC)         CALL CODMND
        IF (OXYGEN_CALC)      THEN
          IF (EREAR .NE. '   INPUT') CALL REAERATION            ! CFC 08/24/15
          CALL OXYGEN
        END IF

        IF (SFEEDER)          THEN
          DO N=1,NSPECIES
            CALL SUSPFEED(N)
          END DO
        END IF

********Wetlands Calculations

        if (wtlmc .eq. ' ON') call calc_wetlands ()
C
C       *** Convert water column change in concentration to change in mass
C
        DO 10520 JC=1,NAC
          II=AC(JC)
          DO 10510 B=1,NB
            DTM(B,II) = DTC(B,II)*V1(B)
10510     CONTINUE
10520   CONTINUE
C
C       *** Change in mass due to Source One
C
        IF (SOURCE_ONE) THEN              !MNOEL   1-25-93
          DO 10540 JC=1,NAC
            II=AC(JC)
            DO 10530 JP=1,S1LN(II)
              DTM(S1LB(JP,II),II) = DTM(S1LB(JP,II),II)+S1L(JP,II)
10530       CONTINUE
10540     CONTINUE
        END IF
C
C       *** Change in mass due to Source Two       
C
        IF (SOURCE_TWO) THEN              !MNOEL   1-25-93
          DO 10560 JC=1,NAC
            II=AC(JC)
            DO 10550 JP=1,S2LN(II)
              DTM(S2LB(JP,II),II) = DTM(S2LB(JP,II),II)+S2L(JP,II)
10550       CONTINUE
10560     CONTINUE
        END IF

C
C       *** Change in mass due to Source Three       
C
        IF (SOURCE_THR) THEN             
          DO JC=1,NAC
            II=AC(JC)
            DO JP=1,S3LN(II)
              DTM(S3LB(JP,II),II) = DTM(S3LB(JP,II),II)+S3L(JP,II)
            END DO
          END DO
        END IF

C
C      *** Assign temperature and DO to Lateral inflows 
C
       DO B=1,NB
         CONLIT(B,1) = TE
       END DO

       DOS = satdo(0.,te)  

       DO B=1,NB
         CONLIT(B,27) = DOS
       END DO

       DO 10580 JC=1,NAC
         II=AC(JC)
         DO 10570 B=1,NB
           DTM(B,II) = DTM(B,II)+(QLIT(B)*CONLIT(B,II))
10570    CONTINUE
10580  CONTINUE


******* Update geometry

        IF (.NOT. ASCII_HYDRO) THEN
C
C         *** Update WQM volumes
C
          IF (SIGMA_HYDRO) THEN 
            DO L=1,NSB                        !JLM FOR LOWER ST. JOHNS (NET EVAPORATION/PRECIPITATION)
              V2(L)= V2(L)+RNMEVP(L)*DLT      !JLM FOR LOWER ST. JOHNS (NET EVAPORATION/PRECIPITATION)
            END DO                            !JLM FOR LOWER ST. JOHNS (NET EVAPORATION/PRECIPITATION)
        END IF

          DO 10600 F=1,NQF
            V2(JB(F)) = V2(JB(F))+Q(F)*DLT
            V2(IB(F)) = V2(IB(F))-Q(F)*DLT
10600     CONTINUE

CBARRY Modified for littoral zone lateral flows   

          DO 10601 B=1,NB
            V2(B) = V2(B) + QLIT(B)*DLT
10601     CONTINUE

C         *** Update box lengths
 
          DO 10620 SB=1,NSB
            SFATMP=1.0/SFA(SB)
            DO 10610 F=1,NVF(SB)
              BL(IB(VFN(F,SB)),3) = V2(IB(VFN(F,SB)))*SFATMP
10610       CONTINUE
            BL(SB,3) = V2(SB) * SFATMP
10620     CONTINUE

        ! </ezpp-user name = "wc_kinetics">

!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
          CALL COMM_VOLS()  !  Communicate new volumes in Ghost boxes
          CALL WAIT_VOLS()
#endif
!.... PARALLEL SECTION ENDS

        END IF


        ! <ezpp-user name = "transport">

******* QUICKEST courant numbers

        DO 10655 F=1,NHQF
          IF (LEFT_FLOWB(F))  V2(IB(F)) = V2(JB(F))
          IF (RIGHT_FLOWB(F)) V2(JB(F)) = V2(IB(F))
          COUR(F) = Q(F)*DLT/(0.5*(V2(JB(F))+V2(IB(F))))
10655   CONTINUE

******* Horizontal transport
C
C       *** Multipliers and gradients for differencing scheme
C
        DO 10660 F=1,NHQF
          IF (POSITIVE_FLOW(F)) THEN
            GRAD(F,1) = A(F)*DIFF(F)*TP1(F,1)/(DEN1(F,1)*SF1(F))
            GRAD(F,2) = A(F)*DIFF(F)*TP2(F,1)/(DEN2(F,1)*SF1(F))
            GRAD(F,3) = A(F)*DIFF(F)*TP3(F,1)/(DEN3(F,1)*SF1(F))
          ELSE
            GRAD(F,1) = A(F)*DIFF(F)*TP1(F,2)/(DEN1(F,2)*SF1(F))
            GRAD(F,2) = A(F)*DIFF(F)*TP2(F,2)/(DEN2(F,2)*SF1(F))
            GRAD(F,3) = A(F)*DIFF(F)*TP3(F,2)/(DEN3(F,2)*SF1(F))
          ENDIF
10660   CONTINUE

        IF (QUICKEST) THEN
          DO 10661 F=1,NHQF
            IF (POSITIVE_FLOW(F)) THEN
              ALFAS = 2.0*SF2(F,1)*
     &               (DIFF(F)*DLT/(SF1(F)**2)-(1.0-COUR(F)**2)/6.0)
              TERM(F,1) =         (ALFAS-COUR(F)*TP1(F,1)*0.5)/DEN1(F,1)
              TERM(F,2) = T2(F,1)+(ALFAS-COUR(F)*TP2(F,1)*0.5)/DEN2(F,1)
              TERM(F,3) = T3(F)  +(ALFAS-COUR(F)*TP3(F,1)*0.5)/DEN3(F,1)
            ELSE
              ALFAS = 2.0*SF2(F,2)*
     &                (DIFF(F)*DLT/(SF1(F)**2)-(1.0-COUR(F)**2)/6.0)
              TERM(F,1) = T1(F) + (ALFAS-COUR(F)*TP1(F,2)*0.5)/DEN1(F,2)
              TERM(F,2) = T2(F,2)+(ALFAS-COUR(F)*TP2(F,2)*0.5)/DEN2(F,2)
              TERM(F,3) =         (ALFAS-COUR(F)*TP3(F,2)*0.5)/DEN3(F,2)
            ENDIF
10661     CONTINUE
        ENDIF

C
C       *** Update concentrations due to horizontal transport and kinetics
C       *** This portion of code (through "perform vertical integration"
C       *** resotred from original code (/disk3/cerco/revsied_code/wqm.f)
C
        DO 10690 JC=1,NAC
          JCB = 0

          DO 10670 F=1,NHQF

*********** Boundary concentrations

            IF (LEFT_FLOWB(F)) THEN
              JCB = JCB+1
              IF (POSITIVE_FLOW(F)) THEN
                CONC1 = CB(JCB,AC(JC))    
                CONC2 = CB(JCB,AC(JC))    
                CONC3 = CB(JCB,AC(JC))   
              ELSE
                CONC1 = C1(JB(F),AC(JC))
                CONC2 = C1(JB(F),AC(JC))
                CONC3 = C1(JB(F),AC(JC))
              END IF
            ELSE IF (RIGHT_FLOWB(F)) THEN
              JCB = JCB+1
              IF (POSITIVE_FLOW(F)) THEN
                CONC1 = C1(IB(F),AC(JC))
                CONC2 = C1(IB(F),AC(JC))
                CONC3 = C1(IB(F),AC(JC))
              ELSE
                CONC1 = CB(JCB,AC(JC))
                CONC2 = CB(JCB,AC(JC))
                CONC3 = CB(JCB,AC(JC))
              END IF

*********** Internal concentrations

            ELSE
              IF (POSITIVE_FLOW(F)) THEN
                CONC1 = C1(ILB(F),AC(JC))
                CONC2 = C1(IB(F),AC(JC))
                CONC3 = C1(JB(F),AC(JC))
                IF (LEFTM1_BOUNDARY(F)) CONC1 = C1(IB(F),AC(JC))
              ELSE
                CONC1 = C1(IB(F),AC(JC))
                CONC2 = C1(JB(F),AC(JC))
                CONC3 = C1(JRB(F),AC(JC))
                IF (RIGHTP1_BOUNDARY(F)) CONC3 = C1(JB(F),AC(JC))
              END IF
            END IF


*********** Advective and diffusive terms

            CADV  = TERM1(F)*CONC1+TERM2(F)*CONC2+TERM3(F)*CONC3
            CDIFF = GRAD1(F)*CONC1+GRAD2(F)*CONC2+GRAD3(F)*CONC3

*********** Change in mass

            DTM(IB(F),AC(JC)) = DTM(IB(F),AC(JC))-Q(F)*CADV+CDIFF
            DTM(JB(F),AC(JC)) = DTM(JB(F),AC(JC))+Q(F)*CADV-CDIFF

*********** Constituent fluxes     m3/s * g/m3 * s = g

            IF (H_TRANS_FLUX) 
     .        FLUXT(F,AC(JC)) = (Q(F)*CADV-CDIFF)*DLT
     
10670     CONTINUE

********* Update concentrations

          DO 10680 B=1,NB
            CSTAR(B,AC(JC)) = (C1(B,AC(JC))*V1(B)+DLT*DTM(B,AC(JC)))
     .                         /V2(B)
10680     CONTINUE
10690   CONTINUE

C       *** Perform vertical integration, assign new values   ! CFC 070105

        vtheta = TH
                                    ! Compute left-hand side tridiagonal terms      
        do 20760 sb=1,nsb
    
                                    ! If one-layer column, update concentrations
          if(nvf(sb) .le. 0) then

            do jc = 1,nac
              ii=ac(jc)
              dtc(sb,ii) = 0.0
              c1(sb,ii) = cstar(sb,ii)
              c2(sb,ii) = max( cstar(sb,ii), 0.0 )
              c1max(sb,ii) = amax1(C1(sb,ii),c1max(sb,ii))
              c1min(sb,ii) = amin1(C1(sb,ii),c1min(sb,ii))
            enddo

          else   
                                    ! Update courant numbers and diffusive
                                    ! terms for tridiagonal terms     
            v2(0) = v2(ib(vfn(nvf(sb),sb)))
            do f=1,nvf(sb)
              ivtmp=ib(vfn(f,sb))
              jvtmp=jb(vfn(f,sb))

              gamfm1(f,sb) = diff(vfn(f-1,sb))*dlt/bl(ivtmp,3)
              gamf(f,sb)   = diff(vfn(f,sb))*dlt/bl(ivtmp,3)
              wdilb(f,sb)  = 2.0/(bl(ilb(vfn(f,sb)),3)+bl(ivtmp,3))
              wdib(f,sb)   = 2.0/(bl(ivtmp,3)+bl(jvtmp,3))
  
              cl2(f,sb)  = q(vfn(f,sb))*dlt / (2.0*v2(jvtmp))
              cr2(f,sb)  = q(vfn(f,sb))*dlt / (2.0*v2(ivtmp))

                                    ! Scale n level cn's to current time step
              cl1(f,sb)  = cl1(f,sb)*dlt/dltn
              cr1(f,sb)  = cr1(f,sb)*dlt/dltn 

            enddo

                                    ! Catch discontinuous volumes
            if(NEW_HYDRO_FILE) then
              do f=1,nvf(sb)
                cl1(f,sb)  = cl2(f,sb)
                cr1(f,sb) = cr2(f,sb)
              enddo
            endif


            gamfm1(nvf(sb)+1,sb) = diff(vfn(nvf(sb),sb))*dlt 
     .                           / bl(jb(vfn(nvf(sb),sb)),3)

            waib(nvf(sb),sb) = bl(jb(vfn(nvf(sb),sb)),3)  
     .                       / bl(ib(vfn(nvf(sb),sb)),3)

            wdilb(nvf(sb)+1,sb) = 2.0/(bl(ib(vfn(nvf(sb),sb)),3)  
     .                       + bl(jb(vfn(nvf(sb),sb)),3))

            wailb(nvf(sb)+1,sb) = bl(ib(vfn(nvf(sb),sb)),3)  
     .                       / bl(jb(vfn(nvf(sb),sb)),3)
     
                                          ! Left-hand side tridiagonal terms     
            cr2(0,sb) = 0.0

                                    ! @ Bottom
            f=1
            bt(f,sb) = 1.+ vtheta*cr2(f,sb) + gamf(f,sb)*wdib(f,sb) 
            ct(f,sb) = vtheta*cr2(f,sb) - gamf(f,sb)*wdib(f,sb)

            do f=2,nvf(sb)
              at(f,sb) = -vtheta*cl2(f-1,sb) - gamfm1(f,sb)*wdilb(f,sb)  

              bt(f,sb) = 1. - vtheta*( cl2(f-1,sb) - cr2(f,sb) ) 
     .          + gamf(f,sb)*wdib(f,sb) + gamfm1(f,sb)*wdilb(f,sb)

              ct(f,sb) = vtheta*cr2(f,sb) - gamf(f,sb)*wdib(f,sb)

            enddo
                                    ! @ Surface
            f = nvf(sb)+1
            at(f,sb) = -vtheta*cl2(f-1,sb) - gamfm1(f,sb)*wdilb(f,sb)
            bt(f,sb) = 1.-vtheta*cl2(f-1,sb)+gamfm1(f,sb)*wdilb(f,sb) 

                 



                                    ! Right hand side tridiagonal term
            omth=1.0-vtheta

                                    ! @ Bottom
            f=1
            tm2 = omth*(-cr1(f,sb))
            tm3 = omth*cr1(f,sb)
            it2 = ib(vfn(f,sb))
            it3 = jb(vfn(f,sb))
            do jc=1,nac
              dt(f,jc) = tm2*c1(it2,ac(jc)) + cstar(it2,ac(jc)) 
     .                 - tm3*c1(it3,ac(jc))
            enddo  

            do f=2,nvf(sb)
              tm1 = omth*cl1(f-1,sb)
              tm2 = omth*( cl1(f-1,sb) - cr1(f,sb) )
              tm3 = omth*cr1(f,sb)
              it1 = ilb(vfn(f,sb))
              it2 = ib(vfn(f,sb))
              it3 = jb(vfn(f,sb))
              do jc=1,nac
                dt(f,jc) = tm1*c1(it1,ac(jc))  
     .             + tm2*c1(it2,ac(jc)) + cstar(it2,ac(jc))  
     .             - tm3*c1(it3,ac(jc))
              enddo       
            enddo

                                    ! @ Surface
            tm1 = omth*cl1(nvf(sb),sb)
            tm2 = omth*cl1(nvf(sb),sb)
            it1 = ib(vfn(nvf(sb),sb))
            it2 = nvf(sb)+1
            jt1 = jb(vfn(nvf(sb),sb))

            do jc=1,nac
              dt(it2,jc) = tm1*c1(it1,ac(jc)) + tm2*c1(jt1,ac(jc))
     .                     + cstar(jt1,ac(jc))
            enddo
            

            
                                          ! Update concentrations
            tm1 = bt(1,sb)
            tm2 = 1.0/tm1
            do jc=1,nac
              bta(1,jc) = tm1
              gamma(1,jc) = dt(1,jc)*tm2    
            enddo


            do f=2,nvf(sb)+1
              tm1 = at(f,sb)*ct(f-1,sb)
              do jc = 1,nac
                bta(f,jc) = bt(f,sb)-tm1/bta(f-1,jc)
                gamma(f,jc)=(dt(f,jc)-at(f,sb)*gamma(f-1,jc))/bta(f,jc)
              enddo
            enddo

     
            it1 = jb(vfn(nvf(sb),sb))
            it2 = nvf(sb)+1
            do jc = 1,nac
              vt(it1,jc) = gamma(it2,jc)
            enddo
    

            do f=nvf(sb),1,-1
              it1 = ib(vfn(f,sb))
              jt1 = jb(vfn(f,sb))
              tm1 = ct(f,sb)
              do  jc=1,nac
                vt(it1,jc) = gamma(f,jc)-tm1*vt(jt1,jc)/bta(f,jc)
                c2(it1,ac(jc)) = vt(it1,jc)
              enddo
            enddo

            jt1=jb(vfn(nvf(sb),sb))

            do jc=1,nac
              c2(jt1,ac(jc)) = vt(jt1,jc)
            enddo

                                    ! Update other concentration arrays
            do  jc=1,nac
              ii = ac(jc)            
              do f=1,nvf(sb)
                b = ib(vfn(f,sb))
                dtc(b,ii) = 0.0
                c1(b,ii) = c2(b,ii)
                c2(b,ii) = max(c2(b,ii),0.0)
                c1max(b,ii) = max(c1(b,ii),c1max(b,ii))
                c1min(b,ii) = min(c1(b,ii),c1min(b,ii))
              enddo
              b = jb(vfn(nvf(sb),sb))
              dtc(b,ii) = 0.0
              c1(b,ii) = c2(b,ii)
              c2(b,ii) = max(c2(b,ii),0.0)
              c1max(b,ii) = max(c1(b,ii),c1max(b,ii))
              c1min(b,ii) = min(c1(b,ii),c1min(b,ii))
            enddo

          endif         ! if(nvf(sb) .le. 0) then

                                      ! vertical transport fluxes in g
          if(V_TRANS_FLUX) then       ! seems to have sign reversed
            do jc=1,nac               ! negative for flow from left to right
              fluxt(0,ac(jc)) = 0.0
            enddo
            do f=1,nvf(sb)
              IT1 = vfn(f,sb)
              IT2 = ib(vfn(f,sb))
              IT3 = vfn(f-1,sb)
              do jc=1,nac
                II = ac(jc)
                fluxt(IT1,II)=(c2(IT2,II)-cstar(IT2,II))*v2(IT2)+
     .                        fluxt(IT3,II)
              enddo
            enddo
          endif


20760   continue                    ! End of vert. transpt. loop over columns
  

                                    ! Reset  NEW_HYDRO_FILE  
        if(NEW_HYDRO_FILE) then   
          NEW_HYDRO_FILE = .FALSE.
        endif

                                    ! TKG: 8-2001. End of modification
!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
          CALL COMM_CONCS()    ! initiate messaging updated concs to ghost blocks
          CALL WAIT_CONCS()
#endif
!.... PARALLEL SECTION ENDS


******* Update flux and constituent averages

        IF (H_TRANS_FLUX .OR. V_TRANS_FLUX .OR. S_TRANS_FLUX .OR.
     .    AVERAGE_PLOTS .OR. KINETIC_FLUXES)  CALL AVERAGES           !MNOEL

******* Update Courant numbers

        DO 10810 SB=1,NSB
          DO 10800 F=1,NVF(SB)
            CR1(F,SB) = CR2(F,SB)
            cl1(f,sb) = cl2(f,sb)                                       !TKG 8-2001
10800     CONTINUE
10810   CONTINUE

******* Update volumes

CNOEL   IF ((BINARY_HYDRO) .OR. (DEPTH_AVG_HYDRO)) THEN
          DO 10820 B=1,NB
            V1S(B) = V1(B)
            V1(B)  = V2(B)
10820     CONTINUE
CNOEL   END IF

******* Update time related variables

        NIT     = NIT+1
        ELTMS   = ELTMS+DLT
        DLTAV   = ELTMS/NIT
        JDAY    = ELTMS/86400.
        ELTMJD  = JDAY-TMSTRT
        END_RUN = JDAY.GE.TMEND
        IF (JDAY.GE.DLTD(DLTDP+1)) THEN
          DLTDP = DLTDP+1
          IF (.NOT.AUTO_STEPPING) DLT = DLTVAL(DLTDP)
          MXDLT = DLTMAX(DLTDP)
          FNDLT = DLTFTN(DLTDP)
        END IF

******* Volume balance

        IF (VOLUME_BALANCE.AND.DIAGNOSTICS) THEN
          IF (NINT(ELTMS).EQ.NXHYD) THEN
            JDAYVB = INT(JDAY)
            HOURVB = (JDAY-INT(JDAY))*24.
            WQMDLV = 0.0
            WQMTV2 = 0.0
            HMTV2  = 0.0
            DO 10830 B=1,NB
              V2VB(B) = V2(B)
              DLBV(B) = HMV(B)-V2(B)
              WQMDLV  = WQMDLV+DLBV(B)
              WQMTV2  = WQMTV2+V2(B)
              HMTV2   = HMTV2+HMV(B)
10830       CONTINUE
            NEW_VOLUMES = .TRUE.
          END IF
        END IF

C
C       *** Oxygen days
C
        goto 1113    ! pw
        IF (OXYGEN_PLOTS) THEN
          TM1=DLT/86400.
          DO 10858 J=1,NOINT-1
            DO 10859 B=1,NB
              IF (DO(B).GE.OINT(J).AND.DO(B).LT.OINT(J+1)) THEN
                DOVDAYS(B,J) = DOVDAYS(B,J)+TM1*V1(B)
              ENDIF
10859       CONTINUE
10858     CONTINUE
          DO 11859 B=1,NB
            IF(DO(B).GE.OINT(NOINT)) DOVDAYS(B,J)=DOVDAYS(B,J)+TM1*V1(B)
11859     CONTINUE
        END IF
1113      continue   ! pw

        ! </ezpp-user name = "transport">

************************************************************************
**                           Output Results                           **
************************************************************************

******* Snapshots

        ! <ezpp-user name = "output_results">

        IF (SNAPSHOTS) THEN
          IF (JDAY.GE.NXSNP.OR.JDAY.GE.SNPD(SNPDP+1)) THEN
            IF (JDAY.GE.SNPD(SNPDP+1)) THEN
              SNPDP = SNPDP+1
              NXSNP = SNPD(SNPDP)
            END IF
            NXSNP = NXSNP+SNPF(SNPDP)
            WRITE (SNP,3000)
            WRITE (SNP,3010) (TITLE(K),K=1,6)
            WRITE (SNP,3020) JDAY,INT(ELTMJD),(ELTMJD-INT(ELTMJD))*24.,
     .                       NIT,DLT,DLTAV
            DO 10860 JC=1,NAC
              if (ac(jc) .lt. 33) then
                WRITE (SNP,3030) CNAME(AC(JC)),(C1(B,AC(JC)),B=1,NB)
              else
                WRITE (SNP,3033) CNAME(AC(JC)),(C1(B,AC(JC)),B=1,NB)
              end if
10860       CONTINUE

****** ROMS Bed Masses

            IF (SEDTR_CALC) THEN
              ! ZERO OUT BED MASS SUMMARY
              DO J=1,NSB
                DO K=1,NSDCLS
                  BED_MASS_INT(J,K) = 0.0
                END DO
              END DO
              ! INTEGRATE BED MASS OVER ALL LAYERS
              DO J=1,NSB
                DO K=1,NSDCLS
                  DO L=1,NBED
                    BED_MASS_INT(J,K) = BED_MASS_INT(J,K) +
     $                BED_MASS(1,J,L,1,K)
                  END DO
                END DO
              END DO
              DO K=1,NSDCLS
                WRITE (SNP,3038) K,' SURFACE',
     $            (BED_MASS(1,BB,1,1,K),BB=1,NSB)
                WRITE (SNP,3037) K,' INTEGRATED',
     $            (BED_MASS_INT(BB,K),BB=1,NSB)
              END DO
            END IF


            IF (SEDIMENT_CALC) THEN
              WRITE (SNP,3034) SSNAME(1),(CTEMP(BB),BB=1,NBB)
              DO 10870 JG=1,3
                WRITE (SNP,3035) JG,SSNAME(2),(CPOP(BB,JG),BB=1,NBB)
                WRITE (SNP,3035) JG,SSNAME(3),(CPON(BB,JG),BB=1,NBB)
                WRITE (SNP,3035) JG,SSNAME(4),(CPOC(BB,JG),BB=1,NBB)
10870         CONTINUE
              IF (ACC(25) .EQ. ' ON') 
     $          WRITE (SNP,3034) SSNAME(18),(CPIP(BB),BB=1,NBB)
              WRITE (SNP,3034) SSNAME(6), (PO4T2TM1S(BB),BB=1,NBB)
              WRITE (SNP,3034) SSNAME(7), (NH4T2TM1S(BB),BB=1,NBB)
              WRITE (SNP,3034) SSNAME(8), (NO3T2TM1S(BB),BB=1,NBB)
              WRITE (SNP,3034) SSNAME(9), (HST2TM1S(BB),BB=1,NBB)
              WRITE (SNP,3034) SSNAME(10),(CH4T2TM1S(BB),BB=1,NBB) 
              WRITE (SNP,3034) SSNAME(11),(CH41TM1S(BB),BB=1,NBB) 
              WRITE (SNP,3034) SSNAME(12),(SO4T2TM1S(BB),BB=1,NBB)
              WRITE (SNP,3034) SSNAME(14),(BENSTR1S(BB),BB=1,NBB)
              WRITE (SNP,3034) SSNAME(15),(BBM(BB),BB=1,NBB) 
            END IF

            IF (SFEEDER) THEN
                DO N=1,NSPECIES 
                  WRITE (SNP,3036) N,SSNAME(17),(SFEED(BB,N),BB=1,NBB) 
                END DO
            END IF

            IF (BENTHIC_FLUXES.AND.BENTHIC_OUTPUT) THEN
              WRITE (BFO,3020) JDAY,INT(ELTMJD),
     .          (ELTMJD-INT(ELTMJD))*24.,NIT,DLT,DLTAV
              WRITE (BFO,3034) 'DOC Flux', (BENDOC(BB), BB=1,NBB)
              WRITE (BFO,3034) 'Ammonium Flux', (BENNH4(BB),BB=1,NBB)
              WRITE (BFO,3034) 'Nitrate Flux', (BENNO3(BB),BB=1,NBB)
              WRITE (BFO,3034) 'Phosphate Flux', (BENPO4(BB),BB=1,NBB)
              WRITE (BFO,3034) 'COD Flux', (BENCOD(BB), BB=1,NBB)
              WRITE (BFO,3034) 'CH4 Gas Flux', (BENCH4G(BB), BB=1,NBB)
              WRITE (BFO,3034) 'CH4 Aq Flux', (BENCH4A(BB), BB=1,NBB)
              WRITE (BFO,3034) 'SOD', (BENDO(BB),BB=1,NBB)
            END IF

            IF (SAV_CALC) THEN
              WRITE (SNP,3032) 'Leaves',(LEAF(BB),BB=1,NSB)
              WRITE (SNP,3032) 'Stems',(STEM(BB),BB=1,NSB)
              WRITE (SNP,3032) 'Roots',(ROOT(BB),BB=1,NSB)
              WRITE (SNP,3032) 'Tubers',(TUBER(BB),BB=1,NSB)
              WRITE (SNP,3032) 'Epiphytes',(EP(BB),BB=1,NSB)
            END IF
          END IF
        END IF

******* Plots

        IF (PLOTS) THEN
          IF (JDAY.GE.NXPLT.OR.JDAY.GE.PLTD(PLTDP+1)) THEN
            IF (JDAY.GE.PLTD(PLTDP+1)) THEN
              PLTDP = PLTDP+1
              NXPLT = PLTD(PLTDP)
            END IF
            NXPLT = NXPLT+PLTF(PLTDP)
            WRITE (PLT) JDAY,((C1(B,AC(JC)),B=1,NB),JC=1,NAC)
            WRITE (PLT) (CCHL1(B),B=1, NB),(CCHL2(B),B=1,NB),
     .                  (CCHL3(B),B=1, NB)

            IF (QUALITY_DIAG)  THEN
             WRITE (PLT) (FI1(B),B=1,NB),(NL1(B),B=1,NB),
     .        (PL1(B),B=1,NB), 
     .        (FI2(B),B=1,NB),(NL2(B),B=1,NB),(PL2(B),B=1,NB),
     .        (FI3(B),B=1,NB),(NL3(B),B=1,NB),(PL3(B),B=1,NB), 
     .        (NPP(B),B=1,NB), (GPP(B),B=1,NB),(RESP(B),B=1,NB),
     .        (KESS(B),B=1,NB),
     .        (ASRAT(B),B=1,NSB),(FIB(B),B=1,NSB),(NLB(B),B=1,NSB),
     .        (PLB(B),B=1,NSB),(NPPB(B),B=1,NSB)
            ENDIF

            IF (SEDIMENT_DIAG)  THEN
              WRITE (PLT) (BENDOC(B),B=1,NSB),(BENNH4(B),B=1,NSB),
     .        (BENNO3(B),B=1,NSB), (BENPO4(B),B=1,NSB),
     .        (BENCOD(B),B=1,NSB), (BENCH4G(B),B=1,NSB),
     .        (BENCH4A(B),B=1,NSB),(BENDO(B),B=1,NSB), 
     .        (SSFWS(B),B=1,NSB),
     .        (PCFWS(B),B=1,NSB),  (PNFWS(B),B=1,NSB),
     .        (PPFWS(B),B=1,NSB),  (PIPFWS(B),B=1,NSB),
     .        ((CPOC(B,J),B=1,NSB),J=1,3),
     .        ((CPON(B,J),B=1,NSB),J=1,3),
     .        ((CPOP(B,J),B=1,NSB),J=1,3), 
     .        (CPIP(B),B=1,NSB),   (CPO4(B),B=1,NSB),
     .        (BBM(B),B=1,NSB),    (CNH4(B),B=1,NSB),   
     .        (CNO3(B),B=1,NSB),   (CHS(B),B=1,NSB),    
     .        (DIAGN(B),B=1,NSB)        
            ENDIF
            IF (SAV_PLOTS) THEN
             WRITE (PLT) (LEAF(B),B=1,NSB),
     .                   (STEM(B),B=1,NSB), 
     .                   (ROOT(B),B=1,NSB),
     .                   (TUBER(B),B=1,NSB),
     .                   (EP(B),B=1,NSB),
     .                   (FISH(B),B=1,NSB),
     .                   (NLSAV(B),B=1,NSB),
     .                   (PLSAV(B),B=1,NSB),
     .                   (FNSEDSAV(B),B=1,NSB),
     .                   (FPSEDSAV(B),B=1,NSB),
     .                   (FIEP(B),B=1,NSB),
     .                   (NLEPI(B),B=1,NSB),
     .                   (PLEPI(B),B=1,NSB), 
     .                   (NPPSAV(B),B=1,NSB),
     .                   (NPPEPI(B),B=1,NSB),
     .                   (WATATN(B),B=1,NSB),
     .                   (EPATN(B),B=1,NSB)
            END IF
      if(sedtr_calc) then
        WRITE (PLT)(((bed_frac(1,J,L,K),K=1,NSDCLS),L=1,NBED),J=1,NSB)
        WRITE (PLT)((bed(1,J,L,ithck),L=1,NBED),J=1,NSB)
        WRITE (PLT)(((bed_mass(1,J,L,1,K),K=1,NSDCLS),L=1,NBED),J=1,NSB)
      endif

          END IF
        END IF
    
C
C       *** Oxygen plots
C
        IF (OXYGEN_PLOTS) THEN
          IF (JDAY.GE.NXOPL.OR.JDAY.GE.OPLD(OPLDP+1)) THEN
            IF (JDAY.GE.OPLD(OPLDP+1)) THEN
              OPLDP = OPLDP+1
              NXOPL = OPLD(OPLDP)
            END IF
            NXOPL = NXOPL+OPLF(OPLDP)
! pw        WRITE (OPL) JDAY,DOVDAYS(1:NB,1:NOINT)
            WRITE (OPL) JDAY, (C1(B,    1 ),B=1,NB)
     .                     , (C1(B,    2 ),B=1,NB)
     .                     , (C1(B,   27 ),B=1,NB)

!            DO 10880 J=1,NOINT
!              DO 10881 B=1,NB
!                DOVDAYS(B,J) = 0.
!10881         CONTINUE
!10880       CONTINUE
          ENDIF
        ENDIF

******* Average plots

        IF (AVERAGE_PLOTS) THEN
          IF (JDAY.GE.NXAPL.OR.JDAY.GE.APLTD(APLDP+1)) THEN
            IF (JDAY.GE.APLTD(APLDP+1)) THEN
              APLDP = APLDP+1
              NXAPL = APLTD(APLDP)
            END IF
            NXAPL  = NXAPL+APLF(APLDP)
            AVGINT = ELTMS-ELTMSPLT
            DO 10900 JC=1,NAC
              DO 10890 B=1,NB
                AC1(B,AC(JC)) = AC1(B,AC(JC))/AVGINT
10890         CONTINUE
10900       CONTINUE
            WRITE (APL) JDAY,((AC1(B,AC(JC)),B=1,NB),JC=1,NAC)
c     .            C1MIN(B,AC(JC)),C1MAX(B,AC(JC)),B=1,NB),JC=1,NAC)
            DO 10920 JC=1,NAC
              DO 10910 B=1,NB
                C1MIN(B,AC(JC)) = 1.E10
                C1MAX(B,AC(JC)) = 0.0
                AC1(B,AC(JC))   = 0.0
10910         CONTINUE
10920       CONTINUE
            DO 10930 B=1,NB
              ACCHL1(B)  = ACCHL1(B)/AVGINT
              ACCHL2(B)  = ACCHL2(B)/AVGINT
              ACCHL3(B)  = ACCHL3(B)/AVGINT
10930       CONTINUE
            WRITE (APL) (ACCHL1(B),B=1,NB), 
     .                  (ACCHL2(B),B=1,NB), 
     .                  (ACCHL3(B),B=1,NB)
            DO 10940 B=1,NB
              ACCHL1(B)  = 0.0
              ACCHL2(B)  = 0.0
              ACCHL3(B)  = 0.0
10940       CONTINUE
            IF (QUALITY_DIAG) THEN
              DO 10950 B=1,NB
                AKE(B)   = AKE(B)/AVGINT 
                AFI1(B)  = AFI1(B)/AVGINT
                ANL1(B)  = ANL1(B)/AVGINT
                APL1(B)  = APL1(B)/AVGINT
                AFI2(B)  = AFI2(B)/AVGINT
                ANL2(B)  = ANL2(B)/AVGINT
                APL2(B)  = APL2(B)/AVGINT
                AFI3(B)  = AFI3(B)/AVGINT
                ANL3(B)  = ANL3(B)/AVGINT
                APL3(B)  = APL3(B)/AVGINT
                ANPP(B)  = ANPP(B)/AVGINT
                AGPP(B)  = AGPP(B)/AVGINT
                ACFIX(B) = ACFIX(B)/AVGINT
                ARESP(B) = ARESP(B)/AVGINT
10950         CONTINUE
              DO B=1,NSB
                AASRAT(B)= AASRAT(B)/AVGINT
                AKRDO(B) = AKRDO(B)/AVGINT
              END DO
              DO 10952 BB=1,NBB
                AFIB(BB)  = AFIB(BB)/AVGINT
                ANLB(BB)  = ANLB(BB)/AVGINT
                APLB(BB)  = APLB(BB)/AVGINT
                ANPPB(BB) = ANPPB(BB)/AVGINT
10952         CONTINUE
              WRITE (APL) (AFI1(B),B=1,NB), (ANL1(B),B=1,NB),
     .              (APL1(B),B=1,NB), 
     .              (AFI2(B),B=1,NB), (ANL2(B),B=1,NB),
     .              (APL2(B),B=1,NB),
     .              (AFI3(B),B=1,NB), (ANL3(B),B=1,NB),
     .              (APL3(B),B=1,NB),
     .              (ANPP(B),B=1,NB), (AGPP(B),B=1,NB),
     .              (ARESP(B),B=1,NB),(AKE(B),B=1,NB),  
     .              (ACFIX(B),B=1,NB),
     .              (AASRAT(B),B=1,NSB),(AFIB(B),B=1,NSB),
     .              (ANLB(B),B=1,NSB),(APLB(B),B=1,NSB),
     .              (ANPPB(B),B=1,NSB),(AKRDO(B),B=1,NSB)
              DO 10960 B=1,NB
                AKE(B)   = 0.0 
                AFI1(B)  = 0.0
                ANL1(B)  = 0.0
                APL1(B)  = 0.0
                AFI2(B)  = 0.0
                ANL2(B)  = 0.0
                APL2(B)  = 0.0
                AFI3(B)  = 0.0
                ANL3(B)  = 0.0
                APL3(B)  = 0.0
                ANPP(B)  = 0.0
                AGPP(B)  = 0.0
                ACFIX(B) = 0.0
                ARESP(B) = 0.0
10960         CONTINUE
              DO B=1,NSB
                AASRAT(B)= 0.0
                AKRDO(B) = 0.0
              END DO
              DO 10962 BB=1,NBB
                AFIB(BB)  = 0.0
                ANLB(BB)  = 0.0
                APLB(BB)  = 0.0
                ANPPB(BB) = 0.0
10962         CONTINUE

******* Wetlands Rates

              if (wtlmc .eq. ' ON') call write_wetlands ()

            END IF
            IF (SEDIMENT_DIAG) THEN
              DO 10970 BB=1,NBB
                ACPIP(BB)   = ACPIP(BB)/AVGINT
                ACPO4(BB)   = ACPO4(BB)/AVGINT
                ASSFWS(BB)  = ASSFWS(BB)/AVGINT
                APCFWS(BB)  = APCFWS(BB)/AVGINT
                APNFWS(BB)  = APNFWS(BB)/AVGINT
                APPFWS(BB)  = APPFWS(BB)/AVGINT
                APIPFWS(BB) = APIPFWS(BB)/AVGINT
                ABENDO(BB)  = ABENDO(BB)/AVGINT
                ABENDOC(BB) = ABENDOC(BB)/AVGINT
                ABENNH4(BB) = ABENNH4(BB)/AVGINT
                ABENNO3(BB) = ABENNO3(BB)/AVGINT
                ABENPO4(BB) = ABENPO4(BB)/AVGINT
                ABENCOD(BB) = ABENCOD(BB)/AVGINT
                ABENCH4G(BB) = ABENCH4G(BB)/AVGINT
                ABENCH4A(BB) = ABENCH4A(BB)/AVGINT
                ABBM(BB)    = ABBM(BB)/AVGINT
                ABLITE(BB)  = ABLITE(BB)/AVGINT
                DO N=1,NSPECIES
                  ASFEED(BB,N)  = ASFEED(BB,N)/AVGINT
                  ASF_SFGC(BB,N)  = ASF_SFGC(BB,N)/AVGINT
                  ASF_RESP(BB,N)  = ASF_RESP(BB,N)/AVGINT
                  ASF_PRED(BB,N)  = ASF_PRED(BB,N)/AVGINT
                  ASF_RMORT(BB,N) = ASF_RMORT(BB,N)/AVGINT
                ASFFILTCT(BB,N) = ASFFILTCT(BB,N)/AVGINT
                ENDDO
                AJNSF(BB) = AJNSF(BB)/AVGINT
                AJPSF(BB) = AJPSF(BB)/AVGINT
                ASODSF(BB) = ASODSF(BB)/AVGINT
                ASFGCIN(BB) = ASFGCIN(BB)/AVGINT
                ASFCFEC(BB) = ASFCFEC(BB)/AVGINT
                ASFCPSF(BB) = ASFCPSF(BB)/AVGINT
                AFLXCSF(BB) = AFLXCSF(BB)/AVGINT
                AFLXNSF(BB) = AFLXNSF(BB)/AVGINT
                AFLXPSF(BB) = AFLXPSF(BB)/AVGINT
                ARPOCSF(BB) = ARPOCSF(BB)/AVGINT
                ARPONSF(BB) = ARPONSF(BB)/AVGINT
                ARPOPSF(BB) = ARPOPSF(BB)/AVGINT
                ASSISF(BB) = ASSISF(BB)/AVGINT
                ASSIPSF(BB) = ASSIPSF(BB)/AVGINT
                ASF_CFILT(BB) = ASF_CFILT(BB)/AVGINT
                ASF_NFILT(BB) = ASF_NFILT(BB)/AVGINT
                ASF_PFILT(BB) = ASF_PFILT(BB)/AVGINT
                DO JG=1,3
                  ACPOC(BB,JG) = ACPOC(BB,JG)/AVGINT
                  ACPON(BB,JG) = ACPON(BB,JG)/AVGINT
                  ACPOP(BB,JG) = ACPOP(BB,JG)/AVGINT
                END DO
10970         CONTINUE
              WRITE (APL) (ABENDOC(B),B=1,NSB),(ABENNH4(B),B=1,NSB),
     .                    (ABENNO3(B),B=1,NSB), (ABENPO4(B),B=1,NSB),
     .                    (ABENCOD(B),B=1,NSB),
     .                    (ABENCH4G(B),B=1,NSB), (ABENCH4A(B),B=1,NSB),
     .                    (ABENDO(B),B=1,NSB),
     .                    (ASSFWS(B),B=1,NSB),
     .                    (APCFWS(B),B=1,NSB),  (APNFWS(B),B=1,NSB),
     .                    (APPFWS(B),B=1,NSB),  (APIPFWS(B),B=1,NSB),
     .                    ((ACPOC(B,J),B=1,NSB),J=1,3),
     .                    ((ACPON(B,J),B=1,NSB),J=1,3),
     .                    ((ACPOP(B,J),B=1,NSB),J=1,3),
     .                    (ACPIP(B),B=1,NSB),  (ACPO4(B),B=1,NSB),
     .                    (ABBM(B),B=1,NSB),
     .                    (ABLITE(B),B=1,NSB),
     .                    ((ASFEED(B,K),B=1,NSB),K=1,NSSFP)

CMBM 961226 sfeeder diagnostics, for output from main 
              IF (SFEEDER) THEN 
                WRITE (SUD) (AJNSF(B),B=1,NSB),(AJPSF(B),B=1,NSB)
     .                 ,(ASODSF(B),B=1,NSB)
     .                 ,(ASFGCIN(B),B=1,NSB),(ASFCFEC(B),B=1,NSB)
     .                 ,(ASFCPSF(B),B=1,NSB),(AFLXCSF(B),B=1,NSB)
     .                 ,(AFLXNSF(B),B=1,NSB),(AFLXPSF(B),B=1,NSB)
     .                 ,(ARPOCSF(B),B=1,NSB),(ARPONSF(B),B=1,NSB)
     .                 ,(ARPOPSF(B),B=1,NSB),(ASSISF(B),B=1,NSB)
     .                 ,(ASSIPSF(B),B=1,NSB)
     .                 ,((ASF_SFGC(B,K),B=1,NSB),K=1,NSSFP)
     .                 ,((ASF_RESP(B,K),B=1,NSB),K=1,NSSFP)
     .                 ,((ASF_PRED(B,K),B=1,NSB),K=1,NSSFP)
     .                 ,((ASF_RMORT(B,K),B=1,NSB),K=1,NSSFP)
     .                 ,(ASF_CFILT(B),B=1,NSB)
     .                 ,(ASF_NFILT(B),B=1,NSB)
     .                 ,(ASF_PFILT(B),B=1,NSB)
     .                 ,((ASFFILTCT(B,K),B=1,NSB),K=1,NSSFP)
              END IF

              DO 10980 BB=1,NBB
                ACPIP(BB)   = 0.0
                ACPO4(BB)   = 0.0
                ASSFWS(BB)  = 0.0
                APCFWS(BB)  = 0.0
                APNFWS(BB)  = 0.0
                APPFWS(BB)  = 0.0
                APIPFWS(BB) = 0.0
                ABENDO(BB)  = 0.0
                ABENDOC(BB) = 0.0
                ABENNH4(BB) = 0.0
                ABENNO3(BB) = 0.0
                ABENPO4(BB) = 0.0
                ABENCOD(BB) = 0.0
                ABENCH4G(BB) = 0.0
                ABENCH4A(BB) = 0.0
                ABBM(BB)    = 0.0
                ABLITE(BB)  = 0.0
                DO N=1,NSPECIES
                  ASFEED(BB,N) = 0.0
                  ASF_SFGC(BB,N)  = 0.0
                  ASF_RESP(BB,N)  = 0.0
                  ASF_PRED(BB,N)  = 0.0
                  ASF_RMORT(BB,N) = 0.0
                ASFFILTCT(BB,N) = 0.0
                END DO
                AJNSF(BB) = 0.0
                AJPSF(BB) = 0.0
                ASODSF(BB) = 0.0
                ASFGCIN(BB) = 0.0
                ASFCFEC(BB) = 0.0
                ASFCPSF(BB) = 0.0
                AFLXCSF(BB) = 0.0
                AFLXNSF(BB) = 0.0
                AFLXPSF(BB) = 0.0
                ARPOCSF(BB) = 0.0
                ARPONSF(BB) = 0.0
                ARPOPSF(BB) = 0.0
                ASSISF(BB) = 0.0
                ASSIPSF(BB) = 0.0
              ASF_CFILT(BB) = 0.0
              ASF_NFILT(BB) = 0.0
              ASF_PFILT(BB) = 0.0
CNOEL           ACHARV(BB)    = 0.0
                DO JG=1,3
                  ACPOC(BB,JG) = 0.0
                  ACPON(BB,JG) = 0.0
                  ACPOP(BB,JG) = 0.0
                END DO
10980         CONTINUE
            END IF

cvjp modified 11/3/2005
            IF (SAV_PLOTS) THEN
              DO I=1,NSAVCELL
                B=SAVCELL(I)
                ALEAF(B)  = ALEAF(B)/AVGINT
                ASTEM(B)  = ASTEM(B)/AVGINT
                ATUBER(B) = ATUBER(B)/AVGINT
                AEP(B)    = AEP(B)/AVGINT
                AROOT(B)  = AROOT(B)/AVGINT
                AFISH(B)  = AFISH(B)/AVGINT
                AFIEP(B)  = AFIEP(B)/AVGINT
                ANPPSAV(B)= ANPPSAV(B)/AVGINT
                ANPPEP(B) = ANPPEP(B)/AVGINT
                AWATATN(B)= AWATATN(B)/AVGINT
                AEPATN(B) = AEPATN(B)/AVGINT
                ANLSAV(B) = ANLSAV(B)/AVGINT
                APLSAV(B) = APLSAV(B)/AVGINT
                ANLEPI(B) = ANLEPI(B)/AVGINT
                APLEPI(B) = APLEPI(B)/AVGINT
                AFNSED(B) = AFNSED(B)/AVGINT
                AFPSED(B) = AFPSED(B)/AVGINT
                ASAVEFCT(B) = ASAVEFCT(B)/AVGINT
                
              END DO
             WRITE (APL) (ALEAF(B),B=1,NSB),
     .                   (ASTEM(B),B=1,NSB),
     .                   (AROOT(B),B=1,NSB),
     .                   (ATUBER(B),B=1,NSB),
     .                   (AEP(B),B=1,NSB),
     .                   (AFISH(B),B=1,NSB),
     .                   (ANLSAV(B),B=1,NSB),
     .                   (APLSAV(B),B=1,NSB),
     .                   (AFNSED(B),B=1,NSB),
     .                   (AFPSED(B),B=1,NSB),
     .                   (AFIEP(B),B=1,NSB),
     .                   (ANLEPI(B),B=1,NSB),
     .                   (APLEPI(B),B=1,NSB),
     .                   (ANPPSAV(B),B=1,NSB),
     .                   (ANPPEP(B),B=1,NSB),
     .                   (AWATATN(B),B=1,NSB),
     .                   (AEPATN(B),B=1,NSB),
     .                   (ASAVEFCT(B),B=1,NSB)

cvjp modified 11/3/2005
              DO I=1,NSAVCELL
                B=SAVCELL(I)
                  ALEAF(B)  = 0.0
                  ASTEM(B)  = 0.0
                  ATUBER(B) = 0.0
                  AEP(B)    = 0.0
                  AROOT(B)  = 0.0
                  AFISH(B)  = 0.0
                  AFIEP(B)  = 0.0
                  ANPPSAV(B)= 0.0
                  ANPPEP(B) = 0.0
                  AEPATN(B) = 0.0
                  AWATATN(B)= 0.0
                ANLSAV(B) = 0.0
                APLSAV(B) = 0.0
                AFNSED(B) = 0.0
                AFPSED(B) = 0.0
                ANLEPI(B) = 0.0
                APLEPI(B) = 0.0
		ASAVEFCT(B) = 0.0
              END DO
            END IF
            ELTMSPLT = ELTMS
          END IF
        END IF

******* Transport fluxes

        IF (H_TRANS_FLUX .OR. V_TRANS_FLUX .OR. 
     .    S_TRANS_FLUX) THEN
          IF (JDAY.GE.NXTFL.OR.JDAY.GE.TFLD(TFLDP+1)) THEN
            IF (JDAY.GE.TFLD(TFLDP+1)) THEN
              TFLDP = TFLDP+1
              NXTFL = TFLD(TFLDP)
            END IF
            NXTFL = NXTFL+TFLF(TFLDP)
            DO 11000 JC=1,NAC
	      IF (H_TRANS_FLUX) THEN
                DO F=1,NHQF
                  AFLUXT(F,AC(JC)) = AFLUXT(F,AC(JC))/(ELTMS-ELTMSTFL)
     .                               /1000.       ! kg/s
                END DO
	      END IF
	      IF (V_TRANS_FLUX) THEN     
                DO F=NHQF+1,NQF
                  AFLUXT(F,AC(JC)) = AFLUXT(F,AC(JC))/(ELTMS-ELTMSTFL)
     .                               /1000.       ! kg/s
                END DO
	      END IF
	      IF (S_TRANS_FLUX) THEN
                DO F=NHQF+1,NQF
                  AFLUXS(F,AC(JC)) = AFLUXS(F,AC(JC))/(ELTMS-ELTMSTFL)
     .                               /1000.       ! kg/s
                END DO
	      END IF
11000       CONTINUE

            IF (H_TRANS_FLUX) WRITE (TFL) JDAY, 
     .        ((AFLUXT(F,AC(JC)),F=1,NHQF),JC=1,NAC)
            IF (V_TRANS_FLUX) WRITE (TFL) JDAY, 
     .        ((AFLUXT(F,AC(JC)),F=NHQF+1,NQF),JC=1,NAC)
            IF (S_TRANS_FLUX) WRITE (TFL) JDAY, 
     .        ((AFLUXS(F,AC(JC)),F=NHQF+1,NQF),JC=1,NAC)
     
            DO 11020 JC=1,NAC
              DO F=1,NHQF
                AFLUXT(F,AC(JC)) = 0.0
              END DO
              DO F=NHQF+1,NQF
                AFLUXT(F,AC(JC)) = 0.0
                AFLUXS(F,AC(JC)) = 0.0
              END DO
11020       CONTINUE
            ELTMSTFL = ELTMS
          END IF
        END IF

******* Kinetic fluxes

        IF (KINETIC_FLUXES) THEN                           !MNOEL
          IF (JDAY.GE.NXKFL.OR.JDAY.GE.KFLD(KFLDP+1)) THEN
            IF (JDAY.GE.KFLD(KFLDP+1)) THEN
              KFLDP = KFLDP+1
              NXKFL = KFLD(KFLDP)
            END IF
            NXKFL = NXKFL+KFLF(KFLDP)
            AVGINT = ELTMS-ELTMSKFL
            DO 11025 B=1,NB
              A_T(B)      = A_T(B)/AVGINT
              AP1(B)      = AP1(B)/AVGINT
              ABM1(B)     = ABM1(B)/AVGINT
              APR1(B)     = APR1(B)/AVGINT
              AP2(B)      = AP2(B)/AVGINT
              ABM2(B)     = ABM2(B)/AVGINT
              APR2(B)     = APR2(B)/AVGINT
              AP3(B)      = AP3(B)/AVGINT
              ABM3(B)     = ABM3(B)/AVGINT
              APR3(B)     = APR3(B)/AVGINT
              AALGDOC(B)  = AALGDOC(B)/AVGINT
              AALGPOC(B)  = AALGPOC(B)/AVGINT
              ADENIT(B)   = ADENIT(B)/AVGINT
              AMNLDOC(B)  = AMNLDOC(B)/AVGINT
              AHDRPOC(B)  = AHDRPOC(B)/AVGINT
              AALGNH4(B)  = AALGNH4(B)/AVGINT
              AALGNO3(B)  = AALGNO3(B)/AVGINT
              AALGDON(B)  = AALGDON(B)/AVGINT
              AALGPON(B)  = AALGPON(B)/AVGINT
              ANT(B)      = ANT(B)/AVGINT
              ADENNO3(B)  = ADENNO3(B)/AVGINT
              AMNLDON(B)  = AMNLDON(B)/AVGINT
              AHDRPON(B)  = AHDRPON(B)/AVGINT
              AALGPO4(B)  = AALGPO4(B)/AVGINT
              AALGDOP(B)  = AALGDOP(B)/AVGINT
              AALGPOP(B)  = AALGPOP(B)/AVGINT
              AMNLDOP(B)  = AMNLDOP(B)/AVGINT
              AHDRPOP(B ) = AHDRPOP(B)/AVGINT
              ADO(B)      = ADO(B)/AVGINT
              ADORALG(B)  = ADORALG(B)/AVGINT
              ADOPR(B)    = ADOPR(B)/AVGINT
              ADCOD(B)    = ADCOD(B)/AVGINT
              ADDOC(B)    = ADDOC(B)/AVGINT
              ANITRIF(B)  = ANITRIF(B)/AVGINT
11025       CONTINUE

            IF (SFEEDER) THEN
              DO B=1,NBB
                DO N=1,NSPECIES
                  ACHARV(B,N)   = ACHARV(B,N)/AVGINT
                END DO
              END DO
            END IF

cvjp modified 11/3/2005
            IF (SAV_CALC) THEN
              DO I=1,NSAVCELL
              B=SAVCELL(I)
                APLEAF(B)     = APLEAF(B)/AVGINT
                ABMLEAF(B)    = ABMLEAF(B)/AVGINT
                ASLSH(B)      = ASLSH(B)/AVGINT
                APEP(B)       = APEP(B)/AVGINT
                ABMEP(B)      = ABMEP(B)/AVGINT
                APREP(B)      = APREP(B)/AVGINT
              ABMTUBER(B)   = ABMTUBER(B)/AVGINT
              ADOCSAV(B)    = ADOCSAV(B)/AVGINT
              APOCSAV(B)    = APOCSAV(B)/AVGINT
              ADOCEPI(B)    = ADOCEPI(B)/AVGINT
              APOCEPI(B)    = APOCEPI(B)/AVGINT
              ASEDCSAV(B)   = ASEDCSAV(B)/AVGINT
              ANH4SAVW(B)   = ANH4SAVW(B)/AVGINT
              ANO3SAVW(B)   = ANO3SAVW(B)/AVGINT
              ADONSAVW(B)   = ADONSAVW(B)/AVGINT
              APONSAVW(B)   = APONSAVW(B)/AVGINT
              ANH4EPI(B)    = ANH4EPI(B)/AVGINT
              ANO3EPI(B)    = ANO3EPI(B)/AVGINT
              ADONEPI(B)    = ADONEPI(B)/AVGINT
              APONEPI(B)    = APONEPI(B)/AVGINT
              ASEDNSAV(B)   = ASEDNSAV(B)/AVGINT
              ASEDNH4SAV(B) = ASEDNH4SAV(B)/AVGINT
              APO4SAVW(B)   = APO4SAVW(B)/AVGINT
              ADOPSAVW(B)   = ADOPSAVW(B)/AVGINT
              APOPSAVW(B)   = APOPSAVW(B)/AVGINT
              APO4EPI(B)    = APO4EPI(B)/AVGINT
              ADOPEPI(B)    = ADOPEPI(B)/AVGINT
              APOPEPI(B)    = APOPEPI(B)/AVGINT
              ASEDPSAV(B)   = ASEDPSAV(B)/AVGINT
              ASEDPO4SAV(B) = ASEDPO4SAV(B)/AVGINT
              ADOSAV(B)     = ADOSAV(B)/AVGINT
              ADOEPI(B)     = ADOEPI(B)/AVGINT
              ASEDDOSAV(B)  = ASEDDOSAV(B)/AVGINT
            END DO
          END IF
                              
          IF (BALGAE_CALC) THEN
            DO B=1,NBB
              ABMB(B)       = ABMB(B)/AVGINT
              APB(B)        = APB(B)/AVGINT
              APRB(B)       = APRB(B)/AVGINT
              ABADOC(B)     = ABADOC(B)/AVGINT
              ABAPOC(B)     = ABAPOC(B)/AVGINT
              ABANH4(B)     = ABANH4(B)/AVGINT
              ABANO3(B)     = ABANO3(B)/AVGINT
              ABAPON(B)     = ABAPON(B)/AVGINT
              ABAPO4(B)     = ABAPO4(B)/AVGINT
              ABAPOP(B)     = ABAPOP(B)/AVGINT
              ABADO(B)      = ABADO(B)/AVGINT
            END DO
          END IF                      

            WRITE (KFL) JDAY
            WRITE (KFL) A_T(1:NB),AP1(1:NB),ABM1(1:NB),APR1(1:NB),
     .                 AP2(1:NB),ABM2(1:NB),APR2(1:NB),AP3(1:NB),
     .                 ABM3(1:NB),APR3(1:NB)
            WRITE (KFL) AALGDOC(1:NB),AALGPOC(1:NB),ADENIT(1:NB),
     .                 AMNLDOC(1:NB),AHDRPOC(1:NB)
            WRITE (KFL) AALGNH4(1:NB),AALGNO3(1:NB),AALGDON(1:NB),
     .                 AALGPON(1:NB),ANT(1:NB),ADENNO3(1:NB),
     .                 AMNLDON(1:NB),AHDRPON(1:NB)
            WRITE (KFL) AALGPO4(1:NB),AALGDOP(1:NB),AALGPOP(1:NB),
     .                 AMNLDOP(1:NB),AHDRPOP(1:NB)
            WRITE (KFL) ADO(1:NB),ADORALG(1:NB),ADOPR(1:NB),ADCOD(1:NB),
     .                 ADDOC(1:NB),ANITRIF(1:NB)

            IF (SAV_CALC) THEN
              WRITE (KFL) APLEAF(1:NSB),ABMLEAF(1:NSB),
     .                   ABMTUBER(1:NSB),ASLSH(1:NSB),
     .                   APEP(1:NSB),ABMEP(1:NSB),
     .                   APREP(1:NSB)
              WRITE (KFL) ADOCSAV(1:NSB),APOCSAV(1:NSB),ADOCEPI(1:NSB),
     .                   APOCEPI(1:NSB),ASEDCSAV(1:NSB),ANH4SAVW(1:NSB),
     .                   ANO3SAVW(1:NSB),ADONSAVW(1:NSB),
     .                   APONSAVW(1:NSB),
     .                   ANH4EPI(1:NSB),ANO3EPI(1:NSB),ADONEPI(1:NSB),
     .                   APONEPI(1:NSB),ASEDNSAV(1:NSB),
     .                   ASEDNH4SAV(1:NSB),APO4SAVW(1:NSB),
     .                   ADOPSAVW(1:NSB),APOPSAVW(1:NSB),APO4EPI(1:NSB),
     .                   ADOPEPI(1:NSB),APOPEPI(1:NSB),ASEDPSAV(1:NSB),
     .                   ASEDPO4SAV(1:NSB),ADOSAV(1:NSB),ADOEPI(1:NSB),
     .                   ASEDDOSAV(1:NSB)
            END IF

            IF (BALGAE_CALC) WRITE (KFL) ABMB(1:NSB),APB(1:NSB),
     .                                  APRB(1:NSB),ABADOC(1:NSB),
     .                                  ABAPOC(1:NSB),ABANH4(1:NSB),
     .                                  ABANO3(1:NSB),ABAPON(1:NSB),
     .                                  ABAPO4(1:NSB),ABAPOP(1:NSB),
     .                                  ABADO(1:NSB)

            IF (SFEEDER) WRITE (KFL) ACHARV(1:NSB,1:NSPECIES)

            DO 11027 B=1,NB
              A_T(B)      = 0.0
              AP1(B)      = 0.0
              ABM1(B)     = 0.0
              APR1(B)     = 0.0
              AP2(B)      = 0.0
              ABM2(B)     = 0.0
              APR2(B)     = 0.0
              AP3(B)      = 0.0
              ABM3(B)     = 0.0
              APR3(B)     = 0.0
              AALGDOC(B)  = 0.0
              AALGPOC(B)  = 0.0
              ADENIT(B)   = 0.0
              AMNLDOC(B)  = 0.0
              AHDRPOC(B)  = 0.0
              AALGNH4(B)  = 0.0
              AALGNO3(B)  = 0.0
              AALGDON(B)  = 0.0
              AALGPON(B)  = 0.0
              ANT(B)      = 0.0
              ADENNO3(B)  = 0.0
              AMNLDON(B)  = 0.0
              AHDRPON(B)  = 0.0
              AALGPO4(B)  = 0.0
              AALGDOP(B)  = 0.0
              AALGPOP(B)  = 0.0
              AMNLDOP(B)  = 0.0
              AHDRPOP(B)  = 0.0
              ADO(B)      = 0.0
              ADORALG(B)  = 0.0
              ADOPR(B)    = 0.0
              ADCOD(B)    = 0.0
              ADDOC(B)    = 0.0
              ANITRIF(B)  = 0.0
11027       CONTINUE
            
            DO B=1,NBB
              DO N=1,NSPECIES
                ACHARV(B,N)   = 0.0
              END DO
            END DO

cvjp modified 11/3/2005
            DO I=1,NSAVCELL
              B=SAVCELL(I)
                APLEAF(B)     = 0.0
                ABMLEAF(B)    = 0.0
                ASLSH(B)      = 0.0
                APEP(B)       = 0.0
                ABMEP(B)      = 0.0
                APREP(B)      = 0.0
              ABMTUBER(B)   = 0.0
              ADOCSAV(B)    = 0.0
              APOCSAV(B)    = 0.0
              ADOCEPI(B)    = 0.0
              APOCEPI(B)    = 0.0
              ASEDCSAV(B)   = 0.0
              ANH4SAVW(B)   = 0.0
              ANO3SAVW(B)   = 0.0
              ADONSAVW(B)   = 0.0
              APONSAVW(B)   = 0.0
              ANH4EPI(B)    = 0.0
              ANO3EPI(B)    = 0.0
              ADONEPI(B)    = 0.0
              APONEPI(B)    = 0.0
              ASEDNSAV(B)   = 0.0
              ASEDNH4SAV(B) = 0.0          
              APO4SAVW(B)   = 0.0
              ADOPSAVW(B)   = 0.0
              APOPSAVW(B)   = 0.0
              APO4EPI(B)    = 0.0
              ADOPEPI(B)    = 0.0
              APOPEPI(B)    = 0.0
              ASEDPSAV(B)   = 0.0
              ASEDPO4SAV(B) = 0.0
              ADOSAV(B)     = 0.0
              ADOEPI(B)     = 0.0
              ASEDDOSAV(B)  = 0.0
            END DO
            
            DO B=1,NBB
              ABMB(B)       = 0.0
              APB(B)        = 0.0
              APRB(B)       = 0.0
              ABADOC(B)     = 0.0
              ABAPOC(B)     = 0.0
              ABANH4(B)     = 0.0
              ABANO3(B)     = 0.0
              ABAPON(B)     = 0.0
              ABAPO4(B)     = 0.0
              ABAPOP(B)     = 0.0
              ABADO(B)      = 0.0
            END DO  
                                 
            ELTMSKFL = ELTMS
          END IF
        END IF

******* Timestep, volume balance, and mass balance diagnostics

        IF (DIAGNOSTICS) THEN
          IF (JDAY.GE.NXDIA.OR.JDAY.GE.DIAD(DIADP+1)) THEN
            IF (JDAY.GE.DIAD(DIADP+1)) THEN
              DIADP = DIADP+1
              NXDIA = DIAD(DIADP)
            END IF
            NXDIA = NXDIA+DIAF(DIADP)
            WRITE(DIA,4000) INT(JDAY),(JDAY-INT(JDAY))*24.,NIT
            IF (AUTO_STEPPING) THEN
              WRITE(DIA,4010) INT(DLT),INT(DLTAV),COURMX,COURFS,COURBS
              WRITE(DIA,4012) INT(DLT),INT(DLTAV),DIFFMX,DIFFFS,DIFFBS
            END IF
            IF (VOLUME_BALANCE.AND.NEW_VOLUMES) THEN
              NEW_VOLUMES = .FALSE.
              WRITE (DIA,4020) 'Volume balance',JDAYVB,HOURVB
              DO 11030 B=1,NB
                IF (ABS(DLBV(B)).GT.10.0) THEN
                  WRITE (DIA,4030) B,V2VB(B),B,HMV(B),DLBV(B)
                END IF
11030         CONTINUE
              WRITE (DIA,4040) WQMTV2,(HMTV2-WQMTV2)/WQMTV2*100.0,
     .                         WQMDLV
            END IF
          END IF
        END IF

        IF (.NOT.STOP_RUN) GO TO 10500
 
      END IF

************************************************************************
**                          End Simulation                            **
************************************************************************

***** Write results in binary form for use as initial conditions

      IF (ICOND_OUT) THEN

***** Integrate sediments to steady state                               !MNOEL 2-5-93

        IF (STEADY_STATE_SED) CALL SED_INT
        
        OPEN (ICO,FILE=ICOFN,FORM='UNFORMATTED') 
        WRITE (ICO) TITLE
        WRITE (ICO) ((C1(B,J),B=0,NB),J=1,NCP)
        
        IF (SEDIMENT_CALC) WRITE (ICO) (CTEMP(B),B=1,NSB),
     $    ((CPOP(B,J),B=1,NSB),J=1,3),
     $    ((CPON(B,J),B=1,NSB),J=1,3), 
     $    ((CPOC(B,J),B=1,NSB),J=1,3),
     $    (CPIP(B),B=1,NSB),
     $    (PO4T2TM1S(B),B=1,NSB), (NH4T2TM1S(B),B=1,NSB),
     $    (NO3T2TM1S(B),B=1,NSB), (HST2TM1S(B),B=1,NSB),
     $    (CH4T2TM1S(B),B=1,NSB), (CH41TM1S(B),B=1,NSB),
     $    (SO4T2TM1S(B),B=1,NSB),
     $    (BENSTR1S(B),B=1,NSB),  (BBM(B),B=1,NSB)

       IF (SFEEDER) WRITE (ICO) ((SFEED(B,K),B=1,NSB),K=1,NSPECIES)


           IF (SAV_CALC) WRITE (ICO)
     .                   (LEAF(B),B=1,NSB),
     .                   (STEM(B),B=1,NSB),
     .                   (ROOT(B),B=1,NSB),
     .                   (TUBER(B),B=1,NSB),
     .                   (EP(B),B=1,NSB)

        CLOSE (ICO)
!
!  save bed information
!        
        if(sedtr_calc) then
          write(151) (((bed_frac(1,J,L,K),K=1,NSDCLS),L=1,NBED),J=1,NSB)
          write(151) ((bed(1,J,L,ithck),L=1,NBED),J=1,NSB)
          write(151) ((bed(1,J,L,iporo),L=1,NBED),J=1,NSB)
          write(151) ((bed(1,J,L,iaged),L=1,NBED),J=1,NSB)
          write(151) ((bed(1,J,L,idiff),L=1,NBED),J=1,NSB)
          close(151)
        endif
      END IF

***** Snapshot FORMAT statements

 3000 FORMAT('1')
 3010 FORMAT(1X,A72)
 3020 FORMAT(//
     .       1X,'Time related variables'/'+',22('_')//
     .       3X,'Julian day',T25,'=',F8.2/
     .       3X,'Elapsed time',T25,'=',I8,' days ',F6.2,' hours'/
     .       3X,'Number of iterations',T25,'=',I8/
     .       3X,'Timestep',T25,'=',F8.0,' sec'/
     .       3X,'Average time step',T25,'=',F8.0)
 3025 FORMAT(//
     .       1X,'After steady-state sediment computation'/'+',22('_')//
     .       3X,'Julian day',T25,'=',F8.2/
     .       3X,'Elapsed time',T25,'=',I8,' days ',F6.2,' hours'/
     .       3X,'Number of iterations',T25,'=',I8/
     .       3X,'Timestep',T25,'=',F8.0,' sec'/
     .       3X,'Average time step',T25,'=',F8.0)
 3030 FORMAT(/1X,A24/10(/10F8.4))
 3032 FORMAT(/1X,A20/10(/10F8.3))
 3033 FORMAT(/1X,A20/10(/10F8.2))
 3034 FORMAT(/1X,A20/10(/10(1PE8.2E1)))
 3035 FORMAT(/1X,'G',I1,1X,A20/10(/10(1PE8.2E1)))
 3036 FORMAT(/1X,'N',I1,1X,A20/10(/10(1PE8.2E1)))
 3037 FORMAT(/1X,'CLASS ',I2,A20/10(/10F8.3))
 3038 FORMAT(/1X,'CLASS ',I2,A20/10(/10F8.5))

***** Diagnostic FORMAT statements

 4000 FORMAT(/
     .       1X,79('*')//
     .       1X,'Date         =',I8,'  days ',F5.2,' hours'/
     .       1X,'# iterations =',I8)
 4010 FORMAT(1X,'Timestep',T15,'=',I8,2X,'Average timestep',T43,
     .         '=',I8/
     .       1X,'Courant #',T15,'=',F8.3/
     .       1X,'at face',T15,'=',I8,2X,'and box',T43,'=',I8/)
 4012 FORMAT(1X,'Timestep',T15,'=',I8,2X,'Average timestep',T43,
     .         '=',I8/
     .       1X,'Diffusion #',T15,'=',F8.3/
     .       1X,'at face',T15,'=',I8,2X,'and box',T43,'=',I8/)
 4020 FORMAT(/
     .       1X,A14,' performed at ',I6,' days and ',F5.2,' hours')
 4030 FORMAT(5X,'V2(',I4,') =',1PE15.6E1,' m*3',3X,'HMV(',I4,') =',
     .         1PE15.6E1,' m*3',3X,'Difference =',1PE15.6E1,' m*3')
 4040 FORMAT(/
     .       3X,'Water quality model volume      =',1PE20.12E2,' m*3'/
     .       3X,'Difference in total grid volume =',1PE20.3E2,' %'/
     .       3X,'Total difference in volume      =',1PE20.3E2,' m*3')
 4050 FORMAT(/
     .       1X,A22//
     .       (:3X,A24,T31,'=',1PE16.8E2,' kg'))
 4070 FORMAT(9F8.2)
 4080 FORMAT(8X,A24)

!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
      CALL COMM_EXIT()     !   DO MPI Cleanup
#endif
!.... PARALLEL SECTION ENDS

      STOP
      END PROGRAM PARWQM



      SUBROUTINE INPUTS()
      USE FILE_INFO; USE WQM; USE WQM_INIT
      USE ALGAL; USE SED; USE roms_init
!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
      USE MESSENGER
#endif
      IMPLICIT NONE
      integer :: j, jf, jg, jc, k, l, n
      integer :: i, ii, isf, jp, jnp
      integer :: js1, js2, js3

************************************************************************
**                              Inputs                                **
************************************************************************


      CDIFF=0.0
***** Open control file

      OPEN (CON,FILE=CONFN,STATUS='OLD')

***** Title cards

      READ(CON,1000)
      READ(CON,1010) (TITLE(J),J=1,6)

***** Grid setup

      READ (CON,1020)  NB,NSB,NQF,NHQF,NSQF,NL
 
      NBB = NSB  ! vjp 11/05/04  set number bottom boxes to number surface boxes

***** Time control

      READ (CON,1030)  TMSTRT,TMEND
      READ (CON,1040)  NDLT
      READ (CON,1030) (DLTD(J),J=1,NDLT)
      READ (CON,1030) (DLTVAL(J),J=1,NDLT)
      READ (CON,1030) (DLTMAX(J),J=1,NDLT)
      READ (CON,1030) (DLTFTN(J),J=1,NDLT)

C FILGTH IS LENGTH (IN DAYS) OF PERIOD SPANNED BY MET AND OTHER INPUT
C FILES.  NORMALLY 365 DAYS.
      READ (CON,1030)  AHMDLT, FILGTH

***** Output control

      READ (CON,1050)  SNPC,NSNP
      READ (CON,1030) (SNPD(J),J=1,NSNP)
      READ (CON,1030) (SNPF(J),J=1,NSNP)
      READ (CON,1055)  PLTC,QPLTC,SPLTC,SAVPLTC,NPLT
      READ (CON,1030) (PLTD(J),J=1,NPLT)
      READ (CON,1030) (PLTF(J),J=1,NPLT)
      READ (CON,1050)  APLTC,NAPL
      READ (CON,1030) (APLTD(J),J=1,NAPL)
      READ (CON,1030) (APLF(J),J=1,NAPL)
      READ (CON,1054)  HTFLC,VTFLC,STFLC,NTFL
      READ (CON,1030) (TFLD(J),J=1,NTFL)
      READ (CON,1030) (TFLF(J),J=1,NTFL)
      READ (CON,1052)  KFLC,NKFL
      READ (CON,1030) (KFLD(J),J=1,NKFL)
      READ (CON,1030) (KFLF(J),J=1,NKFL)
      READ (CON,1052)  OPLC,NOPL,NOINT
      READ (CON,1030) (OINT(J),J=1,NOINT)
      READ (CON,1030) (OPLD(J),J=1,NOPL)
      READ (CON,1030) (OPLF(J),J=1,NOPL)
      READ (CON,1050)  DIAC,NDIA
      READ (CON,1030) (DIAD(J),J=1,NDIA)
      READ (CON,1030) (DIAF(J),J=1,NDIA)

***** Hydrodynamic model

      READ (CON,1060)  HYDC

***** Hydrodynamic solution scheme

      READ (CON,1060)  SLC, CONSC, TH, MINSTEP

***** Controls

      READ (CON,1071)  SEDC,AUTOC,VBC,BFOC,STLC,ICIC,ICOC,SAVMC

c suspension feeders, light atenuation

      READ (CON,1072)  SFLC, SEDKIN, wtlmc

***** Dead sea case

      READ (CON,1070)  FLC,XYDFC,ZDFC

***** Dispersion

      READ (CON,1030)  XYDF,ZDFMUL

***** Constituent control cards

      READ (CON,1073)  S1C,    S2C,    S3C,  BFC,  ATMC,   SEDTR
      READ (CON,1080)  REDS1C, REDS1N, REDS1P, REDS2C, REDS2N, REDS2P,
     .                 REDS3C, REDS3N, REDS3P
      READ (CON,1080)  REDCBC, REDCBN, REDCBP
      READ (CON,1065)  BNDTC
      READ (CON,1070) (ACC(JC),JC=1,NCP)

***** Input filenames

      READ (CON,1020)  NHYDF,NTVDF
      READ (CON,1090)  MAPFN
      READ (CON,1090)  GEOFN
      READ (CON,1090)  ICIFN
      READ (CON,1090)  AGRFN
      READ (CON,1090)  SUSFN
      READ (CON,1090)  STLFN
      READ (CON,1090)  MRLFN                            !MNOEL 2/20/93
      READ (CON,1090)  KEIFN
      READ (CON,1090)  SAVFN
      read (con,1090)  wetlands_input
      READ (CON,1090) (HYDFN(J),J=1,NHYDF)
      READ (CON,1090) (METFN(J),J=1,NTVDF)
      READ (CON,1090) (S1FN(J),J=1,NTVDF)
      READ (CON,1090) (S2FN(J),J=1,NTVDF)
      READ (CON,1090) (S3FN(J),J=1,NTVDF)
      READ (CON,1090) (ATMFN(J),J=1,NTVDF)
      READ (CON,1090) (SVIFN(J),J=1,NTVDF)
      READ (CON,1090) (CBCFN(J),J=1,NTVDF)            !
      READ (CON,1090) (BFIFN(J),J=1,NTVDF)

***** Output filenames

      READ (CON,1090)  ICOFN                   !MNOEL  2-5-93
      READ (CON,1090)  SNPFN
      READ (CON,1090)  PLTFN
      READ (CON,1090)  APLFN
      READ (CON,1090)  DIAFN
      READ (CON,1090)  TFLFN
      READ (CON,1090)  KFLFN
      READ (CON,1090)  OPLFN
      read (con,1090)  wetlands_opt
      READ (CON,1090)  ALOFN
      READ (CON,1090)  BFOFN
      READ (CON,1090)  SVOFN
      READ (CON,1090)  SUDFN
      CLOSE (CON)

***** Initialize I/O logical control variables
      SEDTR_CALC       = SEDTR.EQ.' ON'         ! SK for sediment transport
      SOURCE_ONE       = S1C.EQ.' ON'           !MNOEL   1-25-93
      BENTHIC_FLUXES   = BFC.EQ.' ON'
      SOURCE_TWO       = S2C.EQ.' ON'           !MNOEL   1-25-93
      SOURCE_THR       = S3C.EQ.' ON'           !MNOEL   1-25-93
      ATMOS_LOADS      = ATMC.EQ.' ON'
      SAV_CALC         = SAVMC.EQ.' ON'
      SETTLING         = STLC.EQ.' ON'
      ICOND_OUT        = ICOC.EQ.' ON'              !MNOEL 2-5-93
      SEDIMENT_CALC    = SEDC.EQ.' ON'
      KINETIC_FLUXES   = KFLC.EQ.' ON'
      LIGHT_EXTINCTION = (ACC(4).EQ.' ON').OR.(ACC(5).EQ.' ON')
     .                   .OR.(ACC(6).EQ.' ON')
      UNI_ICON_IN      = ICIC.EQ.' UNIFORM'              !MNOEL 2-5-93
      BIN_ICON_IN      = ICIC.EQ.'  BINARY'              !MNOEL 2-5-93
      BINARY_HYDRO     = HYDC.EQ.'  BINARY'              !MNOEL 1-25-93
      ASCII_HYDRO      = HYDC.EQ.'   ASCII'              !MNOEL 1-25-93
      DEPTH_AVG_HYDRO  = HYDC.EQ.'DEPTH_AV'
      SIGMA_HYDRO      = .FALSE.                         !FOR CHESAPEAKE BAY CFC 1/23/06 
c      SIGMA_HYDRO      = .TRUE.                         !JLM HARDWIRE FOR LOWER ST. JOHNS
c suspension feeder control

      SFEEDER          = SFLC .EQ. ' ON'
      HYPOXFX          = .TRUE.

***** Active Constituents

      NAC = 0
      DO 10000 JC=1,NCP
        IF (ACC(JC).EQ.' ON') THEN
          NAC     = NAC+1
          AC(NAC) = JC
        END IF
10000 CONTINUE

***** Open remaining input files

      HYDPTR = 1
      METPTR = 1
      CBCPTR = 1
      S1PTR  = 1
      S2PTR  = 1
      S3PTR  = 1
      BFIPTR = 1
      KEIPTR = 1
      ATMPTR = 1
      SAVPTR = 1
        
      OPEN (MET,FILE=METFN(METPTR),STATUS='OLD')
      IF (SETTLING)         OPEN (STL,FILE=STLFN,STATUS='OLD')
      IF (LIGHT_EXTINCTION) OPEN (KEI,FILE=KEIFN,STATUS='OLD')
      IF (LIGHT_EXTINCTION) OPEN (AGR,FILE=AGRFN,STATUS='OLD')
      IF (SEDIMENT_CALC.OR.BENTHIC_FLUXES)
     $                      OPEN (BFI,FILE=BFIFN(BFIPTR),STATUS='OLD')
                            OPEN (CBC,FILE=CBCFN(CBCPTR),STATUS='OLD') 
      IF (SOURCE_ONE)       OPEN (S1, FILE=S1FN(S1PTR),  STATUS='OLD')
      IF (SOURCE_TWO)       OPEN (S2, FILE=S2FN(S2PTR),  STATUS='OLD')
      IF (SOURCE_THR)       OPEN (S3, FILE=S3FN(S3PTR),  STATUS='OLD')
      IF (SAV_CALC)         OPEN (SVI,FILE=SVIFN(SAVPTR),STATUS='OLD')
      IF (ATMOS_LOADS)      OPEN (ATM,FILE=ATMFN(ATMPTR),STATUS='OLD')
      IF (ASCII_HYDRO)  THEN
        OPEN (HYD,FILE=HYDFN(HYDPTR),STATUS='OLD')
      ELSE
        OPEN (HYD,FILE=HYDFN(HYDPTR),STATUS='OLD', FORM='UNFORMATTED')
      END IF
c

******  SK - PREPARE FOR SEDIMENT TRANSPORT CALCULATION
 
      IF (SEDTR_CALC) then
        OPEN(CON,FILE=SEDCONFN, STATUS='OLD')
 
        ! OPEN FILES FOR STRESS AND SHEAR
        READ (CON,1090) (USTFN(J),J=1,NHYDF)
        
        IF (ASCII_HYDRO)  THEN       
          OPEN  (141,FILE=USTFN(HYDPTR),STATUS='OLD')
        ELSE
          OPEN  (141,FILE=USTFN(HYDPTR),FORM='UNFORMATTED',
     .               STATUS='OLD')
        ENDIF

        ! INITIALIZE ROMS VARIABLES
        CALL INIT_SEDIMENT()  
      ENDIF

      NEW_HYDRO_FILE = .TRUE.           ! TKG 8-2001: Flag new hydro file

***** Flow mapping data

      OPEN (MAP,FILE=MAPFN,STATUS='OLD')
      READ (MAP,1110) (QD(F),ILB(F),IB(F),JB(F),JRB(F),F=1,NQF)
      READ (MAP,1027) (NVF(SB),SB=1,NSB)
      READ (MAP,1100)
      DO 10010 SB=1,NSB
        READ (MAP,1130) (VFN(F,SB),F=1,NVF(SB))
10010 CONTINUE
      CLOSE (MAP)

***** Geometric data

      OPEN (GEO,FILE=GEOFN,STATUS='OLD')
      IF (ASCII_HYDRO) THEN
        READ (GEO,1000)
        READ (GEO,1150) (BL(B,1),BL(B,2),BL(B,3),V1(B),ZD(B),
     .                   BU(B),B=1,NB)
        READ (GEO,1170) (SBN(SB),BBN(SB),SB=1,NSB)
        READ (GEO,1160) (A(F),F=1,NQF)
        DO 10015 SB=1,NSB
         SFA(SB) = V1(SBN(SB))/BL(SBN(SB),3)
10015   CONTINUE
      ELSE
        READ (GEO,1120) (BU(B),B=1,NB)
        READ (GEO,1140) (SBN(SB),BBN(SB),SB=1,NSB)
      END IF
      CLOSE (GEO)

***** SAF - 20 July 2006 - Begin Addition
c
c      addition for determining the box
c      below the current box
c
***** Calculate BD from BU
c
      DO 10020 B=1,NB
        IF ( BU(B) .NE. 0 ) THEN
          BD(BU(B)) = B
        END IF
10020 CONTINUE
c
***** SAF - 20 July 2006 - End Addition

***** Time-invariant hydrodynamic data

      IF (BINARY_HYDRO) THEN                            !MNOEL 1-25-93
        IF(SIGMA_HYDRO)THEN                             !JLM FOR LOWER ST. JOHNS
           READ (HYD) (SFA(SB),SB=1,NSB)
           READ (HYD) (BL(SB,1),SB=1,NSB)
           READ (HYD) (BL(SB,2),SB=1,NSB)
           READ (HYD) (HQCFA(F),F=1,NSQF)
           READ (HYD) (HMCV(SB),SB=1,NSB)
cjlm changed for st. johns for now, have backwards
c          READ (HYD) (DLZF(L),L=1,NL)
           READ (HYD) (DLZF(L),L=NL,1,-1)
        ELSE ! FOR PARALLEL VERSION CFC 1/23/06
           READ (HYD) (SFA(SB),SB=1,NSB)
           READ (HYD) (BL(SB,1),SB=1,NSB)
           READ (HYD) (BL(SB,2),SB=1,NSB)
           READ (HYD) (A(F),F=1,NHQF)
           READ (HYD) (HMBV(SB),SB=1,NSB)
           READ (HYD) (HMSBV(SB),SB=1,NSB)
        END IF
      ELSE IF (ASCII_HYDRO) THEN                        !MNOEL 1-25-93
        READ (HYD,1000)
c
c  SK
c
c  for sediment transport
c
        if(sedtr_calc) then
          READ(141,1000)
        endif
      ELSE IF (DEPTH_AVG_HYDRO) THEN
        READ (HYD)  SFA
        READ (HYD) (A(F),F=1,NHQF)
        READ (HYD) (BL(SB,1),SB=1,NSB)
        READ (HYD) (BL(SB,2),SB=1,NSB)
        READ (HYD)  HMSBV
      ELSE
        WRITE(*,*) 'hydro file specified incorrectly'
        STOP
      END IF

***** Suspension feeders

      IF (SFEEDER) THEN

        OPEN (SUS,FILE=SUSFN,STATUS='OLD')
        READ(SUS,1032)
        READ(SUS,1020) NSPECIES    ! # of susp. feeders species to be modeled
        READ(SUS,1031) FRDOCSF      ! Fraction of respiration released as DOC
        DO N=1,NSPECIES
          READ(SUS,1031) SFA1(N),SFA2(N),SFA3(N),SFA4(N),SFA5(N)
          READ(SUS,1031) FILT(N),MAXING(N),BMRSF(N),RFSF(N),
     .      SFPRPWR(N)
          READ(SUS,1031) SFCN(N),SFCP(N),SFTD(N),SFDOH(N),SFDOQ(N)
          READ(SUS,1034) TOPTSF(N),KTG1SF(N),KTG2SF(N),SFTMN(N),
     .      AQUACULTURE(N)
        ENDDO

        READ(SUS,1032)
        DO B=1,NBB
	  DO N=1,NSPECIES
            READ (SUS,1001) SEDTYPE(B,N),SFEED(B,N),SFPRED(B,N),
     .        HARVEST(B,N),NYUIJ(B,N),FR_RSUSP(B,N),SCOVER(B,N)
          END DO
        ENDDO
        CLOSE (SUS)
      END IF

c initialize arrays that are passed in case susp. feeder model not used

      DO B=1,NBB
        SFLUXC(B)=0.0
        SF_RPOC(B)=0.0
	SF_LDOC(B)=0.0
        SFLUXN(B)=0.0
        SF_RPON(B)=0.0
        SFLUXP(B)=0.0
        SF_RPOP(B)=0.0
        JNH4SF(B)=0.0
        JPO4SF(B)=0.0
        SODSF(B)=0.0
        SF_SSI(B)=0.0
	SF_CLY(B)=0.0
	SF_SLT(B)=0.0
	SF_ORG(B)=0.0
        SF_PIP(B)=0.0
      ENDDO

************************************************************************
**                   Parameters for SAV Submodel                      **
************************************************************************

      IF (SAV_CALC)  THEN
        OPEN(SAVPF,FILE=SAVFN,STATUS='OLD')
        CALL SAV_READ
        CLOSE(SAVPF)
      END IF

******* Initial conditions 

******* Uniform constituent initial concentrations


        IF (UNI_ICON_IN) THEN                              !MNOEL 2-5-93 
          OPEN (ICI,FILE=ICIFN,STATUS='OLD')
          READ(ICI,1100)
          READ(ICI,1030) (CIC(JC),JC=1,NCP)

          IF (SEDIMENT_CALC) THEN
            READ (ICI,1030) CTEMPI
            READ (ICI,1030) (CPOPI(JG),JG=1,3)
            READ (ICI,1030) (CPONI(JG),JG=1,3)
            READ (ICI,1030) (CPOCI(JG),JG=1,3)
            READ (ICI,1030) CPIPI,  PO4T2I, NH4T2I, NO3T2I  
            READ (ICI,1030) HST2I, CH4T2I, CH41TI, SO4T2I, 
     $                      BENSTI
            READ (ICI,1030) BBMI 
          END IF

          IF (SFEEDER) READ (ICI,1030) (SFEEDI(N), N=1,NSPECIES) 
          IF (SAV_CALC) READ (ICI,1030) LEAFI, STEMI, ROOTI,
     $       TUBERI, EPI
 
***** Constituent concentrations 

          DO 10120 JC=1,NAC
            DO 10130 B=1,NB
              C1(B,AC(JC))    = CIC(AC(JC))
              C2(B,AC(JC))    = CIC(AC(JC))
              C1MIN(B,AC(JC)) = 1.E10
              C1MAX(B,AC(JC)) = 0.
10130       CONTINUE
10120     CONTINUE

          IF (SFEEDER) THEN
            DO B=1,NBB
              DO N=1,NSPECIES
                IF (AQUACULTURE(N) .NE. '      ON') 
     $            SFEED(B,N) = SFEEDI(N)
              END DO
            END DO
          END IF

          IF (SEDIMENT_CALC) THEN
            DO 10140 B=1,NBB
              CTEMP(B)      = CTEMPI
              DO 10150 JG=1,3
                CPOP(B,JG)  = CPOPI(JG)
                CPON(B,JG)  = CPONI(JG)
                CPOC(B,JG)  = CPOCI(JG)
10150         CONTINUE
              BBM(B)        = BBMI
              CPIP(B)       = CPIPI
              PO4T2TM1S(B)  = PO4T2I
              NH4T2TM1S(B)  = NH4T2I
              NO3T2TM1S(B)  = NO3T2I
              HST2TM1S(B)   = HST2I
              CH4T2TM1S(B)  = CH4T2I
              CH41TM1S(B)   = CH41TI
              SO4T2TM1S(B)  = SO4T2I
              BENSTR1S(B)   = BENSTI
10140       CONTINUE
          END IF
          
cvjp modified 11/3/2005
          IF (SAV_CALC) THEN
            DO I=1,NSAVCELL
              B = SAVCELL(I)
                LEAF(B) = LEAFI
                STEM(B) = STEMI
                ROOT(B) = ROOTI
                TUBER(B)= TUBERI
                EP(B)   = EPI
            END DO
          END IF

******* Binary constituent initial concentrations

        ELSE IF (BIN_ICON_IN) THEN                              !MNOEL 2-5-93
          OPEN (ICI,FILE=ICIFN,STATUS='OLD',FORM='UNFORMATTED') 
          READ (ICI) OLDTITLE

          READ (ICI) ((C1(B,JC),B=0,NB),JC=1,NCP)
          DO 10046 JC=1,NAC
            DO 10047 B=1,NB
              C1(B,AC(JC)) = MAX(C1(B,AC(JC)),0.0)     
              C2(B,AC(JC)) = C1(B,AC(JC))
10047       CONTINUE
10046     CONTINUE

          IF (SEDIMENT_CALC) THEN
            READ (ICI) (CTEMP(B),B=1,NSB),
     .       ((CPOP(B,J),B=1,NSB),J=1,3),
     .       ((CPON(B,J),B=1,NSB),J=1,3),
     .       ((CPOC(B,J),B=1,NSB),J=1,3),
     .       (CPIP(B),B=1,NSB),
     .       (PO4T2TM1S(B),B=1,NSB), (NH4T2TM1S(B),B=1,NSB),
     .       (NO3T2TM1S(B),B=1,NSB), (HST2TM1S(B),B=1,NSB),
     .       (CH4T2TM1S(B),B=1,NSB), (CH41TM1S(B),B=1,NSB),
     .       (SO4T2TM1S(B),B=1,NSB),
     .       (BENSTR1S(B),B=1,NSB),  (BBM(B),B=1,NSB)
          ENDIF

          IF (SFEEDER) THEN
            READ (ICI) ((SFEEDIN(B,K),B=1,NSB),K=1,NSPECIES)
            DO K=1,NSPECIES
              IF (AQUACULTURE(K) .NE. '      ON') THEN
                DO B=1,NSB
                  SFEED(B,K) = SFEEDIN(B,K)
                END DO
              END IF
            END DO
          END IF

          IF (SAV_CALC) READ(ICI) (LEAF(B),B=1,NSB),
     .                            (STEM(B),B=1,NSB),
     .                            (ROOT(B),B=1,NSB),
     .                            (TUBER(B),B=1,NSB),
     .                            (EP(B),B=1,NSB)

c temporary hardwire

cvjp modified 11/3/2005
c     DO B=1,NSB
c       DO N=1,NSINC
c         LEAF(B,N)=0.0
c         STEM(B,N)=0.0
c         ROOT(B,N)=0.0
c         TUBER(B,N)=0.0
c         EP(B,N)=0.0
c       END DO
c     END DO
c     DO I=1,NSAVCELL
c       B = SAVCELL(I)
c       DO N=1,NSAVDPH(B)
c         LEAF(B,N)=5.0
c         STEM(B,N)=1.0
c         ROOT(B,N)=5.0
c         TUBER(B,N)=1.0
c         EP(B,N)=0.10
c       END DO
c     END DO

          CLOSE (ICI)

        ELSE
          WRITE(*,*) 'initial conditions file specified incorrectly'
          STOP
        END IF

***** Mineralization rates

      OPEN (MRL,FILE=MRLFN,STATUS='OLD')                        !MNOEL 2-20-93
      READ (MRL,1032)
      
***** Spatially-invariant kinetics parameters

      READ (MRL,1080)  KHONT,  KHNNT,  KHOCOD, KHODOC, KHNDN
      READ (MRL,1080)  AOCR,   AONT,   ANDC
      READ (MRL,1080)  TRCOD,  TRMNL,  TRHDR
      READ (MRL,1080)  KTCOD,  KTMNL,  KTHDR
      READ (MRL,1080)  KTNT1,  KTNT2,  TMNT
      READ (MRL,1080)  KADPO4, JBSPO4, JESPO4
      READ (MRL,1081)  AREAR,  BREAR,  CREAR, DREAR, EREAR
      IF (EREAR .NE. '    WIND' .AND. EREAR .NE. '    VELO' 
     $  .AND. EREAR .NE. '   INPUT') WRITE(*,*) 
     $ 'EREAR INCORRECLY SPECIFIED'

***** Spatially-varying kinetics parameters

      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KLDC(1)
        DO I=2,NB
          KLDC(I)=KLDC(1)
        END DO
      ELSE
        READ (MRL,1033) (KLDC(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KRDC(1)
        DO I=2,NB
          KRDC(I)=KRDC(1)
        END DO
      ELSE
        READ (MRL,1033) (KRDC(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KLPC(1)
        DO I=2,NB
          KLPC(I)=KLPC(1)
        END DO
      ELSE
        READ (MRL,1033) (KLPC(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KRPC(1)
        DO I=2,NB
          KRPC(I)=KRPC(1)
        END DO
      ELSE
        READ (MRL,1033) (KRPC(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KG3C(1)
        DO I=2,NB
          KG3C(I)=KG3C(1)
        END DO
      ELSE
        READ (MRL,1033) (KG3C(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KLDN(1)
        DO I=2,NB
          KLDN(I)=KLDN(1)
        END DO
      ELSE
        READ (MRL,1033) (KLDN(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KRDN(1)
        DO I=2,NB
          KRDN(I)=KRDN(1)
        END DO
      ELSE
        READ (MRL,1033) (KRDN(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KLPN(1)
        DO I=2,NB
          KLPN(I)=KLPN(1)
        END DO
      ELSE
        READ (MRL,1033) (KLPN(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KRPN(1)
        DO I=2,NB
          KRPN(I)=KRPN(1)
        END DO
      ELSE
        READ (MRL,1033) (KRPN(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KG3N(1)
        DO I=2,NB
          KG3N(I)=KG3N(1)
        END DO
      ELSE
        READ (MRL,1033) (KG3N(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KLDP(1)
        DO I=2,NB
          KLDP(I)=KLDP(1)
        END DO
      ELSE
        READ (MRL,1033) (KLDP(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KRDP(1)
        DO I=2,NB
          KRDP(I)=KRDP(1)
        END DO
      ELSE
        READ (MRL,1033) (KRDP(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KLPP(1)
        DO I=2,NB
          KLPP(I)=KLPP(1)
        END DO
      ELSE
        READ (MRL,1033) (KLPP(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KRPP(1)
        DO I=2,NB
          KRPP(I)=KRPP(1)
        END DO
      ELSE
        READ (MRL,1033) (KRPP(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KG3P(1)
        DO I=2,NB
          KG3P(I)=KG3P(1)
        END DO
      ELSE
        READ (MRL,1033) (KG3P(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KCOD(1)
        DO I=2,NB
          KCOD(I)=KCOD(1)
        END DO
      ELSE
        READ (MRL,1033) (KCOD(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KDPALG(1)
        DO I=2,NB
          KDPALG(I)=KDPALG(1)
        END DO
      ELSE
        READ (MRL,1033) (KDPALG(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) KDPIP(1)
        DO I=2,NB
          KDPIP(I)=KDPIP(1)
        END DO
      ELSE
        READ (MRL,1033) (KDPIP(B),B=1,NB)
      END IF
      READ (MRL,1060) SPVARM, PRINTM
      IF (SPVARM .EQ. 'CONSTANT') THEN
        READ(MRL,1033) NTM(1)
        DO I=2,NB
          NTM(I)=NTM(1)
        END DO
      ELSE
        READ (MRL,1033) (NTM(B),B=1,NB)
      END IF
      IF (EREAR .EQ. '   INPUT') THEN         ! CFC 04/05/16
        READ (MRL,1060) SPVARM, PRINTM
        IF (SPVARM .EQ. 'CONSTANT') THEN
          READ(MRL,1033) KRDO(1)
          DO I=2,NSB
            KRDO(I)=KRDO(1)
          END DO
        ELSE
          READ (MRL,1033) (KRDO(B),B=1,NSB)
        END IF
      END IF
      CLOSE (MRL)

***** Boundary concentrations

        READ (CBC,1100)
        READ (CBC,1020) NCB                 ! CFC 2/28/06
        READ (CBC,1100)

***** Sources One

      IF (SOURCE_ONE) THEN                         !MNOEL   1-25-93
        READ (S1,1100)
        READ (S1,1020) (S1LN(JC),JC=1,NCP)
        DO JC=1,NAC
          II=AC(JC)
          READ (S1,1020) (S1LB(JP,II),JP=1,S1LN(II))
        END DO
        READ (S1,1100)
      END IF

***** Sources Two

      IF (SOURCE_TWO) THEN                         !MNOEL   1-25-93
        READ (S2,1100)
        READ (S2,1020) (S2LN(JC),JC=1,NCP)
		write(*,*) ncp, nac
        DO JC=1,NAC
          II=AC(JC)
		  write(*,*) 'ii ',ii		  
          READ (S2,1020) (S2LB(JNP,II),JNP=1,S2LN(II))
		  write(*,*) (S2LB(JP,II),JP=1,S2LN(II))
        END DO
        READ (S2,1100)
      END IF

***** Sources Three

      IF (SOURCE_THR) THEN                         
        READ (S3,1100)
        READ (S3,1020) (S3LN(JC),JC=1,NCP)
        DO JC=1,NAC
          II=AC(JC)
          READ (S3,1020) (S3LB(JNP,II),JNP=1,S3LN(II))
        END DO
        READ (S3,1100)
      END IF

***** Light extinction and algal growth

      IF (LIGHT_EXTINCTION) THEN      

        READ (KEI,1032)

C PARTIAL ATTENUATION MODEL
      
          READ (KEI,1038) KECHL, KESAL, VSStoPOC
          READ (KEI,1082) SPVARKE, PRINTKE
          IF (SPVARKE .EQ. 'CONSTANT') THEN
            READ (KEI,1086) KE(1),KEISS(1),KEVSS(1)
            DO B=2,NSB
              KE(B) = KE(1)
              KEISS(B)=KEISS(1)
              KEVSS(B)=KEVSS(1)
            END DO
          ELSE
            READ (KEI,1086) (KE(B),KEISS(B),KEVSS(B),B=1,NSB)
          END IF

C INITIALIZE KESS

        DO B=1,NB
          KESS(B) = KE(B)
        END DO

        CLOSE(KEI)

      END IF

***** Algae

      IF (LIGHT_EXTINCTION) then
          CALL ALG_READ
      ENDIF

***** Settling rates

      IF (SETTLING) THEN
        READ (STL,1032)
        READ (STL,1060) SPVARM, PRINTM
        READ(STL,1033) WSS(1),WSL(1),WSR(1),WSG3(1),WS1(1),WS2(1),
     $    WS3(1),WSPO4(1),WSPIP(1)
        IF (SPVARM .EQ. 'CONSTANT') THEN
          DO I=2,NB
            WSS(I)=WSS(1)
            WSL(I)=WSL(1)
            WSR(I)=WSR(1)
            WSG3(I)=WSG3(1)
            WS1(I)=WS1(1)
            WS2(I)=WS2(1)
            WS3(I)=WS3(1)
	    WSPO4(I)=WSPO4(1)
	    WSPIP(I)=WSPIP(1)
          END DO
        ELSE
          DO 10080 B=2,NB
            READ(STL,1085) WSS(B),WSL(B),WSR(B),WSG3(B),WS1(B),WS2(B),
     $        WS3(B),WSPO4(B),WSPIP(B)
10080   CONTINUE
        END IF
        CLOSE (STL)
      END IF

***** Atmospheric loads

      IF (ATMOS_LOADS) READ (ATM,1000)

***** Benthic fluxes

      IF (BENTHIC_FLUXES) THEN
        READ (BFI,1000)
            READ  (BFI,1085)  KSDOC,KSNH4,KSNO3,KSPO4,KSO
            READ  (BFI,1080)  TRSDOC,TRSNH4,TRSNO3,TRSPO4,TRSO
            READ  (BFI,1080)  MTCNO3, SEDNO3, KHSO  
        READ (BFI,1100)
      END IF

***** Meteorologic data

      READ (MET,1000)

***** Wetlands Inputs

      if (wtlmc .eq. ' ON') call read_wetlands ()

***** Input FORMAT statements

 1000 FORMAT(///)
 1001 FORMAT(12X,I4,6F10.3)
 1002 FORMAT(7F10.3)
 1003 FORMAT(8F10.3)
 1005 FORMAT(//F10.1)
 1010 FORMAT(A72)
 1020 FORMAT(//(8X,9I8))
 1025 FORMAT(8X,9I8)
 1027 FORMAT(//(11X,8I8))
 1030 FORMAT(//(8X,9F8.0))
 1031 FORMAT(//(8X,9F8.2))
 1032 FORMAT(/)
 1033 FORMAT(//:(8X,9F8.0))
 1034 FORMAT(//(8X,4F8.2,A8))
 1035 FORMAT(:///10(10F8.0:/))
 1036 FORMAT(//8X,2F8.1,I8,3F8.1)
 1037 FORMAT(//8X,8F8.1)
 1038 FORMAT(//8X,8F8.1)
 1040 FORMAT(//8X,I8,8F8.0)
 1050 FORMAT(//13X,A3,I8,5X,A3)
 1052 FORMAT(//13X,A3,9I8)
 1054 FORMAT(//8X,3(5X,A3),I8)
 1055 FORMAT(//8X,4(5X,A3),I8)
 1060 FORMAT(//8X,2A8,2F8.0)
 1065 FORMAT(://(8X,9A8))
 1070 FORMAT(//(8X,9(5X,A3)))
 1071 FORMAT(//(8X,5(5X,A3),A8,5X,A3,5X,A3))
 1072 FORMAT(//(8X,3(5X,A3)))
 1073 FORMAT(//(8X,7(5X,A3)))
 1080 FORMAT(://8X,9F8.0)
 1081 FORMAT(://8X,4F8.0,A8)
 1082 FORMAT(//8X,2A8//)
 1085 FORMAT(8X,9F8.0)
 1086 FORMAT(8X,3F8.0)
 1087 FORMAT(8X,4F8.0)
 1088 FORMAT(8X,2F8.0)
 1089 FORMAT(8X,I8)
 1090 FORMAT(//(8X,A72))
 1100 FORMAT(/)
 1110 FORMAT(:////////(8X,5I8))
 1120 FORMAT(////(8X,I8))
 1130 FORMAT(8X,9I8)
 1140 FORMAT(://(2I8))
 1150 FORMAT(5X,3F15.0,F18.0,F12.0,I10)
 1160 format(://(13X,F13.0))
 1170 FORMAT(://(2I10))
 1190 FORMAT(I8,9F8.2)
 1200 FORMAT(/(10F12.0))
 1220 FORMAT(//(:8X,6F8.0))

************************************************************************
**                 Initialize Computational Variables                 **
************************************************************************

***** Logical control variables

      VOLUME_BALANCE   = VBC.EQ.' ON'
      FLOW             = FLC.EQ.' ON'
      PLOTS            = PLTC.EQ.' ON'
      OXYGEN_PLOTS     = OPLC.EQ.' ON'
      SNAPSHOTS        = SNPC.EQ.' ON'
      BENTHIC_OUTPUT   = BFOC.EQ.' ON'
      H_TRANS_FLUX     = HTFLC.EQ.' ON'
      V_TRANS_FLUX     = VTFLC .EQ. ' ON'
      S_TRANS_FLUX     = STFLC .EQ. ' ON'
      DIAGNOSTICS      = DIAC.EQ.' ON'
      Z_DIFFUSION      = ZDFC.EQ.' ON'
      AVERAGE_PLOTS    = APLTC.EQ.' ON'
      QUALITY_DIAG     = QPLTC.EQ.' ON'
      AUTO_STEPPING    = AUTOC.EQ.' ON'
      XY_DIFFUSION     = XYDFC.EQ.' ON'
      UPWIND           = SLC.EQ.'  UPWIND'
      QUICKEST         = SLC.EQ.'QUICKEST'
      STEP_BOUNDARY    = BNDTC.EQ.'    STEP'
      CONSERVE_MASS    = CONSC.EQ.'    MASS'
      SEDIMENT_DIAG    = SPLTC.EQ.' ON'.AND.(SEDIMENT_CALC.OR.
     .                   BENTHIC_FLUXES)
      SAV_PLOTS        = SAVPLTC.EQ.' ON'.AND. SAV_CALC
      END_RUN          = .FALSE.
      DO 10090 F=1,NHQF
        IF (ILB(F).EQ.0) LEFTM1_BOUNDARY(F)  = .TRUE.
        IF (JB(F).EQ.0) RIGHT_FLOWB(F) = .TRUE.
        IF (IB(F).EQ.0) THEN
          LEFT_FLOWB(F) = .TRUE.
          IBT(F)=JB(F)
        ELSE
          IBT(F)=IB(F)
        ENDIF
        IF (JRB(F).EQ.0) RIGHTP1_BOUNDARY(F) = .TRUE.
10090 CONTINUE

      IF (ACC(1).EQ.' ON')  TEMPERATURE_CALC = .TRUE.
      IF (ACC(3).EQ.' ON')  SOLIDS_CALC      = .TRUE.
      IF ((ACC(4).EQ.' ON').OR.(ACC(5).EQ.' ON')
     .  .OR.(ACC(6).EQ.' ON'))  ALGAE_CALC   = .TRUE.
      IF (ACC(9).EQ.' ON')  CARBON_CALC      = .TRUE.
      IF (ACC(13).EQ.' ON') NITROGEN_CALC    = .TRUE.
      IF (ACC(20).EQ.' ON') PHOSPHORUS_CALC  = .TRUE.
      IF (ACC(26).EQ.' ON') COD_CALC         = .TRUE.
      IF (ACC(27).EQ.' ON') OXYGEN_CALC      = .TRUE.
      IF (ACC(25).EQ.' ON') PIP_CALC         = .TRUE.

***** Time variables

      NIT      = 0
      JDAY     = TMSTRT
      DLTDP    = 1
      TFLDP    = 1
      KFLDP    = 1
      SNPDP    = 1
      PLTDP    = 1
      APLDP    = 1
      OPLDP    = 1
      DIADP    = 1
      NWQMR    = 0
      DLT      = DLTVAL(DLTDP)
      DLT8     = DLTVAL(DLTDP) !flag
      ELTMSPLT = JDAY*86400.
      ELTMSTFL = JDAY*86400.
      ELTMSKFL = JDAY*86400.
      
      NHMR  = 0
      NXTVD = JDAY
      ELTMS = JDAY*86400.
      MXDLT = DLTMAX(DLTDP)
      FNDLT = DLTFTN(DLTDP)
      NXSNP = SNPD(SNPDP)
      NXPLT = PLTD(PLTDP)
      NXTFL = TFLD(TFLDP)
      NXKFL = KFLD(KFLDP)
      NXOPL = OPLD(OPLDP)
      NXDIA = DIAD(DIADP)
      NXAPL = APLTD(APLDP)

***** Output control variables

      SNPD(NSNP+1)  = TMEND+1.
      PLTD(NPLT+1)  = TMEND+1.
      OPLD(NOPL+1)  = TMEND+1.
      TFLD(NTFL+1)  = TMEND+1.
      KFLD(NKFL+1)  = TMEND+1.
      DLTD(NDLT+1)  = TMEND+1.
      DIAD(NDIA+1)  = TMEND+1.
      APLTD(NAPL+1) = TMEND+1.

***** Geometry initialization

        IF (ASCII_HYDRO) THEN                                             !MNOEL 1-25-93
          DO 10155 B=1,NB
            HMV(B) = V1(B)
10155     CONTINUE

        ELSE 
        
********* Initialize volumes

        IF(SIGMA_HYDRO)THEN                             !JLM FOR LOWER ST. JOHNS
            DO 10113 SB=1,NSB
              DO 10116 F=1,NVF(SB)
                HMV(IB(VFN(F,SB))) = HMCV(SB)*DLZF(F)
                V1(IB(VFN(F,SB)))  = HMV(IB(VFN(F,SB)))
10116         CONTINUE
              HMV(SB) = HMCV(SB)*DLZF(NL)
              V1(SB)  = HMV(SB)
10113       CONTINUE
        ELSE
          DO 10110 SB=1,NSB
            DO 10100 F=1,NVF(SB)
              HMV(IB(VFN(F,SB))) = HMBV(SB)
              V1(IB(VFN(F,SB)))  = HMBV(SB)
10100       CONTINUE
            HMV(SB) = HMSBV(SB)
            V1(SB)  = HMSBV(SB)
10110     CONTINUE
        END IF
********* Initialize horizontal flow facial areas
        IF(SIGMA_HYDRO)THEN                             !JLM FOR LOWER ST. JOHNS
            F=1
            DO 10136 L=1,NL
              DO 10135 ISF=1,NSQF
                A(F)=HQCFA(ISF)*DLZF(L)
                F=F+1
10135         CONTINUE
10136       CONTINUE
        END IF
********* Initialize box lengths

          DO 10330 SB=1,NSB

            DO 10320 F=1,NVF(SB)
              BL(IB(VFN(F,SB)),1) = BL(JB(VFN(NVF(SB),SB)),1)
              BL(IB(VFN(F,SB)),2) = BL(JB(VFN(NVF(SB),SB)),2)
              BL(IB(VFN(F,SB)),3) = HMV(IB(VFN(F,SB)))/SFA(SB)
10320       CONTINUE
            BL(SB,3) = HMV(SB)/SFA(SB)
10330     CONTINUE

********* Initialize vertical flow facial areas

          DO 10350 SB=1,NSB
            DO 10340 F=1,NVF(SB)
             A(VFN(F,SB)) = SFA(SB)
10340       CONTINUE
10350     CONTINUE

        END IF

******* Initialize total surface area

        SFATOT = 0.0
        DO 10156 SB=1,NSB
          SFATOT = SFATOT+SFA(SB)
10156   CONTINUE

******* Initialize volumes

        DO 10360 B=1,NB
          V2(B) = V1(B)
10360   CONTINUE

******* Initialize depths

        DO 10164 B=1,NB
          ZD(B) = 0.0
10164   CONTINUE

        DO 10166 SB=1,NSB
        IF (NVF(SB) .GT. 0) THEN

          DO 10165 F=NVF(SB),1,-1
            ZD(IB(VFN(F,SB))) = ZD(JB(VFN(F,SB)))
     .                          +BL(JB(VFN(F,SB)),3)
10165     CONTINUE
        END IF
10166   CONTINUE

******* Initialize concentrations in lateral flows

       DO B=1,NB
         DO JC=1,NAC
           CONLIT(B,JC)=0.0
         END DO
         CONLIT(B,10) = DOCLIT
         CONLIT(B,11) = LPOCLIT
         CONLIT(B,12) = RPOCLIT         
         CONLIT(B,28) = PBSLIT
       END DO

******* Zero QUICKEST Courant numbers and vertical face numbers

        DO 10180 SB=1,NSB
          VFN(0,SB)         = 0
          VFN(NVF(SB)+1,SB) = 0
          CR2(0,SB)         = 0.0
          DO 10170 F=0,NVF(SB)
            CR1(F,SB) = 0.0
10170     CONTINUE
10180   CONTINUE

        NXCBC = 0.

***** Averages

        DO 10182 JC=1,NAC
          DO 10181 B=1,NB
            AC1(B,AC(JC)) = 0.0
10181     CONTINUE
10182   CONTINUE
        DO 10184 JC=1,NAC
          DO 10183 F=1,NQF
            AFLUXT(F,AC(JC)) = 0.0
            AFLUXS(F,AC(JC)) = 0.0
10183     CONTINUE
10184   CONTINUE
        DO 10186 B=1,NB
          AKE(B)   = 0.0
          ACCHL1(B)= 0.0
          ACCHL2(B)= 0.0
          ACCHL3(B)= 0.0
          AFI1(B)  = 0.0
          ANL1(B)  = 0.0
          APL1(B)  = 0.0
          AFI2(B)  = 0.0
          ANL2(B)  = 0.0
          APL2(B)  = 0.0
          AFI3(B)  = 0.0
          ANL3(B)  = 0.0
          APL3(B)  = 0.0
          ANPP(B)  = 0.0
          AGPP(B)  = 0.0
          ARESP(B) = 0.0
          ACFIX(B) = 0.0
10186   CONTINUE
        DO B =1,NSB
          AASRAT(B)= 0.0
          AKRDO(B) = 0.0
        END DO
        DO 10188 BB=1,NBB
          ACPIP(BB)   = 0.0
          ACPO4(BB)   = 0.0
          ASSFWS(BB)  = 0.0
          APCFWS(BB)  = 0.0
          APNFWS(BB)  = 0.0
          APPFWS(BB)  = 0.0
          APIPFWS(BB) = 0.0
          ABENDO(BB)  = 0.0
          ABENDOC(BB) = 0.0
          ABENNH4(BB) = 0.0
          ABENNO3(BB) = 0.0
          ABENPO4(BB) = 0.0
          ABENCOD(BB) = 0.0
          ABENCH4G(BB) = 0.0
          ABENCH4A(BB) = 0.0
          AFIB(BB)    = 0.0
          ANLB(BB)    = 0.0
          APLB(BB)    = 0.0
          ANPPB(BB)   = 0.0
          ABBM(BB)    = 0.0
          ABLITE(BB)  = 0.0
          DO N=1,NSPECIES         
            ASFEED(BB,N)  = 0.0
          END DO
          AJNSF(BB) = 0.0
          AJPSF(BB) = 0.0
          ASODSF(BB) = 0.0
          ASFGCIN(BB) = 0.0
          ASFCFEC(BB) = 0.0
          ASFCPSF(BB) = 0.0
          AFLXCSF(BB) = 0.0
          AFLXNSF(BB) = 0.0
          AFLXPSF(BB) = 0.0
          ARPOCSF(BB) = 0.0
          ARPONSF(BB) = 0.0
          ARPOPSF(BB) = 0.0
          ASSISF(BB) = 0.0
          ASSIPSF(BB) = 0.0
          DO JG=1,3
            ACPOC(BB,JG) = 0.0
            ACPON(BB,JG) = 0.0
            ACPOP(BB,JG) = 0.0
          END DO
10188   CONTINUE
        DO BB=1,NBB
            ALEAF(BB)  = 0.0
            ASTEM(BB)  = 0.0
            ATUBER(BB) = 0.0
            AEP(BB)    = 0.0
            AROOT(BB)  = 0.0
            AFISH(BB)  = 0.0
            AFIEP(BB)  = 0.0
            ANPPSAV(BB)= 0.0
            ANPPEP(BB) = 0.0
            AEPATN(BB) = 0.0
            AWATATN(BB)= 0.0
          ANLSAV(BB) = 0.0
          APLSAV(BB) = 0.0
          AFNSED(BB) = 0.0
          AFPSED(BB) = 0.0
          ANLEPI(BB) = 0.0
          APLEPI(BB) = 0.0
	  ASAVEFCT(BB) = 0.0
        END DO
        DO 10189 B=1,NB                                !MNOEL
          A_T(B)      = 0.0
          AP1(B)     = 0.0
          ABM1(B)     = 0.0
          APR1(B)     = 0.0
          AP2(B)      = 0.0
          ABM2(B)     = 0.0
          APR2(B)     = 0.0
          AP3(B)      = 0.0
          ABM3(B)     = 0.0
          APR3(B)     = 0.0
          AALGDOC(B)  = 0.0
          AALGPOC(B)  = 0.0
          ADENIT(B)   = 0.0
          AMNLDOC(B)  = 0.0
          AHDRPOC(B)  = 0.0
          AALGNH4(B)  = 0.0
          AALGNO3(B)  = 0.0
          AALGDON(B)  = 0.0
          AALGPON(B)  = 0.0
          ANT(B)      = 0.0
          ADENNO3(B)  = 0.0
          AMNLDON(B)  = 0.0
          AHDRPON(B)  = 0.0
          AALGPO4(B)  = 0.0
          AALGDOP(B)  = 0.0
          AALGPOP(B)  = 0.0
          AMNLDOP(B)  = 0.0
          AHDRPOP(B)  = 0.0
          ADO(B)      = 0.0
          ADORALG(B)  = 0.0
          ADOPR(B)    = 0.0
          ADCOD(B)    = 0.0
          ADDOC(B)    = 0.0
          ANITRIF(B)  = 0.0
10189   CONTINUE
        DO B=1,NBB
          DO N=1,NSPECIES
            ACHARV(B,N)   = 0.0
          END DO
        END DO
        DO B=1,NBB
            APLEAF(B)     = 0.0
            ABMLEAF(B)    = 0.0
            ASLSH(B)      = 0.0
            APEP(B)       = 0.0
            ABMEP(B)      = 0.0
            APREP(B)      = 0.0
         ABMTUBER(B)   = 0.0
          ADOCSAV(B)    = 0.0
          APOCSAV(B)    = 0.0
          ADOCEPI(B)    = 0.0
          APOCEPI(B)    = 0.0
          ASEDCSAV(B)   = 0.0
          ANH4SAVW(B)   = 0.0
          ANO3SAVW(B)   = 0.0
          ADONSAVW(B)   = 0.0
          APONSAVW(B)   = 0.0
          ANH4EPI(B)    = 0.0
          ANO3EPI(B)    = 0.0
          ADONEPI(B)    = 0.0
          APONEPI(B)    = 0.0
          ASEDNSAV(B)   = 0.0
          ASEDNH4SAV(B) = 0.0          
          APO4SAVW(B)   = 0.0
          ADOPSAVW(B)   = 0.0
          APOPSAVW(B)   = 0.0
          APO4EPI(B)    = 0.0
          ADOPEPI(B)    = 0.0
          APOPEPI(B)    = 0.0
          ASEDPSAV(B)   = 0.0
          ASEDPO4SAV(B) = 0.0
          ADOSAV(B)     = 0.0
          ADOEPI(B)     = 0.0
          ASEDDOSAV(B)  = 0.0
        END DO
        DO B=1,NBB
          ABMB(B)       = 0.0
          APB(B)        = 0.0
          APRB(B)       = 0.0
          ABADOC(B)     = 0.0
          ABAPOC(B)     = 0.0
          ABANH4(B)     = 0.0
          ABANO3(B)     = 0.0
          ABAPON(B)     = 0.0
          ABAPO4(B)     = 0.0
          ABAPOP(B)     = 0.0
          ABADO(B)      = 0.0
        END DO                      


***** Horizontal advection and diffusion multipliers


      DO 10190 F=1,NHQF

******* Positive flows

        IF (LEFTM1_BOUNDARY(F)) BL(ILB(F),QD(F)) = BL(IB(F),QD(F))
        IF (LEFT_FLOWB(F)) THEN
          BL(IB(F),QD(F))  = BL(JB(F),QD(F))
          BL(ILB(F),QD(F)) = BL(JB(F),QD(F))
        END IF
        IF (RIGHT_FLOWB(F)) BL(JB(F),QD(F)) = BL(IB(F),QD(F))
        SF1(F)    = MIN(BL(IB(F),QD(F)),BL(JB(F),QD(F)))
        SF2(F,1)  = BL(IB(F),QD(F))**2
        DEN1(F,1) = 0.25*(BL(ILB(F),QD(F))+2.*BL(IB(F),QD(F))
     .              +BL(JB(F),QD(F)))*(BL(ILB(F),QD(F))
     .              +BL(IB(F),QD(F)))
        DEN2(F,1) = -0.25*(BL(IB(F),QD(F))+BL(JB(F),QD(F)))
     .              *(BL(ILB(F),QD(F))+BL(IB(F),QD(F)))
        DEN3(F,1) = 0.25*(BL(IB(F),QD(F))+BL(JB(F),QD(F)))
     .              *(BL(ILB(F),QD(F))+2.0*BL(IB(F),QD(F))
     .              +BL(JB(F),QD(F)))
        T2(F,1)   = BL(JB(F),QD(F))/(BL(IB(F),QD(F))+BL(JB(F),QD(F)))
        T3(F)     = BL(IB(F),QD(F))/(BL(IB(F),QD(F))+BL(JB(F),QD(F)))
        TP1(F,1)  = 0.5*(BL(IB(F),QD(F))-BL(JB(F),QD(F)))*SF1(F)
        TP2(F,1)  = 0.5*(BL(ILB(F),QD(F))+2.0*BL(IB(F),QD(F))
     .              -BL(JB(F),QD(F)))*SF1(F)
        TP3(F,1)  = 0.5*(BL(ILB(F),QD(F))+3.0*BL(IB(F),QD(F)))*SF1(F)

******* Negative flows

        IF (LEFT_FLOWB(F)) BL(IB(F),QD(F)) = BL(JB(F),QD(F))
        IF (RIGHT_FLOWB(F)) THEN
          BL(JB(F),QD(F))  = BL(IB(F),QD(F))
          BL(JRB(F),QD(F)) = BL(IB(F),QD(F))
        END IF
        IF (RIGHTP1_BOUNDARY(F)) BL(JRB(F),QD(F)) = BL(JB(F),QD(F))
        SF1(F)    = MIN(BL(IB(F),QD(F)),BL(JB(F),QD(F)))
        SF2(F,2)  = BL(JB(F),QD(F))**2
        DEN1(F,2) = 0.25*(BL(IB(F),QD(F))+2.0*BL(JB(F),QD(F))
     .              +BL(JRB(F),QD(F)))*(BL(IB(F),QD(F))+BL(JB(F),QD(F)))
        DEN2(F,2) = -0.25*(BL(JB(F),QD(F))+BL(JRB(F),QD(F)))
     .              *(BL(IB(F),QD(F))+BL(JB(F),QD(F)))
        DEN3(F,2) = 0.25*(BL(IB(F),QD(F))+2.0*BL(JB(F),QD(F))
     .              +BL(JRB(F),QD(F)))*(BL(JB(F),QD(F))
     .              +BL(JRB(F),QD(F)))
        T1(F)     = BL(JB(F),QD(F))/(BL(IB(F),QD(F))+BL(JB(F),QD(F)))
        T2(F,2)   = BL(IB(F),QD(F))/(BL(IB(F),QD(F))+BL(JB(F),QD(F)))
        TP1(F,2)  = -0.5*(3.0*BL(JB(F),QD(F))+BL(JRB(F),QD(F)))*SF1(F)
        TP2(F,2)  = 0.5*(BL(IB(F),QD(F))-2.0*BL(JB(F),QD(F))
     .              -BL(JRB(F),QD(F)))*SF1(F)
        TP3(F,2)  = 0.5*(BL(IB(F),QD(F))-BL(JB(F),QD(F)))*SF1(F)
10190 CONTINUE

***** Advection terms

      IF (UPWIND) THEN
        DO 10200 F=1,NHQF
          TERM(F,1) = 0.0
          TERM(F,2) = 1.0
          TERM(F,3) = 0.0
10200   CONTINUE
      END IF

***** Vertical advection weighting factors

      DO 10215 SB=1,NSB
        DO 10210 F=1,NVF(SB)
          WAILB(F,SB) = BL(ILB(VFN(F,SB)),3)/BL(IB(VFN(F,SB)),3)
          WAIB(F,SB)  = BL(JB(VFN(F,SB)),3)/BL(IB(VFN(F,SB)),3)
10210   CONTINUE
        WAILB(1,SB) = 1.0
10215 CONTINUE

***** Change in concentrations

      DO 10225 JC=1,NCP
        DO 10224 B=0,NB
          DTC(B,JC) = 0.0
10224   CONTINUE
10225 CONTINUE
    
C
C     *** DO days
C
        DO 10226 J=1,NOINT
          DO 10227 B=1,NB
            DOVDAYS(B,J) = 0.0
10227     CONTINUE
10226   CONTINUE

***** Maximum number of Sources One through Three

      DO 10229 JC=1,NAC
        II=AC(JC)
        IF (S1LN(II).GT.S1LNMAX) THEN
          S1LNMAX = S1LN(II)
          JCS1MAX = II
        END IF
        IF (S2LN(II).GT.S2LNMAX) THEN
          S2LNMAX = S2LN(II)
          JCS2MAX = II
        END IF
        IF (S3LN(II).GT.S3LNMAX) THEN
          S3LNMAX = S3LN(II)
          JCS3MAX = II
        END IF
10229 CONTINUE

***** Horizontal diffusion

      DIFF(0) = 0.0
      IF (XY_DIFFUSION) THEN
        DO 10230 F=1,NHQF
          DIFF(F) = XYDF
10230   CONTINUE

      END IF


************************************************************************
**                   Parameters for Sediment Submodels                **
************************************************************************

      IF (SEDIMENT_CALC) CALL SED_READ

************************************************************************
**                              Outputs                               **
************************************************************************

***** Open output files

      IF (SNAPSHOTS)        OPEN (SNP,FILE=SNPFN)
      IF (DIAGNOSTICS)      OPEN (DIA,FILE=DIAFN)
      IF (KINETIC_FLUXES)   OPEN (KFL,FILE=KFLFN,
     .                            FORM='UNFORMATTED')           !MNOEL
      IF (PLOTS)            OPEN (PLT,FILE=PLTFN,
     .                            FORM='UNFORMATTED')
      IF (AVERAGE_PLOTS)    OPEN (APL,FILE=APLFN,
     .                            FORM='UNFORMATTED')
      IF (H_TRANS_FLUX .OR. V_TRANS_FLUX .OR. S_TRANS_FLUX) 
     .                      OPEN (TFL,FILE=TFLFN,FORM='UNFORMATTED')
      IF (OXYGEN_PLOTS)     OPEN (OPL,FILE=OPLFN,
     .                            FORM='UNFORMATTED')
      IF (BENTHIC_FLUXES.AND.BENTHIC_OUTPUT) 
     .                      OPEN (BFO,FILE=BFOFN)
      IF (SFEEDER)          OPEN (SUD,FILE=SUDFN,FORM='UNFORMATTED')

***** Snapshots

      IF (SNAPSHOTS) THEN
        WRITE (SNP,2000) 'CE-QUAL-IC - Version 5.0 w LRDOM, Internal P'
        WRITE (SNP,2010)  TITLE
        WRITE (SNP,2020)  MAPFN,  GEOFN,  ICIFN,  AGRFN, SUSFN
        WRITE (SNP,2027)  STLFN, MRLFN, KEIFN, SAVFN
        WRITE (SNP,2021) (HYDFN(JF),JF=1,NHYDF)
        WRITE (SNP,2022) (METFN(JF),JF=1,NTVDF)
        WRITE (SNP,2023) (S1FN(JF),JF=1,NTVDF)
        WRITE (SNP,2024) (S2FN(JF),JF=1,NTVDF)
        WRITE (SNP,2029) (S3FN(JF),JF=1,NTVDF)
        WRITE (SNP,2031) (ATMFN(JF),JF=1,NTVDF)
        WRITE (SNP,2028) (SVIFN(JF),JF=1,NTVDF)
        WRITE (SNP,2025) (CBCFN(JF),JF=1,NTVDF)         
        WRITE (SNP,2026) (BFIFN(JF),JF=1,NTVDF)
        WRITE (SNP,2030)  ICOFN,  SNPFN,  PLTFN,  APLFN,
     .                    DIAFN,  TFLFN,  KFLFN,  OPLFN,
     .                    ALOFN,  BFOFN,  SVOFN,  SUDFN
        WRITE (SNP,2040)  NB,     NSB,    NQF,    NHQF,   NL
        WRITE (SNP,2050)  TMSTRT, TMEND
        WRITE (SNP,2060) (DLTD(J),J=1,NDLT)
        WRITE (SNP,2070) (INT(DLTVAL(J)),J=1,NDLT)
        WRITE (SNP,2071)  AUTOC
        WRITE (SNP,2072) (INT(DLTMAX(J)),J=1,NDLT)
        WRITE (SNP,2073) (DLTFTN(J),J=1,NDLT)
        WRITE (SNP,2080)  S1C,    S2C,    S3C,  BFC,
     .                    ICIC,   ATMC,   STLC, SEDTR
        WRITE (SNP,2090)  ICOC,   SNPC,   PLTC,   QPLTC, SPLTC,  APLTC,
     .                    DIAC,   HTFLC,  VTFLC,  STFLC, KFLC,   OPLC
        WRITE (SNP,2100) (SNPD(K),K=1,NSNP)
        WRITE (SNP,2110) (PLTD(J),J=1,NPLT)
        WRITE (SNP,2115) (APLTD(J),J=1,NAPL)
        WRITE (SNP,2116) (TFLD(J),J=1,NTFL)
        WRITE (SNP,2118) (OPLD(J),J=1,NOPL)
        WRITE (SNP,2130) (SNPF(K),K=1,NSNP)
        WRITE (SNP,2135) (PLTF(J),J=1,NPLT)
        WRITE (SNP,2136) (APLF(J),J=1,NAPL)
        WRITE (SNP,2137) (TFLF(J),J=1,NTFL)
        WRITE (SNP,2138) (OPLF(J),J=1,NOPL)
        WRITE (SNP,2141)  VBC
        WRITE (SNP,2150)  HYDC, INT(AHMDLT), SLC, CONSC, TH, MINSTEP,
     .                    FILGTH
        WRITE (SNP,2152)  SEDC
        WRITE (SNP,2154)  SAVMC
        WRITE (SNP,2160)  BNDTC
        WRITE (SNP,2165)  XYDF,   ZDFMUL
        WRITE (SNP,2170)  FLC,    XYDFC,  ZDFC
        WRITE (SNP,2180) (CNAME(JC),ACC(JC),CIC(JC),JC=1,NCP)
        WRITE (SNP,2190)  REDS1N, REDS2N, REDS3N, REDCBN, 
     .                    REDS1P, REDS2P, REDS3P, REDCBP, 
     .                    REDS1C, REDS2C, REDS3C, REDCBC
        WRITE (SNP,2200)  KHONT,  KHNNT,  KHODOC, KHOCOD, KHNDN
        WRITE (SNP,2210)  AOCR,   AONT,   ANDC
        WRITE (SNP,2260)  KTNT1,  KTNT2,  TMNT
        WRITE (SNP,2280)  TRCOD,  KTCOD,  TRMNL,
     .                    KTMNL,  TRHDR,  KTHDR,
     .                    TRHDR,  KTHDR,  
     .                    TRMNL,  KTMNL, 
     .                    TRHDR,  KTHDR,  TRHDR,
     .                    KTHDR,  TRMNL,  KTMNL,
     .                    TRHDR,  KTHDR, 
     .                    TRHDR,  KTHDR
        WRITE (SNP,2317)  KADPO4, JBSPO4, JESPO4
        IF (EREAR .EQ. '    WIND') THEN
          WRITE (SNP,2332)  AREAR,  BREAR, CREAR
        ELSE
          WRITE (SNP,2333) DREAR
        END IF
        WRITE (SNP,2310)  KE(1), KEISS(1), KEVSS(1), KECHL,
     .                    KESAL, VSStoPOC
      END IF

***** Benthic flux parameters

      IF (BENTHIC_FLUXES.AND.BENTHIC_OUTPUT) THEN
        WRITE(BFO,2501) KSDOC, KSNH4, KSNO3, KSPO4, KSO
        WRITE(BFO,2503) TRSDOC, TRSNH4, TRSNO3, TRSPO4, TRSO
        WRITE(BFO,2502) MTCNO3, SEDNO3, KHSO
      END IF

***** Diagnostics

      IF (DIAGNOSTICS) THEN                                !MNOEL 2-5-93
        WRITE (DIA,2010) TITLE
        IF (UNI_ICON_IN) THEN
          WRITE (DIA,2012)
          WRITE (DIA,2011) ICIC
        END IF
        IF (BIN_ICON_IN) THEN
          WRITE (DIA,2012)
          WRITE (DIA,2011) ICIC
          WRITE (DIA,2013)
          WRITE (DIA,2010) OLDTITLE
        END IF
      END IF

*****  Change double precision volumes to single so they can be written out
        DO B=0,NB
           V1SINGLE(B) = V1(B)
        END DO

***** Plots

      IF (PLOTS) WRITE (PLT) TITLE,NAC,AC,NB,NSPECIES,
     .  QUALITY_DIAG,SEDIMENT_DIAG,SAV_PLOTS,SEDTR_CALC,
     .  ANC1,ANC2,ANC3,APC1,APC2,APC3,
     .  KADPO4,M2,PIE2S,PIE2PO4(1),                                     !CFC
     .  PIENH4,ADWCEPI,NDOMSP,(ALAC(I),I=1,NDOMSP)
      IF (PLOTS) WRITE (PLT) NSB,NBED,NSDCLS                            !CFC

***** Average plots

      IF (AVERAGE_PLOTS) THEN
        WRITE (APL) TITLE,NAC,AC,NB,NSPECIES,QUALITY_DIAG,
     .  SEDIMENT_DIAG,SAV_PLOTS,
     .  ANC1,ANC2,ANC3,APC1,APC2,APC3,
     .  KADPO4,ADWCEPI,NDOMSP,(ALAC(I),I=1,NDOMSP)
        WRITE (APL) NSB,(V1SINGLE(B),B=0,NB),
     .             (SFA(SB),SB=1,NSB)
        WRITE (APL) ((SCOVER(B,N),B=1,NSB),N=1,NSPECIES)

      END IF

***** Constituent fluxes

      IF (H_TRANS_FLUX .OR. V_TRANS_FLUX .OR. S_TRANS_FLUX) THEN
        WRITE (TFL) TITLE, NAC, AC, NHQF, NQF, H_TRANS_FLUX, 
     .    V_TRANS_FLUX, S_TRANS_FLUX
        WRITE (TFL) ANC1,ANC2,ANC3,APC1,APC2,APC3
      END IF

***** Kinetics fluxes

      IF (KINETIC_FLUXES) WRITE (KFL) TITLE, NB, NSB, NSPECIES,
     .  (SBN(B),B=1,NSB), (BBN(B),B=1,NSB),
     .  (V1SINGLE(B),B=0,NB),(SFA(B),B=1,NSB), 
     .  SAV_CALC, BALGAE_CALC


***** Oxygen plots

! pwo IF (OXYGEN_PLOTS) THEN
!       WRITE (OPL) TITLE,NB,NOINT,
!    .    (OINT(B),B=1,NOINT),(V1SINGLE(B),B=0,NB)
! pwo ENDIF

***** Output FORMAT statements

 2000 FORMAT(1X,A24/
     .       '+',10('_')//)
 2010 FORMAT(1X,A72)
 2012 FORMAT(/1X,79('*')/)
 2011 FORMAT(3X,'Type of initial conditions file ',T35,' is ',A8)
 2013 FORMAT(//' Title lines read from binary initial conditions file'/)
 2020 FORMAT(//
     .       1X,'Input filenames'/
     .       '+',15('_')//
     .       3X,'Map',T28,'= ',A72/
     .       3X,'Geometry',T28,'= ',A72/
     .       3X,'Initial conditions in',T28,'= ',A72/
     .       3X,'Algal parameters',T28,'= ',A72/
     .       3X,'Suspension Feeders',T28,'= ',A72)
 2021 FORMAT(3X,'Hydrodynamic',T28,'= ',A72:/(T30,A72))
 2022 FORMAT(3X,'Meteorologic',T28,'= ',A72:/(T30,A72))
 2023 FORMAT(3X,'Source One',T28,'= ',A72:/(T30,A72))
 2024 FORMAT(3X,'Source Two',T28,'= ',A72:/(T30,A72))
 2025 FORMAT(3X,'Boundary concentrations',T28,'= ',A72:/(T30,A72))
 2026 FORMAT(3X,'Benthic fluxes',T28,'= ',A72:/(T30,A72))
 2027 FORMAT(3X,'Settling',T28,'= ',A72/
     .       3X,'Mineralization',T28,'= ',A72/
     .       3X,'Light Extinction',T28,'= ',A72/
     .       3X,'SAV Parameters',T28,'= ',A72)
 2028 FORMAT(3X,'Aquatic vegetation',T28,'= ',A72:/(T30,A72))
 2032 FORMAT(3X,'KD Array',T28,'= ',A72/
     .       3X,'KD Parameters',T28,'= ',A72)
 2029 FORMAT(3X,'Source Three',T28,'= ',A72:/(T30,A72))
 2031 FORMAT(3X,'Atmospheric Loads',T28,'= ',A72:/(T30,A72))
 2030 FORMAT(//
     .       '1','Output filenames'/
     .       '+',16('_')//
     .       3X,'Initial conditions out',T28,'= ',A72/
     .       3X,'Snapshot',T28,'= ',A72/
     .       3X,'Plot',T28,'= ',A72/
     .       3X,'Average plot',T28,'= ',A72/
     .       3X,'Diagnostics',T28,'= ',A72/
     .       3X,'Transport fluxes',T28,'= ',A72/
     .       3X,'Kinetic fluxes',T28,'= ',A72/
     .       3X,'Oxygen plot',T28,'= ',A72/
     .       3X,'Algal parameters',T28,'= ',A72/
     .       3X,'Sediment model',T28,'= ',A72/
     .       3X,'Aquatic vegetation',T28,'= ',A72/     
     .       3X,'Suspension feeders',T28,'= ',A72)
 2040 FORMAT(//
     .       1X,'Geometry'/
     .       '+',8('_')//
     .       3X,'Total boxes',T21,'= ',I7/
     .       3X,'Surface boxes',T21,'= ',I7/
     .       3X,'Total faces',T21,'= ',I7/
     .       3X,'Horizontal faces',T21,'= ',I7/
     .       3X,'Layers',T21,'= ',I7)
 2050 FORMAT(//
     .       1X,'Time control'/
     .       '+',12('_')//
     .       3X,'Starting time = ',F8.2,' Julian day'/
     .       3X,'Ending time   = ',F8.2,' Julian day')
 2060 FORMAT(//
     .       1X,'Timestep control'/
     .       '+',16('_')//
     .       3X,'Fixed'/
     .       (5X,'Julian Day ',T39,'= ',8F8.2):/)
 2070 FORMAT(5X,'Timestep (sec)',T39,'= ',8I8/
     .       (T49,8I8))
 2071 FORMAT(3X,'Variable'/
     .       5X,'Autostepping',T39,'= ',5X,A3)
 2072 FORMAT(5X,'Maximum allowable timestep (sec)',T39,'= ',8I8/
     .       (T41,8I8))
 2073 FORMAT(5X,'Fraction of calculated timestep',T39,'= ',8F8.2/
     .       (T41,8F8.2))
 2080 FORMAT(//
     .       1X,'Input controls'/'+',14('_')//
     .       3X,'Source One loadings',T33,'= ',A8/
     .       3X,'Source Two loadings',T33,'= ',A8/
     .       3X,'Source Three loadings',T33,'= ',A8/
     .       3X,'Benthic fluxes',T33,'= ',A8/
     .       3X,'Initial conditions in',T33,'= ',A8/
     .       3X,'Atmospheric loadings',T33,'= ',A8/
     .       3X,'Settling',T33,'= ',A8/
     .       3X,'Sediment Transport',T33,'= ',A8)
 2090 FORMAT(//
     .       '1','Output controls'/
     .       '+',15('_')//
     .       3X,'Initial conditions out',T32,'= ',A3/
     .       3X,'Snapshot',T32,'= ',A3/
     .       3X,'Plot',T32,'= ',A3/
     .       3X,'Water quality diagnostics',T32,'= ',A3/
     .       3X,'Sediment diagnostics',T32,'= ',A3/
     .       3X,'Average plot',T32,'= ',A3/
     .       3X,'Diagnostics',T32,'= ',A3/
     .       3X,'Horizontal transport fluxes',T32,'= ',A3/
     .       3X,'Vertical transport fluxes',T32,'= ',A3/
     .       3X,'Settling transport fluxes',T32,'= ',A3/
     .       3X,'Kinetic fluxes',T32,'= ',A3/
     .       3X,'Oxygen plots',T32,'= ',A3/)
 2100 FORMAT(//
     .       3X,'Output dates (Julian day)'/
     .       '+',2X,12('_')//
     .       5X,'Snapshots',T24,'= ',9F8.2,(:/T26,9F8.2))
 2110 FORMAT(5X,'Plots',T24,'= ',9F8.2,(:/T26,9F8.2))
 2115 FORMAT(5X,'Average plots',T24,'= ',9F8.2,(:/T26,9F8.2))
 2116 FORMAT(5X,'Transport fluxes',T24,'= ',9F8.2,(:/T26,9F8.2))
 2118 FORMAT(5X,'Oxygen plots',T24,'= ',9F8.2,(:/T26,9F8.2))
 2130 FORMAT(/
     .       3X,'Output frequencies (days)'/
     .       '+',2X,18('_')//
     .       5X,'Snapshots',T24,'= ',9F8.2,(:/T26,9F8.2))
 2135 FORMAT(5X,'Plots',T24,'= ',9F8.2,(:/T26,9F8.2))
 2136 FORMAT(5X,'Average plots',T24,'= ',9F8.2,(:/T26,9F8.2))
 2137 FORMAT(5X,'Transport fluxes',T24,'= ',9F8.2,(:/T26,9F8.2))
 2138 FORMAT(5X,'Oxygen plots',T24,'= ',9F8.2,(:/T26,9F8.2))
 2141 FORMAT(//
     .       1X,'Balance calculations'/
     .       '+',20('_')//
     .       3X,'Volume balance',T21,'= ',A3)
 2150 FORMAT(//
     .       1X,'Hydrodynamics'/
     .       '+',13('_')//
     .       3X,'Origin',T40,'= ',A8/
     .       3X,'Interval between updates',T40,'= ',I8,' sec'/
     .       3X,'Horizontal transport',T40,'= ',A8/
     .       3X,'Conservation type',T40,'= ',A8/
     .       3X,'Theta for vertical solution',T40,'= ',F8.2/
     .       3X,'Minimum time step',T40,'= ',F8.2,' sec'/
     .       3X,'Days in Time-variable input files',T40,'= ',F8.2//)
 2152 FORMAT('1','Sediment calculations'/
     .       '+',21('_')//
     .       3X,'Model = ',A3)
 2154 FORMAT('1','SAV calculations'/
     .       '+',21('_')//
     .       3X,'Model = ',A3)
 2160 FORMAT(//
     .       1X,'Boundary interpolation'/
     .       '+',22('_')//
     .       3X,'Temporal',T13,'=',A8)
 2165 FORMAT(//
     .       1X,'Diffusion'/
     .       '+',9('_')//
     .       3X,'Horizontal',T24,'=',F6.1/
     .       3X,'Vertical multiplier',T24,'=',F6.1)
 2170 FORMAT(//
     .       1X,'Dead sea case'/
     .       '+',13('_')//
     .       3X,'Flow',T25,'= ',A3/
     .       3X,'Horizontal diffusion',T25,'= ',A3/
     .       3X,'Vertical diffusion',T25,'= ',A3)
 2180 FORMAT(//
     .       1X,'Constituent controls'/
     .       '+',20('_')//
     .       5X,'Constituent',T28,'Computation',T43,'Initial concen',
     .         'tration'/
     .       '+',4X,11('_'),T28,11('_'),T43,7('_'),1X,13('_')/
     .       T49,'(g/m**3)'//
     .       (3X,A24,T32,A3,T47,F8.3))
c    .       (3X,A24,T32,A3,T47,F8.3)//)
 2190 FORMAT(//
     .       '1',2X,'Nutrient reductions'/
     .       '+',2X,19('_')//
     .       5X,'Nitrogen'/
     .       7X,'Fall line',T24,'=',F5.2/
     .       7X,'Below fall line',T24,'=',F5.2/
     .       7X,'Atmospheric',T24,'=',F5.2/
     .       7X,'Boundaries',T24,'=',F5.2/
     .       5X,'Phosphorus'/
     .       7X,'Fall line',T24,'=',F5.2/
     .       7X,'Below fall line',T24,'=',F5.2/
     .       7X,'Atmospheric',T24,'=',F5.2/
     .       7X,'Boundaries',T24,'=',F5.2/
     .       5X,'Carbon'/
     .       7X,'Fall line',T24,'=',F5.2/
     .       7X,'Below fall line',T24,'=',F5.2/
     .       7X,'Atmospheric',T24,'=',F5.2/
     .       7X,'Boundaries',T24,'=',F5.2)
 2200 FORMAT(//
     .       3X,'Half-saturation coefficients'/
     .       '+',2X,28('_')//
     .       T25,'Oxygen',T38,'Nitrogen',T51,'Phosphorus',T67,
     .         'Carbon',T80,'Respiration'/
     .       '+',T25,6('_'),T38,8('_'),T51,10('_'),T67,6('_'),T80,
     .         6('_'),T93,11('_')/
     .       T23,'(g DO/m**3)',T37,'(g N/m**3)',T51,'(g P/m**3)',T65,
     .         '(g C/m**3)',T78,'(g Si/m**3)',T93,'(g DO/m**3)'//
     .       5X,'Nitrification',T24,F6.3,T38,F6.3/
     .       5X,'COD oxidation',T24,F6.3/
     .       5X,'DOC oxidation',T24,F6.3/
     .       5X,'Denitrification',T24,F6.3//)
 2210 FORMAT(3X,'Nutrient to carbon ratios'/
     .       '+',2X,25('_')//T26,'Oxygen',T37,'Nitrogen',T50,
     .       'Phosphorus'/
     .       '+',T26,6('_'),T37,8('_'),T50,10('_'),T66,6('_')//
     .       5X,'Respiration',T25,F6.3/
     .       5X,'Nitrification',T25,F6.3/
     .       5X,'N/C ratio for anoxic metabolism',T25,F6.3//)
 2260 FORMAT(3X,'Temperature/algal effects'/
     .       '+',2X,25('_')//
     .       T28,'Suboptimal',T50,'Superoptimal',T77,'Maximum'/
     .       '+',T28,10('_'),T50,12('_'),T77,7('_')/
     .       T27,'(/degrees C)',T50,'(/degrees C)',T75,'(degrees C)'//
     .       5X,'Nitrification',T29,F6.3,T52,F6.3,T77,F6.1/)
 2270 FORMAT(T26,'Reference rate',T46,'Reference temperature',T72,
     .         'Temperature effect',T98,'Algal effect'/
     .       '+',T26,14('_'),T46,21('_'),T72,18('_'),T98,12('_')/
     .       T30,'(/day)',T51,'(degrees C)',T75,'(/degrees C)',T97,
     .         '(m**3/day/g C)'//
     .       5X,'Base metabolism'/
     .       7X,'Cyanobacteria',T52,F6.1,T77,F6.3/
     .       7X,'Diatoms',T52,F6.1,T77,F6.3/
     .       7X,'Greens',T52,F6.1,T77,F6.3)
 2280 FORMAT(5X,'COD oxidation',T52,F6.1,T77,F6.3/
     .       5X,'DOC oxidation',T52,F6.1,T77,F6.3/
     .       5X,'LPOC hydrolysis',T52,F6.1,T77,F6.3/
     .       5X,'RPOC hydrolysis',T52,F6.1,T77,F6.3/
     .       5X,'DON oxidation',T52,F6.1,T77,F6.3/
     .       5X,'LPON hydrolysis',T52,F6.1,T77,F6.3/
     .       5X,'RPON hydrolysis',T52,F6.1,T77,F6.3/
     .       5X,'DOP oxidation',T52,F6.1,T77,F6.3/
     .       5X,'LPOP hydrolysis',T52,F6.1,T77,F6.3/
     .       5X,'RPOP hydrolysis',T52,F6.1,T77,F6.3//)
 2317 FORMAT(3X,'Sorption coefficients'/
     .       '+',2X,21('_')//
     .       5X,'Phosphorus',T17,'=',F6.2,' m**3/gm'/
     .       3X,'Direct PO4 settling'/
     .       '+',2X,21('_')//
     .       5X,'Begin day',T17,'=',F7.1/
     .       5X,'End day',T17,'=',F7.1//)
 2332 FORMAT(3X,'Reaeration (m/d) = ',F8.3,
     .       ' * Rnu * (',F6.3,' * WMS) **',F6.3/)   
 2333 FORMAT(3X,'Reaeration (m/d) = ',F8.3,' * sqrt(V/H)'/)       
 2310 FORMAT(3X,'Extinction coefficients'/
     .       '+',2X,26('_')//
     .       5X,'Background',T41,'=',F6.3,' 1/m'/
     .       5X,'Inorganic Solids',T41,'=',F6.3,' m**2/gm'/
     .       5X,'Volatile Solids',T41,'=',F6.3,' m**2/gm'/
     .       5X,'Chlorophyll',T41,'=',F6.3,' m**2/gm'/
     .       5X,'Salinity',T41,'=',f6.3,' 1/ppt'/
     .       5X,'VSStoPOC',T41,'=',f6.3,' g solids/g C'//)
 2501 FORMAT(' Temperature effects'//' DOC = ',F8.4,' per Degree C'/
     .       ' NH4 = ',F8.4,' per Degree C'/
     .       ' NO3 = ',F8.4,' per Degree C'/
     .       ' PO4 = ',F8.4,' per Degree C'/
     .       ' SOD = ',F8.4,' per Degree C')
 2502 FORMAT(//' Other parameters'//
     .       ' MTCNO3   = ',F8.4,' m/day'/
     .       ' SEDNO3   = ',F8.4,' gm/m3'/
     .       ' KHSO     = ',F8.4,' gm/m3')
 2503 FORMAT (//' Reference Temperatures'//' DOC = ',F8.4,' Degrees C'/
     .        ' NH4 = ',F8.4,' Degrees C'/
     .        ' NO3 = ',F8.4,' Degrees C'/
     .        ' PO4 = ',F8.4,' Degrees C'/
     .        ' SOD = ',F8.4,' Degrees C')


      NXAPL = APLTD(APLDP)
    
      INFLOW=0
      DO 10096 F=1,NHQF
        IF(RIGHT_FLOWB(F) .OR. LEFT_FLOWB(F)) THEN
          INFLOW=INFLOW+1
          IFLOWP(INFLOW)=F
        ENDIF
10096 CONTINUE

      RETURN
      END SUBROUTINE INPUTS


************************************************************************
**                  S U B R O U T I N E   H Y D R O                   **
************************************************************************

      SUBROUTINE HYDRO ()
        USE WQM; USE FILE_INFO
        IMPLICIT NONE
        SAVE
        INTEGER   F, SB, L, JC, I, J
        LOGICAL   END_OF_FILE, oxygen_calc
        REAL(4)   NXDAY, TDUM, SEDNXDAY
        REAL(8)   MASS(0:NBP,NCP)
c
c  SK
c  for sediment transport
c
        real(4)   ddumdy,bdumbx
        integer   itmdum, iyrdum,idydum,ihrdum
************************************************************************
**                              Inputs                                **
************************************************************************


******* ASCII time-varying hydrodynamic data

        IF (ASCII_HYDRO) THEN                                              !MNOEL 1-25-93
          READ (HYD,1000) (Q(F),DIFF(F),F=1,NQF)
          READ (HYD,1005,END=10075) NXDAY
c
c  SK
c
          if(sedtr_calc) then
            do b=1,nsb
              READ (141,*) ddumdy,bdumbx,USTARC(B)
            end do
c            call erate_calc
            READ(141,*,end=10075) sednxday
            IF (SEDNXDAY.NE.NXDAY) THEN
              write(*,*) '1 SEDNXDAY.NE.NXDAY',SEDNXDAY,NXDAY
            END IF
          endif
          GO TO 10076
10075     HYDPTR = HYDPTR+1
          IF (DIAGNOSTICS) WRITE (DIA,*)
     .        'Opening hydrodynamic file ',HYDPTR,' at day ',JDAY
          CLOSE (HYD)
          OPEN  (HYD,FILE=HYDFN(HYDPTR),STATUS='OLD')
          NEW_HYDRO_FILE = .TRUE.       ! TKG 8-2001: Flag new hydro file
          READ  (HYD,1010)
          READ  (HYD,1005) NXDAY
c
c  SK
c
          if(sedtr_calc) then
            CLOSE(141)
            OPEN  (141,FILE=USTFN(HYDPTR),STATUS='OLD')
            READ  (141,1010)
            READ  (141,*) SEDNXDAY
            IF (SEDNXDAY.NE.NXDAY) THEN
              write(*,*) '2 SEDNXDAY.NE.NXDAY',SEDNXDAY,NXDAY
            END IF
          endif
10076     BACKSPACE (HYD)

          NXDAY = (HYDPTR-1)*365.0+NXDAY
          NXHYD = NINT(NXDAY*86400.0)

c
c  SK
c  for sediment transport
c
          if(sedtr_calc) then
            backspace(141)
          endif
******* Binary time-varying hydrodynamic data

        ELSE
        
10000     IF (NWQMR.GE.NHMR) THEN

*********** Hydrodynamic column volumes, flows, and vertical diffusions
                                                                            ! READS CH3D
            READ (HYD,END=10010)                                            ! TIME
c
c  SK
c  for sediment transport
c
c           if(sedtr_calc) then
c             READ(141)
c             READ(142)
c           endif
c
c
c
            GO TO 10020                                                     ! FIELD
10010       CONTINUE
            END_OF_FILE = .TRUE.
10020       IF (END_OF_FILE) THEN

************* Open next hydrodynamic file

              HYDPTR = HYDPTR+1
              IF (DIAGNOSTICS) WRITE (DIA,*) 
     .          'Opening hydrodynamic file ',HYDPTR,' at day ',JDAY
              CLOSE (HYD)
              OPEN  (HYD,FILE=HYDFN(HYDPTR),FORM='UNFORMATTED',
     .               STATUS='OLD')
              NEW_HYDRO_FILE = .TRUE.       ! TKG 8-2001: Flag new hydro file
c
c  SK
c  for sediment transport
c
              if(sedtr_calc) then
                close(141)
                OPEN  (141,FILE=USTFN(HYDPTR),FORM='UNFORMATTED',
     .               STATUS='OLD')
              endif
c
c
c
              IF (DEPTH_AVG_HYDRO) THEN
              
                READ  (HYD)  SFA
                READ  (HYD) (A(F),F=1,NHQF)
                READ  (HYD) (BL(SB,1),SB=1,NSB)
                READ  (HYD) (BL(SB,2),SB=1,NSB)
                READ  (HYD)  HMSBV

              ELSE

                 IF(SIGMA_HYDRO)THEN                             !JLM FOR LOWER ST. JOHNS
                   READ (HYD) (SFA(SB),SB=1,NSB)
                   READ (HYD) (BL(SB,1),SB=1,NSB)
                   READ (HYD) (BL(SB,2),SB=1,NSB)
                   READ (HYD) (HQCFA(F),F=1,NSQF)
                   READ (HYD) (HMCV(SB),SB=1,NSB)
cjlm changed for st. johns for now, have backwards
c          READ (HYD) (DLZF(L),L=1,NL)
CNOEL      READ (HYD) (DLZF(L),L=1,NL)
                   READ (HYD) (DLZF(L),L=NL,1,-1)

C CHANGES BELOW WERE NOT IN MY JULY 05 IMPLEMENTATION OF ST JOHNS CODE. 
C LOOKS LIKE I HAVE TO DO IT THOUGH.  1/23/06
                 ELSE
                   READ  (HYD) (SFA(SB),SB=1,NSB)
                   READ  (HYD) (BL(SB,1),SB=1,NSB)
                   READ  (HYD) (BL(SB,2),SB=1,NSB)
                   READ  (HYD) (A(F),F=1,NHQF)
                   READ  (HYD) (HMBV(SB),SB=1,NSB)
                   READ  (HYD) (HMSBV(SB),SB=1,NSB)
                 END IF
              END IF
              
              NWQMR = 0
              NHMR  = 0

************* Reinitialize HM and WQM volumes

                IF(SIGMA_HYDRO)THEN                             !JLM FOR LOWER ST. JOHNS
                   DO SB=1,NSB
                     DO F=1,NVF(SB)
                       V2(IB(VFN(F,SB))) = HMCV(SB)*DLZF(F)
                       V1(IB(VFN(F,SB)))  = HMCV(SB)*DLZF(F)
                     END DO
                       V2(SB) = HMCV(SB)*DLZF(NL)
                       V1(SB)  = HMCV(SB)*DLZF(NL)
                   END DO
                ELSE
                   DO 10040 SB=1,NSB
                     DO 10030 F=1,NVF(SB)
                        V2(IB(VFN(F,SB))) = HMBV(SB)
10030                CONTINUE
                        V2(SB) = HMSBV(SB)
10040             CONTINUE
                END IF

              IF (CONSERVE_MASS) THEN
                DO 10047 B=1,NB
                  DO 10045 JC=1,NAC
                    MASS(B,AC(JC)) = C1(B,AC(JC))*V1(B)
10045             CONTINUE
                  V1(B)  = V2(B)
                  V1S(B) = V1(B)
                  DO 10046 JC=1,NAC
                    C1(B,AC(JC)) = MASS(B,AC(JC))/V1(B)
                    C2(B,AC(JC)) = MAX(C1(B,AC(JC)),0.0)
10046             CONTINUE
10047           CONTINUE
              ELSE
                DO 10048 B=1,NB
                  V1(B) = V2(B)
10048           CONTINUE
              END IF

              END_OF_FILE = .FALSE.
              
            ELSE

              IF (DEPTH_AVG_HYDRO) THEN

                READ (HYD)  HMSBV
                READ (HYD) (Q(F),F=1,NQF)
                READ (HYD) (A(F),F=1,NSQF)

              ELSE
              
                 IF(SIGMA_HYDRO)THEN                             !JLM FOR LOWER ST. JOHNS
c sigma
                   READ (HYD) (DIFF(F),F=NHQF+1,NQF)
                   READ (HYD) (HMCV(SB),SB=1,NSB)
                   READ (HYD) (Q(F),F=1,NHQF)
                   READ (HYD) (Q(F),F=NHQF+1,NQF)
                   READ (HYD) (RNMEVP(SB),SB=1,NSB) 
                 ELSE
c zgrid
                   READ (HYD) (A(F),F=1,NSQF)
                   READ (HYD) (DIFF(F),F=NHQF+1,NQF)
                   READ (HYD) (HMSBV(SB),SB=1,NSB)
                   READ (HYD) (Q(F),F=1,NHQF)
                   READ (HYD) (Q(F),F=NHQF+1,NQF)
                   READ (HYD) (QLIT(B),B=1,NB)
                   do f=nhqf+1,nqf
                     diff(f) = amax1(diff(f),2.2e-5)
                   end do
                 END IF
              END IF
 
*******       SK - FOR SEDIMENT TRANSPORT
 
              IF (SEDTR_CALC) THEN
                ! read friction velocity, ustar, in cm/s and sher, dudz, in s
                READ(141) itmdum, iyrdum,idydum,ihrdum
                READ(141) (USTARC(B),B=1,NSB)
              ENDIF
                 
              NHMR = NHMR+1
            END IF
            GO TO 10000
          END IF
          NWQMR = NWQMR+1
          NXHYD = NXHYD+INT(AHMDLT)
c         print *, "from hydro:  nxhyd = ",nxhyd

        END IF

************************************************************************
**                           Calculations                             **
************************************************************************

********* Update HM surface volumes

        IF (.NOT. ASCII_HYDRO) THEN
           IF(SIGMA_HYDRO)THEN                                          !JLM FOR LOWER ST. JOHNS
c sigma
              DO 10088 SB=1,NSB
                 DO 10086 F=1,NVF(SB)
                    HMV(IB(VFN(F,SB))) = HMCV(SB)*DLZF(F)
10086            CONTINUE
                 HMV(SB) = HMCV(SB)*DLZF(NL)
10088         CONTINUE
           ELSE
c zgrid
             DO 10082 SB=1,NSB
               HMV(SB) = HMSBV(SB)
10082        CONTINUE
           END IF
        END IF

******* Dead sea case

        IF (.NOT.FLOW) THEN
          DO 10100 F=1,NQF
            Q(F) = 0.0
10100     CONTINUE
        END IF
        IF (.NOT.XY_DIFFUSION) THEN
          DO 10110 F=1,NHQF
            DIFF(F) = 0.
10110     CONTINUE
        END IF
        IF (.NOT.Z_DIFFUSION) THEN
          DO 10120 F=NHQF+1,NQF
            DIFF(F) = 0.
10120     CONTINUE
        END IF

******* Determine flow direction

        DO 10130 F=1,NQF
          IF (Q(F).GE.0.0) THEN
            POSITIVE_FLOW(F) = .TRUE.
          ELSE
            POSITIVE_FLOW(F) = .FALSE.
          END IF
10130   CONTINUE

******* Adjust vertical diffusion

        IF (BINARY_HYDRO) THEN
          DO 10140 F=NHQF+1,NQF
            DIFF(F) = ZDFMUL*DIFF(F)
10140     CONTINUE
        END IF

******* ASCII input FORMAT statements

 1000   FORMAT(21X,E10.3,5X,E10.3)
 1005   FORMAT(F8.0)
 1010   FORMAT(///)
 1020   FORMAT(13X,F13.0)
 1030   FORMAT(/)
       END SUBROUTINE HYDRO


************************************************************************
**                  S U B R O U T I N E   T V D S                     **
************************************************************************

      SUBROUTINE TVDS (NXTVD)
        USE WQM; USE FILE_INFO
        SAVE
        REAL      S2LNX, KTNX,  NXTVD
        DIMENSION S1LNX(NS1P,NCP), S2LNX(NS2P,NCP), S3LNX(NS3P,NCP),
     .            BFLUXNX(NSBP,NCP)

******* Meteorologic data

        NXTVD = TMEND
10000   IF (JDAY.GE.NXMET) THEN
          KT = KTNX
          FD = FDNX

C CONVERT LANGLEYS TO EINSTEINS/M**2
C Commented conversion out since SJRWMD data already in einsteins/m**2
C         IT = 0.093*ITNX
          IT = ITNX
          
C TIME TO SUNRISE (SECONDS)
          TTSS = 86400.*(1-FD)/2.
          
          TE = MAX(TENX,0.0)
          WMS = WMSNX
          READ (MET,1010,END=10010) NXMET,KTNX,TENX,ITNX,FDNX,WMSNX
          NXMET = (METPTR-1)*FILGTH+NXMET
          GO TO 10000
        END IF
        GO TO 10020

******* Open next data file

10010   CONTINUE
          METPTR = METPTR+1
          IF (DIAGNOSTICS) WRITE (DIA,*) 'Opening meteorologic file ',
     .                                    METPTR,' at day ',JDAY
          CLOSE (MET)
          OPEN  (MET,FILE=METFN(METPTR),STATUS='OLD')
          READ  (MET,1000)
          READ  (MET,1010) NXMET,KTNX,TENX,ITNX,FDNX,WMSNX
          NXMET = (METPTR-1)*FILGTH+NXMET
10020   CONTINUE
        NXTVD = MIN(NXTVD,NXMET)

******* Boundary inflow concentrations

10030     IF (JDAY.GE.NXCBC) THEN
            OLDNXCBC = NXCBC

*********** Reduce/increase concentrations

            DO 10400 JC=4,12
              DO 10390 JCB=1,NCB
                 CBNX(JCB,JC) = CBNX(JCB,JC)*REDCBC
10390         CONTINUE
10400       CONTINUE
            DO 10420 JC=13,19
              DO 10410 JCB=1,NCB
                 CBNX(JCB,JC) = CBNX(JCB,JC)*REDCBN
10410         CONTINUE
10420       CONTINUE
            DO 10440 JC=20,25
             DO 10430 JCB=1,NCB
                CBNX(JCB,JC) = CBNX(JCB,JC)*REDCBP
10430         CONTINUE
10440       CONTINUE 
            DO JC=30,32
              DO JCB=1,NCB
                 CBNX(JCB,JC) = CBNX(JCB,JC)*REDCBP
              END DO
            END DO

            DO 10050 JC=1,NAC
              II=AC(JC)
              DO 10040 JCB=1,NCB
                CBOLD(JCB,II) = CBNX(JCB,II)
                CB(JCB,II)    = CBNX(JCB,II)
10040         CONTINUE
10050       CONTINUE

******* Read in next set of boundary conditions

            DO 10055 JC=1,NAC                    ! CFC 2/28/06
              II=AC(JC)
              READ (CBC,1020,END=10060) NXCBC,(CBNX(JCB,II),
     .                                  JCB=1,NCB)
10055       CONTINUE

            NXCBC = (CBCPTR-1)*FILGTH+NXCBC
            GO TO 10030
          END IF
          GO TO 10080

********* Open next data file

10060     CONTINUE
            CBCPTR = CBCPTR+1
            IF (DIAGNOSTICS) WRITE (DIA,*) 'Opening boundary concentra',
     .                                     'tion file ',CBCPTR,' at ',
     .                                     'day ',JDAY
            CLOSE (CBC)
            OPEN  (CBC,FILE=CBCFN(CBCPTR),STATUS='OLD')
            READ  (CBC,1080)
            READ  (CBC,1030) NCB                     ! CFC 2/28/06
            READ  (CBC,1080)
            IF(NXCBC .GE. OLDNXCBC) THEN
              OLDNXCBC = NXCBC
            END IF    
            DO 10070 JC=1,NAC                !CFC 2/28/06
              II=AC(JC)
              READ  (CBC,1020) NXCBC,(CBNX(JCB,II),JCB=1,NCB)
10070       CONTINUE
            NXCBC = (CBCPTR-1)*FILGTH+NXCBC
10080     CONTINUE
          NXTVD = MIN(NXTVD,NXCBC)

******* Source One loads              !MNOEL   1-25-93

        IF (SOURCE_ONE) THEN
10090     IF (JDAY.GE.NXS1) THEN
            DO 10110 JC=1,NAC
              II=AC(JC)
              DO 10100 JS1=1,S1LN(II)
                S1L(JS1,II) = S1LNX(JS1,II)/86.4
10100         CONTINUE
10110       CONTINUE
C 
*********** Reduce/increase concentrations

            DO 10460 JC=4,12
              DO 10450 JS1=1,S1LN(JC)
                S1L(JS1,JC) = S1L(JS1,JC)*REDS1C
10450         CONTINUE
10460       CONTINUE
            DO 10480 JC=13,19
              DO 10470 JS1=1,S1LN(JC)
                S1L(JS1,JC) = S1L(JS1,JC)*REDS1N
10470         CONTINUE
10480       CONTINUE
            DO 10500 JC=20,25
              DO 10490 JS1=1,S1LN(JC)
                S1L(JS1,JC) = S1L(JS1,JC)*REDS1P
10490         CONTINUE
10500       CONTINUE
            DO JC=30,32
              DO JS1=1,S1LN(JC)
                S1L(JS1,JC) = S1L(JS1,JC)*REDS1P
              END DO
            END DO

*********** Read in next set of loads 

            DO 10115 JC=1,NAC
              II=AC(JC)
              READ (S1,1020,END=10120) NXS1,(S1LNX(JS1,II),
     .                                 JS1=1,S1LN(II))
10115       CONTINUE
            NXS1 = (S1PTR-1)*FILGTH+NXS1
            GO TO 10090
          END IF
          GO TO 10150

********* Open next data file

10120     CONTINUE
            S1PTR = S1PTR+1
            IF (DIAGNOSTICS) WRITE (DIA,*) 'Opening Source One file ',
     .                                      S1PTR,' at day ',JDAY
            CLOSE (S1)
            OPEN  (S1,FILE=S1FN(S1PTR),STATUS='OLD')
            READ  (S1,1080)
            READ  (S1,1030) (S1LN(JC),JC=1,NCP)
            DO 10130 JC=1,NAC
              II=AC(JC)
              READ (S1,1030) (S1LB(JP,II),JP=1,S1LN(II))
10130       CONTINUE
            READ (S1,1080)
            DO 10140 JC=1,NAC
              II=AC(JC)
              READ (S1,1020) NXS1,(S1LNX(JS1,II),JS1=1,S1LN(II))
10140       CONTINUE
            NXS1 = (S1PTR-1)*FILGTH+NXS1
10150     CONTINUE
          NXTVD = MIN(NXTVD,NXS1)
        END IF

******* Source Two loads              !MNOEL   1-25-93

        IF (SOURCE_TWO) THEN
10160     IF (JDAY.GE.NXS2) THEN
            DO 10180 JC=1,NAC
              II=AC(JC)
              DO 10170 JS2=1,S2LN(II)
                S2L(JS2,II) = S2LNX(JS2,II)/86.4
10170         CONTINUE
10180       CONTINUE

*********** Reduce/increase concentrations

            DO 10520 JC=4,12
              DO 10510 JS2=1,S2LN(JC)
                S2L(JS2,JC) = S2L(JS2,JC)*REDS2C
10510         CONTINUE
10520       CONTINUE
            DO 10540 JC=13,19
              DO 10530 JS2=1,S2LN(JC)
                S2L(JS2,JC) = S2L(JS2,JC)*REDS2N
10530         CONTINUE
10540       CONTINUE
            DO 10560 JC=20,25
              DO 10550 JS2=1,S2LN(JC)
                S2L(JS2,JC) = S2L(JS2,JC)*REDS2P
10550         CONTINUE
10560       CONTINUE
            DO JC=30,32
              DO JS2=1,S2LN(JC)
                S2L(JS2,JC) = S2L(JS2,JC)*REDS2P
              END DO
            END DO

*********** Read in next set of loads 

            DO 10185 JC=1,NAC
              II=AC(JC)
              READ (S2,1020,END=10190) NXS2,(S2LNX(JS2,II),
     .                                  JS2=1,S2LN(II))
              write(*,*) NXS2,ii,(S2LNX(JS1,II),
     .                                 JS1=1,S2LN(II))	
10185       CONTINUE
            NXS2 = (S2PTR-1)*FILGTH+NXS2
            GO TO 10160
          END IF
          GO TO 10220

********* Open next data file

10190     CONTINUE
            S2PTR = S2PTR+1
            IF (DIAGNOSTICS) WRITE (DIA,*) 'Opening Source Two ',
     .                                     'file ',S2PTR,' at day ',
     .                                      JDAY
            CLOSE (S2)
            OPEN  (S2,FILE=S2FN(S2PTR),STATUS='OLD')
            READ  (S2,1080)
            READ  (S2,1030) (S2LN(JC),JC=1,NCP)
            DO 10200 JC=1,NAC
              II=AC(JC)
              READ (S2,1030) (S2LB(JNP,II),JNP=1,S2LN(II))
10200       CONTINUE
            READ (S2,1080)
            DO 10210 JC=1,NAC
            II=AC(JC)
              READ (S2,1020) NXS2,(S2LNX(JS2,II),JS2=1,S2LN(II))
10210       CONTINUE
            NXS2 = (S2PTR-1)*FILGTH+NXS2
10220     CONTINUE
          NXTVD = MIN(NXTVD,NXS2)
        END IF

******* Source Three loads              

        IF (SOURCE_THR) THEN
10165     IF (JDAY.GE.NXS3) THEN
            DO JC=1,NAC
              II=AC(JC)
              DO JS3=1,S3LN(II)
                S3L(JS3,II) = S3LNX(JS3,II)/86.4
              END DO
            END DO
            
*********** Reduce/increase concentrations

            DO JC=4,12
              DO JS3=1,S3LN(JC)
                S3L(JS3,JC) = S3L(JS3,JC)*REDS3C
              END DO
            END DO
            DO JC=13,19
              DO JS3=1,S3LN(JC)
                S3L(JS3,JC) = S3L(JS3,JC)*REDS3N
              END DO
            END DO
            DO JC=20,25
              DO JS3=1,S3LN(JC)
                S3L(JS3,JC) = S3L(JS3,JC)*REDS3P
              END DO
            END DO
            DO JC=30,32
              DO JS3=1,S3LN(JC)
                S3L(JS3,JC) = S3L(JS3,JC)*REDS3P
              END DO
            END DO

*********** Read in next set of loads 

            DO JC=1,NAC
              II=AC(JC)
              READ (S3,1020,END=10195) NXS3,(S3LNX(JS3,II),
     .                                  JS3=1,S3LN(II))
            END DO
            NXS3 = (S3PTR-1)*FILGTH+NXS3
            GO TO 10165
          END IF
          
          GO TO 10225

********* Open next data file

10195     CONTINUE
            S3PTR = S3PTR+1
            IF (DIAGNOSTICS) WRITE (DIA,*) 'Opening Source Three ',
     .                                     'file ',S3PTR,' at day ',
     .                                      JDAY
            CLOSE (S3)
            OPEN  (S3,FILE=S3FN(S3PTR),STATUS='OLD')
            READ  (S3,1080)
            READ  (S3,1030) (S3LN(JC),JC=1,NCP)
            DO JC=1,NAC
              II=AC(JC)
              READ (S3,1030) (S3LB(JNP,II),JNP=1,S3LN(II))
            END DO
            READ (S3,1080)
            DO JC=1,NAC
              II=AC(JC)
              READ (S3,1020) NXS3,(S3LNX(JS3,II),JS3=1,S3LN(II))
            END DO
            NXS3 = (S3PTR-1)*FILGTH+NXS3
10225     CONTINUE
          NXTVD = MIN(NXTVD,NXS3)
        END IF


******* Benthic fluxes

        IF (BENTHIC_FLUXES) THEN
10230     IF (JDAY.GE.NXBFI) THEN
            DO 10250 JC=1,8
              DO 10240 BB=1,NBB
                BFLUX(BB,JC) = BFLUXNX(BB,JC)
10240         CONTINUE
10250       CONTINUE
            DO 10255 JC=1,9
              READ (BFI,1020,END=10260) NXBFI,(BFLUXNX(BB,JC),BB=1,NBB)
10255       CONTINUE
            DO 10570 BB=1,NBB
              BFLUXB(BB,1) = BFLUX(BB,1)                  !                DOC
              BFLUXB(BB,2) = BFLUX(BB,2)                  !                NH4
              BFLUXB(BB,3) = BFLUX(BB,3)                  !                NO3
              BFLUXB(BB,4) = BFLUX(BB,5)                  !                PO4
              BFLUXB(BB,5) = BFLUX(BB,7)                  !                COD
              BFLUXB(BB,6) = BFLUX(BB,8)                  !                DO
10570       CONTINUE
            NXBFI = (BFIPTR-1)*FILGTH+NXBFI
            GO TO 10230
          END IF
          GO TO 10270

********* Open next data file

10260     CONTINUE
            BFIPTR = BFIPTR+1
            IF (DIAGNOSTICS) WRITE (DIA,*) 'Opening benthic flux file ',
     .                                      BFIPTR,' at day ',JDAY
            CLOSE (BFI)
            OPEN  (BFI,FILE=BFIFN(BFIPTR),STATUS='OLD')
            READ  (BFI,1000)
            READ  (BFI,1050)  KSDOC,KSNH4,KSNO3,KSPO4,KSO
            READ  (BFI,1050)  TRSDOC,TRSNH4,TRSNO3,TRSPO4,TRSO
            READ  (BFI,1050)  MTCNO3, SEDNO3, KHSO  
            READ  (BFI,1020)  NXBFI,(BFLUXNX(BB,JC),BB=1,NBB)
            NXBFI = (BFIPTR-1)*FILGTH+NXBFI
10270     CONTINUE
          NXTVD = MIN(NXTVD,NXBFI)
        END IF


******* Atmospheric Loads

        IF (ATMOS_LOADS) THEN
10330     IF (JDAY.GE.NXATM) THEN
            PRECIP = PRECIPNX/8640000.
            ATMNH4 = ANH4NX
            ATMNO3 = ANO3NX
            ATMLDON = ALDONNX
            ATMRDON = ARDONNX
            ATMPO4 = APO4NX
            ATMLDOP = ALDOPNX
            ATMRDOP = ARDOPNX
            READ (ATM,1010,END=10340) NXATM,PRECIPNX,ANH4NX,ANO3NX,
     .        ALDONNX,ARDONNX,APO4NX,ALDOPNX,ARDOPNX
            NXATM = (ATMPTR-1)*FILGTH+NXATM
            GO TO 10330
          END IF
          GO TO 10350

********* Open next data file

10340     CONTINUE
            ATMPTR = ATMPTR+1
            IF (DIAGNOSTICS) WRITE (DIA,*) 'Opening atmospheric load',
     .                                     'ing file ',ATMPTR,' at ',
     .                                     'day ',JDAY
            CLOSE (ATM)
            OPEN  (ATM,FILE=ATMFN(ATMPTR),STATUS='OLD')
            READ  (ATM,1000)
            READ  (ATM,1010) NXATM,PRECIPNX,ANH4NX,ANO3NX,ALDONNX,
     .                       ARDONNX,APO4NX,ALDOPNX,ARDOPNX
            NXATM = (ATMPTR-1)*FILGTH+NXATM
10350     CONTINUE
          NXTVD = MIN(NXTVD,NXATM)
        END IF

******* Submerged Aquatic Vegetation
          
        IF (SAV_CALC) THEN
10360     IF (JDAY.GE.NXSAV) THEN
            DO I=1,NSAVCELL
              B=SAVCELL(I)
              SAVAREA(B) = SAVAREA_NX(B)
              SAVDPH(B)  = SAVDPH_NX(B) 
              SAVFRAC(B) = SAVAREA(B)/SFA(B)    ! fractional area of sav cell 
            END DO 
            READ (SVI,1026,END=10370) NXSAV
            DO I=1,NSAVCELL
              READ(SVI,*) B, DOMSP(B), SAVAREA_NX(B), SAVDPH_NX(B)
            END DO
            NXSAV = (SAVPTR-1)*FILGTH+NXSAV
            GO TO 10360
          END IF
          GO TO 10380

********* Open next data file

10370     CONTINUE
            SAVPTR = SAVPTR+1
            IF (DIAGNOSTICS) WRITE (DIA,*) 'Opening aquatic vegetation',
     .                                     ' file ',SAVPTR,' at day ',
     .                                      JDAY
            CLOSE (SVI)
            OPEN  (SVI,FILE=SVIFN(SAVPTR),STATUS='OLD')
            READ(SVI,1026) NXSAV
            DO I=1,NSAVCELL
              READ(SVI,*) B, DOMSP(B), SAVAREA_NX(B), SAVDPH_NX(B)
            END DO
            NXSAV = (SAVPTR-1)*FILGTH+NXSAV
10380     CONTINUE
          NXTVD = MIN(NXTVD,NXSAV)
        END IF

******* Input FORMAT's

 1000   FORMAT(///)
 1010   FORMAT(10F8.0,:/(:8X,9F8.0))
 1020   FORMAT(8X,9F8.0,:/(:16X,8F8.0))
 1025   FORMAT(16X,F8.0)
 1026   FORMAT(//8X,F8.0//)
 1030   FORMAT(//(8X,9I8))
 1040   FORMAT(/)
 1050   FORMAT(://8X,9F8.0)
 1060   FORMAT(8X,9F8.0)
 1070   FORMAT(//(:8X,6F8.0))
 1080   FORMAT(/)
 1082 FORMAT(//8X,2A8//)
 1100 FORMAT(/)

      END SUBROUTINE TVDS


************************************************************************
**                S U B R O U T I N E   F L U X E S                   **
************************************************************************


      SUBROUTINE AVERAGES
      USE WQM
      IMPLICIT NONE
      INTEGER  ::  f, sb, jc, n, jg, i

************************************************************************
**                           Flux averages                            **
************************************************************************

      IF (H_TRANS_FLUX) THEN

******* Horizontal fluxes

        DO 10000 F=1,NHQF
	  DO JC=1,NAC
	    AFLUXT(F,AC(JC)) = AFLUXT(F,AC(JC))+FLUXT(F,AC(JC))
	  END DO
10000   CONTINUE

      END IF
      
      IF (V_TRANS_FLUX) THEN

******* Vertical transport fluxes, no settling
******* The sign on FLUXT makes average flux positive from left to right
******* Positive upwards for faces numbered from bottom to top

        DO 10010 F=NHQF+1,NQF
	  DO JC=1,NAC
	    AFLUXT(F,AC(JC)) = AFLUXT(F,AC(JC))-FLUXT(F,AC(JC))
	  END DO
10010   CONTINUE

      END IF
      
      IF (S_TRANS_FLUX) THEN

******* Vertical settling fluxes

        DO F=NHQF+1,NQF
	  DO JC=1,NAC
	    AFLUXS(F,AC(JC)) = AFLUXS(F,AC(JC))+
     .        FLUXS(F,AC(JC))*DLT                  ! g 
	  END DO
        END DO

      END IF

************************************************************************
**                           Plot averages                            **
************************************************************************

      IF (AVERAGE_PLOTS) THEN

******* State variables

        DO 10030 JC=1,NAC
          DO 10020 B=1,NB
            AC1(B,AC(JC)) = AC1(B,AC(JC))+C1(B,AC(JC))*DLT
10020     CONTINUE
10030   CONTINUE

******* Auxillary variables

        DO 10040 B=1,NB
          ACCHL1(B) = ACCHL1(B)+CCHL1(B)*DLT
          ACCHL2(B) = ACCHL2(B)+CCHL2(B)*DLT
          ACCHL3(B) = ACCHL3(B)+CCHL3(B)*DLT
10040   CONTINUE
        IF (QUALITY_DIAG) THEN
          DO 10050 B=1,NB
            AKE(B)   = AKE(B)+KESS(B)*DLT
            AFI1(B)  = AFI1(B)+FI1(B)*DLT/FD
            ANL1(B)  = ANL1(B)+NL1(B)*DLT
            APL1(B)  = APL1(B)+PL1(B)*DLT
            AFI2(B)  = AFI2(B)+FI2(B)*DLT/FD
            ANL2(B)  = ANL2(B)+NL2(B)*DLT
            APL2(B)  = APL2(B)+PL2(B)*DLT
            AFI3(B)  = AFI3(B)+FI3(B)*DLT/FD
            ANL3(B)  = ANL3(B)+NL3(B)*DLT
            APL3(B)  = APL3(B)+PL3(B)*DLT
            ANPP(B)  = ANPP(B)+NPP(B)*DLT
            AGPP(B)  = AGPP(B)+GPP(B)*DLT
            ACFIX(B) = ACFIX(B)+CFIX(B)*DLT
            ARESP(B) = ARESP(B)+RESP(B)*DLT
10050     CONTINUE
          DO B=1,NSB
            AASRAT(B)= AASRAT(B)+ASRAT(B)*DLT
            AKRDO(B) = AKRDO(B)+KRDO(B)*DLT
          END DO
          DO 10052 BB=1,NBB
            AFIB(BB)  = AFIB(BB)+FIB(BB)*DLT/FD
            ANLB(BB)  = ANLB(BB)+NLB(BB)*DLT
            APLB(BB)  = APLB(BB)+PLB(BB)*DLT
            ANPPB(BB) = ANPPB(BB)+NPPB(BB)*DLT
10052     CONTINUE
        END IF

******* Benthic variables

        IF (SEDIMENT_DIAG) THEN
          DO 10070 BB=1,NBB
            ACPIP(BB)   = ACPIP(BB)+CPIP(BB)*DLT
            ACPO4(BB)   = ACPO4(BB)+CPO4(BB)*DLT
            ASSFWS(BB)  = ASSFWS(BB)+SSFWS(BB)*DLT
            APCFWS(BB)  = APCFWS(BB)+PCFWS(BB)*DLT
            APNFWS(BB)  = APNFWS(BB)+PNFWS(BB)*DLT
            APPFWS(BB)  = APPFWS(BB)+PPFWS(BB)*DLT
            APIPFWS(BB) = APIPFWS(BB)+PIPFWS(BB)*DLT
            ABENDO(BB)  = ABENDO(BB)+BENDO(BB)*DLT
            ABENDOC(BB) = ABENDOC(BB)+BENDOC(BB)*DLT
            ABENNH4(BB) = ABENNH4(BB)+BENNH4(BB)*DLT
            ABENNO3(BB) = ABENNO3(BB)+BENNO3(BB)*DLT
            ABENPO4(BB) = ABENPO4(BB)+BENPO4(BB)*DLT
            ABENCOD(BB) = ABENCOD(BB)+BENCOD(BB)*DLT
            ABENCH4G(BB) = ABENCH4G(BB)+BENCH4G(BB)*DLT
            ABENCH4A(BB) = ABENCH4A(BB)+BENCH4A(BB)*DLT
            ABBM(BB)    = ABBM(BB)+BBM(BB)*DLT
            ABLITE(BB)  = ABLITE(BB)+BLITE(BB)*DLT
            DO N=1,NSPECIES 
              ASFEED(BB,N)  = ASFEED(BB,N)+SFEED(BB,N)*DLT 
              ASFGCIN(BB) = ASFGCIN(BB) + SF_SFGC(BB,N)*DLT
              ASFCFEC(BB) = ASFCFEC(BB) + SFCFECES(BB,N)*DLT
              ASFCPSF(BB) = ASFCPSF(BB) + SFCPSFEC(BB,N)*DLT
              ASF_SFGC(BB,N)  = ASF_SFGC(BB,N)  + SF_SFGC(BB,N)*DLT
              ASF_RESP(BB,N)  = ASF_RESP(BB,N)  + SF_RESP(BB,N)*DLT
              ASF_PRED(BB,N)  = ASF_PRED(BB,N)  + SF_PRED(BB,N)*DLT
              ASF_RMORT(BB,N) = ASF_RMORT(BB,N) + SF_RMORT(BB,N)*DLT
              ASFFILTCT(BB,N) = ASFFILTCT(BB,N) + SFFILTCT(BB,N)*DLT
            END DO
            AJNSF(BB) = AJNSF(BB) + JNH4SF(BB)*DLT
            AJPSF(BB) = AJPSF(BB) + JPO4SF(BB)*DLT
            ASODSF(BB) = ASODSF(BB) + SODSF(BB)*DLT
            AFLXCSF(BB) = AFLXCSF(BB) + SFLUXC(BB)*DLT
            AFLXNSF(BB) = AFLXNSF(BB) + SFLUXN(BB)*DLT
            AFLXPSF(BB) = AFLXPSF(BB) + SFLUXP(BB)*DLT
            ARPOCSF(BB) = ARPOCSF(BB) + SF_RPOC(BB)*DLT
            ARPONSF(BB) = ARPONSF(BB) + SF_RPON(BB)*DLT
            ARPOPSF(BB) = ARPOPSF(BB) + SF_RPOP(BB)*DLT
	    IF (SEDKIN .EQ. 'SSI') THEN
              ASSISF(BB) = ASSISF(BB) + SF_SSI(BB)*DLT
	    ELSE
              ASSISF(BB) = ASSISF(BB) 
     $          + (SF_CLY(BB)+SF_SLT(BB)+SF_ORG(BB))*DLT
            END IF	    
            ASSIPSF(BB) = ASSIPSF(BB) + SF_PIP(BB)*DLT
            ASF_CFILT(BB) = ASF_CFILT(BB) + SF_CFILT(BB)*DLT
            ASF_NFILT(BB) = ASF_NFILT(BB) + SF_NFILT(BB)*DLT
            ASF_PFILT(BB) = ASF_PFILT(BB) + SF_PFILT(BB)*DLT
            DO JG=1,3
              ACPOC(BB,JG) = ACPOC(BB,JG)+CPOC(BB,JG)*DLT
              ACPON(BB,JG) = ACPON(BB,JG)+CPON(BB,JG)*DLT
              ACPOP(BB,JG) = ACPOP(BB,JG)+CPOP(BB,JG)*DLT
            END DO
10070     CONTINUE
        END IF
        
******* SAV variables

cvjp modified 11/3/2005
        IF (SAV_PLOTS) THEN
          DO I=1,NSAVCELL
            B=SAVCELL(I)
              ALEAF(B)  = ALEAF(B)+LEAF(B)*DLT
              ASTEM(B)  = ASTEM(B)+STEM(B)*DLT
              ATUBER(B) = ATUBER(B)+TUBER(B)*DLT
              AEP(B)    = AEP(B)+EP(B)*DLT
              AROOT(B)  = AROOT(B)+ROOT(B)*DLT
              AFISH(B)  = AFISH(B)+FISH(B)*DLT/FD
              AFIEP(B)  = AFIEP(B)+FIEP(B)*DLT/FD
              ANPPSAV(B)= ANPPSAV(B)+NPPSAV(B)*DLT
              ANPPEP(B) = ANPPEP(B)+NPPEPI(B)*DLT
              AWATATN(B)= AWATATN(B)+WATATN(B)*DLT
              AEPATN(B) = AEPATN(B)+EPATN(B)*DLT
            ANLSAV(B) = ANLSAV(B)+NLSAV(B)*DLT
            APLSAV(B) = APLSAV(B)+PLSAV(B)*DLT
            ANLEPI(B) = ANLEPI(B)+NLEPI(B)*DLT
            APLEPI(B) = APLEPI(B)+PLEPI(B)*DLT
            AFNSED(B) = AFNSED(B)+FNSEDSAV(B)*DLT
            AFPSED(B) = AFPSED(B)+FPSEDSAV(B)*DLT
	    ASAVEFCT(B) = ASAVEFCT(B)+SAVEFCT(B)*DLT

          END DO
        END IF
      END IF


************************************************************************
**                  Kinetic Flux averages                             **
************************************************************************

      IF (KINETIC_FLUXES) THEN                  !MNOEL

        DO 10080 B=1,NB

********* Algae 

          A_T(B)      = A_T(B)+T(B)*DLT      
          AP1 (B)     = AP1(B)+P1(B)*DLT     
          ABM1(B)     = ABM1(B)+BM1(B)*DLT    
          APR1(B)     = APR1(B)+PR1(B)*DLT    
          AP2(B)      = AP2(B)+P2(B)*DLT     
          ABM2(B)     = ABM2(B)+BM2(B)*DLT    
          APR2(B)     = APR2(B)+PR2(B)*DLT    
          AP3(B)      = AP3(B)+P3(B)*DLT     
          ABM3(B)     = ABM3(B)+BM3(B)*DLT    
          APR3(B)     = APR3(B)+PR3(B)*DLT    

********* Carbon

          AALGDOC(B)  = AALGDOC(B)+ALGDOC(B)*DLT 
          AALGPOC(B)  = AALGPOC(B)+ALGPOC(B)*DLT 
          ADENIT(B)   = ADENIT(B)+DENIT(B)*DLT  
          AMNLDOC(B)  = AMNLDOC(B)+MNLLDOC(B)*DLT+MNLRDOC(B)*DLT 
          AHDRPOC(B)  = AHDRPOC(B)+HDRLPOC(B)*DLT+HDRRPOC(B)*DLT

********* Nitrogen

          AALGNH4(B)  = AALGNH4(B)+ALGNH4(B)*DLT 
          AALGNO3(B)  = AALGNO3(B)+ALGNO3(B)*DLT 
          AALGDON(B)  = AALGDON(B)+ALGDON(B)*DLT 
          AALGPON(B)  = AALGPON(B)+ALGPON(B)*DLT 
          ANT(B)      = ANT(B)+NT(B)*DLT     
          ADENNO3(B)  = ADENNO3(B)+DENNO3(B)*DLT 
          AMNLDON(B)  = AMNLDON(B)+MNLLDON(B)*DLT+MNLRDON(B)*DLT 
          AHDRPON(B)  = AHDRPON(B)+HDRLPON(B)*DLT+HDRRPON(B)*DLT

********* Phosphorus

          AALGPO4(B)  = AALGPO4(B)+ALGPO4(B)*DLT 
          AALGDOP(B)  = AALGDOP(B)+ALGDOP(B)*DLT 
          AALGPOP(B)  = AALGPOP(B)+ALGPOP(B)*DLT 
          AMNLDOP(B)  = AMNLDOP(B)+MNLLDOP(B)*DLT+MNLRDOP(B)*DLT 
          AHDRPOP(B)  = AHDRPOP(B)+HDRLPOP(B)*DLT+HDRRPOP(B)*DLT

********* Dissolved Oxygen

          ADO(B)      = ADO(B)+DO(B)*DLT     
          ADORALG(B)  = ADORALG(B)+DORALG(B)*DLT 
          ADOPR(B)    = ADOPR(B)+DOPR(B)*DLT   
          ADCOD(B)    = ADCOD(B)+DCOD(B)*DLT   
          ADDOC(B)    = ADDOC(B)+DDOC(B)*DLT   
          ANITRIF(B)  = ANITRIF(B)+NITRIF(B)*DLT

10080   CONTINUE

        IF (SFEEDER) THEN
          DO N=1,NSPECIES
            DO B=1,NBB
              ACHARV(B,N)   = ACHARV(B,N)+CHARV(B,N)*DLT
            END DO
          END DO
        END IF

cvjp modified 11/3/2005
        IF (SAV_CALC) THEN
          DO 10090 I=1,NSAVCELL
            B = SAVCELL(I)

*********** SAV and Epiphytes

              APLEAF(B)   = APLEAF(B)+PLEAF(B)*DLT
              ABMLEAF(B)  = ABMLEAF(B)+BMLEAF(B)*DLT
              ASLSH(B)    = ASLSH(B)+SLSH(B)*DLT
              APEP(B)     = APEP(B)+PEP(B)*DLT
              ABMEP(B)    = ABMEP(B)+BMEP(B)*DLT
              APREP(B)    = APREP(B)+PREP(B)*DLT
            ABMTUBER(B)   = ABMTUBER(B)+BMTUBER(B)*DLT

*********** Carbon

            ADOCSAV(B)    = ADOCSAV(B)+LDOCSAV(B)*DLT+RDOCSAV(B)*DLT
            APOCSAV(B)    = APOCSAV(B)+LPOCSAV(B)*DLT+RPOCSAV(B)*DLT
            ADOCEPI(B)    = ADOCEPI(B)+LDOCEPI(B)*DLT+RDOCEPI(B)*DLT
            APOCEPI(B)    = APOCEPI(B)+LPOCEPI(B)*DLT+RPOCEPI(B)*DLT
            ASEDCSAV(B)   = ASEDCSAV(B)+SEDCSAV(B)*DLT

*********** Nitrogen

            ANH4SAVW(B)   = ANH4SAVW(B)+NH4SAVW(B)*DLT
            ANO3SAVW(B)   = ANO3SAVW(B)+NO3SAVW(B)*DLT
            ADONSAVW(B)   = ADONSAVW(B)+LDONSAVW(B)*DLT
     $                      +RDONSAVW(B)*DLT
            APONSAVW(B)   = APONSAVW(B)+LPONSAVW(B)*DLT
     $                      +RPONSAVW(B)*DLT
            ANH4EPI(B)    = ANH4EPI(B)+NH4EPI(B)*DLT
            ANO3EPI(B)    = ANO3EPI(B)+NO3EPI(B)*DLT
            ADONEPI(B)    = ADONEPI(B)+LDONEPI(B)*DLT+RDONEPI(B)*DLT
            APONEPI(B)    = APONEPI(B)+LPONEPI(B)*DLT+RPONEPI(B)*DLT
            ASEDNSAV(B)   = ASEDNSAV(B)+SEDNSAV(B)*DLT
            ASEDNH4SAV(B) = ASEDNH4SAV(B)+SEDNH4SAV(B)*DLT

            
*********** Phosphorus

            APO4SAVW(B)   = APO4SAVW(B)+PO4SAVW(B)*DLT
            ADOPSAVW(B)   = ADOPSAVW(B)+LDOPSAVW(B)*DLT
     $                      +RDOPSAVW(B)*DLT
            APOPSAVW(B)   = APOPSAVW(B)+LPOPSAVW(B)*DLT
     $                      +RPOPSAVW(B)*DLT
            APO4EPI(B)    = APO4EPI(B)+PO4EPI(B)*DLT
            ADOPEPI(B)    = ADOPEPI(B)+LDOPEPI(B)*DLT+RDOPEPI(B)*DLT
            APOPEPI(B)    = APOPEPI(B)+LPOPEPI(B)*DLT+RPOPEPI(B)*DLT
            ASEDPSAV(B)   = ASEDPSAV(B)+SEDPSAV(B)*DLT
            ASEDPO4SAV(B) = ASEDPO4SAV(B)+SEDPO4SAV(B)*DLT

*********** Dissolved Oxygen

            ADOSAV(B)     = ADOSAV(B)+DOSAV(B)*DLT
            ADOEPI(B)     = ADOEPI(B)+DOEPI(B)*DLT
            ASEDDOSAV(B)  = ASEDDOSAV(B)+SEDDOSAV(B)*DLT

10090     CONTINUE
     
        END IF
                              
        IF (BALGAE_CALC) THEN

          DO 10100 B=1,NBB

*********** Production and Respiration

            ABMB(B)       = ABMB(B)+BMB(B)
            APB(B)        = APB(B)+PB(B)
            APRB(B)       = APRB(B)+PRB(B)

*********** Carbon

            ABADOC(B)     = ABADOC(B)+BADOC(B)*DLT
            ABAPOC(B)     = ABAPOC(B)+BAPOC(B)*DLT

*********** Nitrogen

            ABANH4(B)     = ABANH4(B)+BANH4(B)*DLT
            ABANO3(B)     = ABANO3(B)+BANO3(B)*DLT
            ABAPON(B)     = ABAPON(B)+BAPON(B)*DLT

            
*********** Phosphorus

            ABAPO4(B)     = ABAPO4(B)+BAPO4(B)*DLT
            ABAPOP(B)     = ABAPOP(B)+BAPOP(B)*DLT

*********** Dissolved Oxygen

            ABADO(B)      = ABADO(B)+BADO(B)*DLT

10100     CONTINUE

        END IF                      

      END IF

      END


      SUBROUTINE AUTOSTEP()
C----------------------------------------------------------------
C     Determine maximum allowable timestep
C----------------------------------------------------------------
      USE FILE_INFO; USE WQM;  USE WQM_INIT
!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
      USE MESSENGER
#endif
      IMPLICIT NONE
      REAL :: TESTMAX, TESTMAX1, TESTMAX2
      REAL :: COURQ, COURN, DFNUM, DIFFVS
      logical ft              !CFC 070105
      save    ft              !CFC 070105
      data    ft /.TRUE./     !CFC 070105

      dltn = dlt                            ! TKG 8-2001: DLTN: previous time step
      COURMX = 0.
      DIFFMX = 0.                                     ! CFC JAN 16, 1993
      MAXDLT = 1.E6                                   ! ""  ""  ""  ""
      DO 10571 F=1,NHQF
         IF (POSITIVE_FLOW(F)) THEN
           IF (LEFT_FLOWB(F)) THEN
              COURBSV(F) = JB(F)
              COURVSV(F) = V2(JB(F))
           ELSE
              COURBSV(F) = IB(F)
              COURVSV(F) = V2(IB(F))
           END IF
         ELSE
           IF (RIGHT_FLOWB(F)) THEN
             COURBSV(F) = IB(F)
             COURVSV(F) = V2(IB(F))
           ELSE
             COURBSV(F) = JB(F)
             COURVSV(F) = V2(JB(F))
           END IF
          END IF
10571     CONTINUE
          IF (QUICKEST) THEN
            TESTMAX1=MAXDLT
            TESTMAX2=MAXDLT
            DO 10572 F=1,NHQF
              COURQ    = ABS(Q(F))
              COURN = COURQ/COURVSV(F)*DLT
C             *** Search for limiting courant condition
              IF (COURN.GT.COURMX) THEN
                COURFS = F
                COURBS = COURBSV(F)
                COURVS = COURVSV(F)
                COURQS = COURQ
                COURMX = COURN
                TESTMAX1 = AINT(COURVSV(F)/COURQ*FNDLT)
              ENDIF
C             *** Search for limiting diffusion condition
              DFNUM = DIFF(F)*DLT*A(F)**2/COURVSV(F)**2
              IF (DFNUM.GT.DIFFMX) THEN
                DIFFFS = F
                DIFFDS = DIFF(F)
                DIFFBS = COURBSV(F)
                DIFFVS = COURVSV(F)
                DIFFAS = A(F)
                DIFFMX = DFNUM
                TESTMAX2 = AINT(FNDLT*COURVSV(F)**2/
     &                    (2.0*DIFF(F)*A(F)**2))
              ENDIF
              MAXDLT = MIN(MAXDLT,TESTMAX1,TESTMAX2)
10572       CONTINUE
          ELSE
            DO 10573 F=1,NHQF
              COURQ    = ABS(Q(F))
              COURN = COURQ/COURVSV(F)*DLT
              DFNUM = DIFF(F)*DLT*A(F)**2/COURVSV(F)**2
C             *** Combined limitation for upwind scheme
              TESTMAX=AINT(FNDLT/((2*DIFF(F)*A(F)**2/COURVSV(F)**2)+
     &                (COURQ/COURVSV(F))))
              IF (TESTMAX.LT.MAXDLT) THEN
                DIFFFS = F
                DIFFDS = DIFF(F)
                DIFFBS = COURBSV(F)
                DIFFVS = COURVSV(F)
                DIFFAS = A(F)
                DIFFMX = DFNUM
                COURFS = F
                COURBS = COURBSV(F)
                COURVS = COURVSV(F)
                COURQS = COURQ
                COURMX = COURN
                MAXDLT = TESTMAX
              ENDIF
10573       CONTINUE
          ENDIF
          ELTMS1 = ELTMS
          MAXDLTDP = MAXDLT
          MXDLTDP  = MXDLT
          NXHYDDP  = NXHYD
          DLT8   = MIN(MAXDLTDP,NXHYDDP-ELTMS1,MXDLTDP)

!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
C
         CALL COMM_DLT   !  Determine Maximum allowable timestep using MPI
C
          IF (MAXDLTDP .LT. MINSTEP) THEN
           WRITE(DIA,10505) MAXDLTDP, JDAY, COURFS, COURBS
           WRITE(DIA,10506) COURQS, DIFFDS, COURVS, DIFFAS
           CALL COMM_EXIT()
           STOP 'AUTOSTEP'  
          END IF
!.... PARALLEL SECTION ENDS
#else
         IF (MAXDLTDP .LT. MINSTEP) THEN
          WRITE(DIA,10505) MAXDLTDP, JDAY, COURFS, COURBS
          WRITE(DIA,10506) COURQS, DIFFDS, COURVS, DIFFAS
          STOP 'AUTOSTEP'  
         END IF
#endif
          DLT    = REAL(DLT8,4)

          if(ft) then           !CFC 070105
            dltn = dlt          !CFC 070105
            ft = .FALSE.        !CFC 070105
          endif                 !CFC 070105

      RETURN
10505 FORMAT(' TIME STEP = ',F10.3,' SECONDS AT DAY ',F10.3,
     $       /' FACE ',I6,' BOX ',I6)
10506 FORMAT(' FLOW = ',E14.6,' DIFFUSION = ', E14.6,
     $       /' VOLUME = ',E14.6,' AREA = ',E14.6)
      END SUBROUTINE AUTOSTEP
