************************************************************************
**               S U B R O U T I N E   S U S P F E E D                **
************************************************************************
**                                                                    **
**         Chesapeake Bay Suspension Feeder Model                     **
**                                                                    **
**        Extensively modifed by CFC Nov 7, 2005                      **
**        Combines Oyster model (Group 1) for 12,000 cell grid        **
**        with original HydroQual model.  Nutrient limits and         **
**        other factors adopted from oyster model for the             **
**        remaining suspension feeder groups.                         **
**                                                                    **
**        Links to ROMS added by CFC March 7, 2007                    **
**                                                                    **
************************************************************************

      SUBROUTINE  SUSPFEED(N)

        USE WQM

C THESE ARE LOCAL WORK ARRAYS (end in X)
      REAL SF(NSBP), JNH4SFX(NSBP), JPO4SFX(NSBP), SODSFX(NSBP)
     .     ,MAXINGX
     .     ,SFLUXCX(NSBP),SFLUXNX(NSBP),SFLUXPX(NSBP)
     .     ,SF_RPOCX(NSBP),SF_RPONX(NSBP),SF_RPOPX(NSBP)
     .     ,SF_PIPX(NSBP), SF_SSIX(NSBP),FR_RSUSPX(NSBP)
     .     ,SF_CLYX(NSBP), SF_SLTX(NSBP), SF_ORGX(NSBP)
      REAL SF_CFILTX(NSBP), SF_NFILTX(NSBP), SF_PFILTX(NSBP)
      REAL LOGICT,CLOGI,LPOCASF,LPONASF,LPOPASF,PIPASF
      REAL NFECES, NFILT, NPSFEC
      REAL KHSSF, KTG1SFX, KTG2SFX
      REAL NYUIJX(NSBP), SFPREDX(NSBP), HARVESTX(NSBP), SCOVERX(NSBP) 
      INTEGER SEDTYPEX(NSBP)
      LOGICAL AQUACX

      DATA REFUGE /0.10/ KHSSF/7./

C Set up calculation for species type N

      DO B=1,NBB
       SF(B)=SFEED(B,N)
       SEDTYPEX(B)=SEDTYPE(B,N)

CMBM 961226 diagnostic arrays reset everywhere, every time step
        SFFILTCT(B,N) = 0.
        SFRESPCT(B,N) = 0.
        SFPREDCT(B,N) = 0.
        SFRATEI(B,N)  = 0.
        SFGCMAX(B,N)  = 0.
        SFGMIN(B,N)   = 0.
        SFCFECES(B,N) = 0.
        SFNFECES(B,N) = 0.
        SFPFECES(B,N) = 0.
        SFCPSFEC(B,N) = 0.
        SFNPSFEC(B,N) = 0.
        SFPPSFEC(B,N) = 0.
        SF_SFGC(B,N)  = 0.
        SF_RESP(B,N)  = 0.
        SF_PRED(B,N)  = 0.
        SF_RMORT(B,N) = 0.
	CHARV(B,N)    = 0.

      ENDDO

      FILTX=FILT(N)
      SFA1X=SFA1(N)
      SFA2X=SFA2(N)
      SFA3X=SFA3(N)
      SFA4X=SFA4(N)
      SFA5X=SFA5(N)
      MAXINGX=MAXING(N)
      SFCNX=SFCN(N)
      SFCPX=SFCP(N)
      BMRSFX=BMRSF(N)
      PRPWRX=SFPRPWR(N)
      SFTMNX=SFTMN(N)
      TOPTSFX=TOPTSF(N)
      KTG1SFX=KTG1SF(N)
      KTG2SFX=KTG2SF(N)
      TDX=SFTD(N)
      RFSFX=RFSF(N)
      IF (AQUACULTURE(N) .EQ. '      ON') THEN
        AQUACX = .TRUE.
      ELSE
        AQUACX = .FALSE.
      END IF

      DO B=1,NBB
        SFPREDX(B) = SFPRED(B,N)
        HARVESTX(B) = HARVEST(B,N)
        NYUIJX(B) = NYUIJ(B,N)
        FR_RSUSPX(B) = FR_RSUSP(B,N)
        SCOVERX(B) = SCOVER(B,N)
      END DO

C CONVERT MODEL JULIAN DAY (STARTS AT ZERO) TO DAY OF YEAR (STARTS AT 1)

      DOY = 1. + AMOD(JDAY,365.25)
      
C ASSIGN SEASONAL OYSTER MORTALITY AND HARVEST

      IF (N .EQ. 3 .OR. N .EQ. 5) THEN
        IF (DOY .LT. 152. .OR. DOY .GT. 304.) THEN
          DO B=1,NBB
	    SFPREDX(B) = 0.0
	  END DO
	END IF
	IF (DOY .GT. 122. .AND. DOY .LT. 274.) THEN
          DO B=1,NBB
	    HARVESTX(B) = 0.0
	  END DO
	END IF
      END IF

c do some initial calcs for low o2 respiration stress

      RD=4.605/TDX          ! ln(1/100)=4.6=99% mortality
      DOhx=SFDOh(N)
      DOqx=SFDOq(N)

C reset local flux contribution to zero at start of each timestep as 
C each species contribution is added to total at bottom

      DO B=1,NBB  
        JNH4SFX(B)=0.0
        JPO4SFX(B)=0.0
        SODSFX(B)=0.0
        SFLUXCX(B)=0.0
        SFLUXNX(B)=0.0
        SFLUXPX(B)=0.0
        SF_RPOCX(B)=0.0
        SF_RPONX(B)=0.0
        SF_RPOPX(B)=0.0
        SF_SSIX(B)=0.0
	SF_CLYX(B)=0.0
	SF_SLTX(B)=0.0
	SF_ORGX(B)=0.0
        SF_PIPX(B)=0.0
        SF_CFILTX(B)=0.0
        SF_NFILTX(B)=0.0
        SF_PFILTX(B)=0.0        
      ENDDO

C Re-init global particulate fluxes 

      IF(N.EQ.1)THEN
       DO B=1,NBB
        JNH4SF(B)=0.0
        JPO4SF(B)=0.0
        SODSF(B)=0.0
        SFLUXC(B)=0.0
        SFLUXN(B)=0.0
        SFLUXP(B)=0.0
	SF_LDOC(B)=0.0
        SF_RPOC(B)=0.0
        SF_RPON(B)=0.0
        SF_RPOP(B)=0.0
        SF_SSI(B)=0.0
	SF_CLY(B)=0.0
	SF_SLT(B)=0.0
	SF_ORG(B)=0.0
        SF_PIP(B)=0.0
        SF_CFILT(B)=0.0
        SF_NFILT(B)=0.0
        SF_PFILT(B)=0.0        
       ENDDO
      ENDIF

c main loop

      DTDAY = DLT/86400.

        DO  256 B=1,NBB
          IWC=BBN(B)

C COMPUTE FOOD,PARTICULATES AVAILABLE TO SUSPENSION FEEDERS

          B1ASF = MAX(1.E-6,B1(IWC))          
          B2ASF = MAX(1.E-6,B2(IWC))          
          B3ASF = MAX(1.E-6,B3(IWC))
          LPOCASF = MAX(1.E-6,LPOC(IWC))          
          RPOCASF = MAX(1.E-6,RPOC(IWC))
          LPONASF = MAX(1.E-6,LPON(IWC))          
          RPONASF = MAX(1.E-6,RPON(IWC))
          LPOPASF = MAX(1.E-6,LPOP(IWC))          
          RPOPASF = MAX(1.E-6,RPOP(IWC))
          SSIASF = MAX(1.E-6,SSI(IWC))          
          CLYASF = MAX(1.E-6,SEDCLY(IWC))          
          SLTASF = MAX(1.E-6,SEDSLT(IWC))  
	  ORGASF = MAX(1.E-6,SEDORG(IWC))        
	  PIPASF = MAX(1.E-6,PIP(IWC))

          FILTCT=0.0
          RESPCT=0.0
          PREDCT=0.0
          RMORT=0.0                    !MBM 972830
          RATEI=0.0
          GCMAX=0.0
          SFGC=0.0
          GMIN=0.0
          CFECES=0.0
          RCFECES=0.0
          NFECES=0.0
          RNFECES=0.0
          PFECES=0.0
          RPFECES=0.0
          CFILT=0.0
          NFILT=0.0
          PFILT=0.0
          CPSFEC=0.0
          RCPSFEC=0.0
          NPSFEC=0.0
          RNPSFEC=0.0
          PPSFEC=0.0
          RPPSFEC=0.0

          IF(T(IWC).LT.SFTMNX) GO TO 256

          DOX = MAX(0.0,DO(BBN(B)))
          
c take into account habitat type

          IF(SEDTYPEX(B).EQ.0)THEN
            SF(B)= REFUGE                 !  10 mgC/m2 "refuge" population
            GO  TO 256
          ENDIF

c calculate temperature-dependent filtration and respiration

          IF (T(IWC) .LE. TOPTSFX) THEN
	    FILTCT = FILTX * EXP(-KTG1SFX*(T(IWC)-TOPTSFX)**2)
	  ELSE
	    FILTCT = FILTX * EXP(-KTG2SFX*(T(IWC)-TOPTSFX)**2)
	  END IF
	  
c          FILTCT = 0.

C MAINTENANCE RESPIRATION (BASAL METABOLISM) 
            RESPCT = BMRSFX * EXP(0.069*(T(IWC)-20.))                ! 1/D

c O2 limitations on filtration, predation and respiration

          Clogi=1.1

          if ( HYPOXFX ) then

            LOGICT=1.0/( 1.0 + EXP(MAX(Clogi*(DOhx-DOX)/
     $       (DOhx-DOqx),-25.)) )

            FILTCT=FILTCT*LOGICT
            RESPCT=RESPCT*LOGICT
            RMORT=RD*(1.0-LOGICT)

          end if

C PREDATION

          IF (SF(B) .LE. REFUGE) THEN
C ALLOW A REFUGE POPULATION
            RESPCT = 0.0
            RMORT  = 0.0
            PREDCT = 0.0
          ELSE
C PREDATION NOW IS RAISED TO AN ARBITRARY POWER
            PREDCT = SFPREDX(B)*SF(B)**PRPWRX + HARVESTX(B)*SF(B)
          END IF

C SOLIDS EFFECTS

          IF (SEDKIN .EQ. 'SSI') THEN
            TSOLID = 2.5*(B1ASF+B2ASF+B3ASF+LPOCASF+RPOCASF)
     $               + SSIASF
          ELSE
            TSOLID = 2.5*(B1ASF+B2ASF+B3ASF+LPOCASF+RPOCASF)
     $               + CLYASF + SLTASF + ORGASF
          END IF

C MY EMPIRICAL FORMULA BASED ON INSPECTION OF JORDAN'S THESIS AND 
C COMMUNICATION  WITH R. NEWELL.  REVISED NOV 16, 2005
C HARDWIRED FOR OYSTERS ONLY APRIL 13, 2007

          IF (N .GE. 3) THEN
          IF (TSOLID .LT. 4.) THEN
            FILTCT = 0.1 * FILTCT
	  ELSE IF (TSOLID .LT. 5.) THEN
	    FILTCT = (0.1 + 0.9 * (TSOLID - 4.)) * FILTCT
          ELSE IF (TSOLID .GT. 25.) THEN
	    FILTCT = 0.1 * FILTCT
	  ELSE IF (TSOLID .GT. 20.) THEN
	    FILTCT = (1. - (0.9 * (TSOLID - 20.) / 5.)) * FILTCT
          END IF
	  END IF

C SALINITY EFFECTS - OYSTERS BASED ON COMMUNICATION 
C WITH R. NEWELL AND ON REQUIREMENTS TO MAINTAIN OYSTERS IN JAMES RIVER.
      
         SALTOX = MAX(0., SALT(IWC))
	 IF (N .GE. 3) THEN
           FILTCT = FILTCT*0.5*(1.+TANH(SALTOX-KHSSF))
	 END IF

C INSTALL EQUIVALENT OF ECOSIM FORMULA FOR FORAGING ARENA
C MODIFY FORMULA FOR OYSTERS SO THEY FILTER AT SAME RATE AS PREVIOUSLY

         IF (N .LE. 2) THEN
           FILTCT = NYUIJX(B) * FILTCT / 
     $    (2. * NYUIJX(B) + FILTCT * SF(B) / BL(IWC,3) / 1000.)
         ELSE
           FILTCT = 2. * NYUIJX(B) * FILTCT / 
     $    (2. * NYUIJX(B) + FILTCT * SF(B) / BL(IWC,3) / 1000.)
         END IF
     
C CARBON INGESTION RATE
C   FILTCT - REALIZED FILTRATION RATE LITERS/D/MG C BIOMASS

          RATEI = FILTCT * ( B1ASF + B2ASF + B3ASF + LPOCASF 
     $      + RPOCASF )

C Maximum potential ASSIMILATED carbon
c    sfa1 - assimilation rate cyanobacteria
c    sfa2 - assimilation rate diatoms
c    sfa3 - assimilation rate greens
c    sfa4 - assimilation rate lpoc
c    sfa5 - assimilation rate rpoc

          GCMAX = SF(B)*FILTCT
     .      * ( SFA1X*B1ASF + SFA2X*B2ASF
     .        + SFA3X*B3ASF + SFA4X*LPOCASF + SFA5X*RPOCASF) 

C     COMPUTE SUSPENSION FEEDER GROWTH RATE, COMPARING TO MAX
C     INGESTION RATE - MAX AMOUNT OF FOOD GUT CAN TAKE IN
C        if ratei < rateimax  then use normal growth rate
C        if ratei > rateimax  then limit to max rate

         IF (AQUACX) THEN 
           RELING = (RESPCT*SF(B) + RMORT*SF(B) + PREDCT)/
     $       (GCMAX*(1.0-RFSFX))
         ELSE
           RELING = MIN(1.0,MAXINGX/(RATEI+1.0E-10))
         END IF

c Total Filtered from Organic Matter Pools    (MBM 971010 moved up from below)
          CFILT = SF(B)*RATEI

          NFILT = SF(B)*FILTCT
     .       * ( B1ASF*ANC1
     .       +   B2ASF*ANC2
     .       +   B3ASF*ANC3
     .       +   LPONASF
     .       +   RPONASF )
          PFILT = SF(B)*FILTCT
     .       * ( B1ASF*APC1
     .       +   B2ASF*APC2
     .       +   B3ASF*APC3
     .       +   LPOPASF 
     .       +   RPOPASF )

C Limit carbon growth to a max. theoret. value (mg C/m2.d)
          SFGC = RELING*GCMAX

C  CALCULATE POTENTIAL GROWTH RATES BASED ON NUTRIENTS RATHER THAN CARBON

C        COMPUTE GROWTH RATE FOR NITROGEN mg N/m2/d

          GN = SF(B)*FILTCT 
     .     * ( SFA1X*B1ASF*ANC1
     .     +   SFA2X*B2ASF*ANC2
     .     +   SFA3X*B3ASF*ANC3
     .     +   SFA4X*LPONASF 
     .     +   SFA5X*RPONASF ) 

C        COMPUTE GROWTH RATE FOR PHOSPHORUS mg P/m2/d

          GP = SF(B)*FILTCT
     .     * ( SFA1X*B1ASF*APC1
     .     +   SFA2X*B2ASF*APC2
     .     +   SFA3X*B3ASF*APC3
     .     +   SFA4X*LPOPASF 
     .     +   SFA5X*RPOPASF ) 

C          SFCN - C/N RATIO   SFCP - C/P RATIO
C   CONVERT TO EQUIVALENT CARBON UNITS TO PERMIT DIRECT COMPARISON mg/C/m2/d

          GN=GN*SFCNX    
          GP=GP*SFCPX

C ASSIGN CARBON ASSIMILATION RATES FOR THIS SPECIES

          SFAC1=SFA1X
          SFAC2=SFA2X
          SFAC3=SFA3X
          SFAC4=SFA4X
          SFAC5=SFA5X

C NUTRIENT ASSIMILATION
C IF POTENTIAL GROWTH CALCULATED FOR NUTRIENTS EXCEEDS GROWTH FROM CARBON,
C REDUCE NUTRIENT ASSIMILATION.  OTHERWISE, USE SAME ASSIMLATION AS FOR CARBON

C         NITROGEN ASSIMILATION RATES
          IF(GN.GT.SFGC)THEN
            SFAN1=SFA1X*SFGC/GN        
            SFAN2=SFA2X*SFGC/GN
            SFAN3=SFA3X*SFGC/GN
            SFAN4=SFA4X*SFGC/GN
            SFAN5=SFA5X*SFGC/GN
          ELSE
            SFAN1=SFA1X      
            SFAN2=SFA2X
            SFAN3=SFA3X
            SFAN4=SFA4X
            SFAN5=SFA5X
          ENDIF

C        PHOSPHORUS ASSIMILATION RATES
          IF(GP.GT.SFGC)THEN
            SFAP1=SFA1X*SFGC/GP        
            SFAP2=SFA2X*SFGC/GP
            SFAP3=SFA3X*SFGC/GP
            SFAP4=SFA4X*SFGC/GP
            SFAP5=SFA5X*SFGC/GP
          ELSE
            SFAP1=SFA1X      
            SFAP2=SFA2X
            SFAP3=SFA3X
            SFAP4=SFA4X
            SFAP5=SFA5X
          ENDIF

C        C FECES - C NOT ASSILMIATED     mg / m2 /d

          CFECES = SF(B)*FILTCT*RELING
     .       * ((1.-SFAC1)*B1ASF
     .       +  (1.-SFAC2)*B2ASF
     .       +  (1.-SFAC3)*B3ASF
     .       +  (1.-SFAC4)*LPOCASF )

          RCFECES = SF(B)*FILTCT*RELING*(1.-SFAC5)*RPOCASF

C        N FECES - N NOT ASSILMIATED
          NFECES = SF(B)*FILTCT*RELING
     .       * ((1.-SFAN1)*B1ASF*ANC1
     .       + (1.-SFAN2)*B2ASF*ANC2
     .       + (1.-SFAN3)*B3ASF*ANC3
     .       + (1.-SFAN4)*LPONASF )

          RNFECES = SF(B)*FILTCT*RELING * (1.-SFAN5)*RPONASF

C        P FECES - P NOT ASSILMIATED
          PFECES = SF(B)*FILTCT*RELING
     .       * ((1.-SFAP1)*B1ASF*APC1
     .       + (1.-SFAP2)*B2ASF*APC2
     .       + (1.-SFAP3)*B3ASF*APC3
     .       + (1.-SFAP4)*LPOPASF )

          RPFECES = SF(B)*FILTCT*RELING * (1.-SFAP5)*RPOPASF

C        PSEUDOFECES

          CPSFEC=MAX(0.0,CFILT-SFGC-CFECES-RCFECES)
          RCPSFEC=CPSFEC * RPOCASF/(B1ASF+B2ASF+B3ASF+LPOCASF
     $      +RPOCASF)
          CPSFEC=CPSFEC-RCPSFEC

          NPSFEC=MAX(0.0,NFILT-SFGC/SFCNX-NFECES-RNFECES)
          RNPSFEC=NPSFEC * RPONASF
     .        /(ANC1*B1ASF+ANC2*B2ASF+ANC3*B3ASF+LPONASF+RPONASF)
          NPSFEC=NPSFEC-RNPSFEC

          PPSFEC=MAX(0.0,PFILT-SFGC/SFCPX-PFECES-RPFECES)
          RPPSFEC=PPSFEC * RPOPASF 
     .      /(APC1*B1ASF+APC2*B2ASF+APC3*B3ASF+LPOPASF+RPOPASF)
          PPSFEC=PPSFEC-RPPSFEC

C        APPORTION FECES TO DEPOSITIONAL FLUXES.  FECES ARE PRODUCED
C        FROM FOOD TAKEN IN BUT NOT ASSIMILATED.  

c Susp fdr particulate fluxes (local) MG/M2/DAY

C LPOC
          SFLUXCX(B) =  CFECES + CPSFEC
     .      + PREDCT - HARVESTX(B)*SF(B) + RMORT*SF(B)

C LPON
          SFLUXNX(B) =  NFECES + NPSFEC
     .      + (PREDCT - HARVESTX(B)*SF(B) + RMORT*SF(B))/SFCNX

C LPOP
          SFLUXPX(B) =  PFECES + PPSFEC
     .      + (PREDCT - HARVESTX(B)*SF(B) + RMORT*SF(B))/SFCPX

C RPOC
          SF_RPOCX(B) = RCFECES + RCPSFEC
          
C RPON
          SF_RPONX(B) = RNFECES + RNPSFEC
          
C RPOP
          SF_RPOPX(B) = RPFECES + RPPSFEC

C PIP
          IF (PIP_CALC) SF_PIPX(B) = 0.0  ! FILTCT*SF(B)*PIPASF !*WSPIPNET(B)/WSPIP(B) 

C Inorganic solids
          IF (SEDKIN .EQ. 'SSI') THEN

            SF_SSIX(B) = FILTCT*SF(B)*SSIASF !*WSSNET(B)/WSS(B) CFC
          
	  ELSE

C Clay and Silt
            SF_CLYX(B) =  FILTCT*SF(B)*CLYASF
            SF_SLTX(B) =  FILTCT*SF(B)*SLTASF
            SF_ORGX(B) =  FILTCT*SF(B)*ORGASF
          
	  END IF
	  
C Total C, N, P, filtered from water column mg/m2/d

          SF_CFILTX(B) = CFILT
          SF_NFILTX(B) = NFILT
          SF_PFILTX(B) = PFILT
         
C        CORRECT DERIVATIVES FOR LOSSES
C Adjust for fraction of cell covered e.g. reef fraction
C As a principle, adjust fluxes to water column and sediments,
C not local fluxes that end in "X"  01/27/17

          DTB1(IWC) = DTB1(IWC) - (FILTCT*SCOVERX(B)*SF(B)*B1ASF)
     .      /BL(IWC,3) /1000. /86400.           ! units: g/m3/s

          DTB2(IWC) = DTB2(IWC) - (FILTCT*SCOVERX(B)*SF(B)*B2ASF)
     .      /BL(IWC,3) /1000. /86400.

          DTB3(IWC) = DTB3(IWC) - (FILTCT*SCOVERX(B)*SF(B)*B3ASF)
     .      /BL(IWC,3) /1000. /86400.

          DTLPOC(IWC) = DTLPOC(IWC) - (FILTCT*SCOVERX(B)*SF(B)*LPOCASF)
     .      /BL(IWC,3) /1000. /86400.
     .      + FR_RSUSPX(B)*SCOVERX(B)*SFLUXCX(B)/BL(IWC,3) /1000. 
     .      /86400.  !add resuspension
          SFLUXCX(B) = (1. - FR_RSUSPX(B))*SFLUXCX(B)  ! remove resuspension

          DTLPOP(IWC) = DTLPOP(IWC) - (FILTCT*SCOVERX(B)*SF(B)*LPOPASF)
     .      /BL(IWC,3) /1000. /86400.
     .      + FR_RSUSPX(B)*SCOVERX(B)*SFLUXPX(B)/BL(IWC,3) /1000. 
     .      /86400.  !add resuspension
          SFLUXPX(B) = (1. - FR_RSUSPX(B))*SFLUXPX(B)  ! remove resuspension

          DTLPON(IWC) = DTLPON(IWC) - (FILTCT*SCOVERX(B)*SF(B)*LPONASF)
     .      /BL(IWC,3) /1000. /86400.
     .      + FR_RSUSPX(B)*SCOVERX(B)*SFLUXNX(B)/BL(IWC,3) /1000. 
     .      /86400.  !add resuspension
          SFLUXNX(B) = (1. - FR_RSUSPX(B))*SFLUXNX(B)  ! remove resuspension

          DTRPOC(IWC) = DTRPOC(IWC) - (FILTCT*SCOVERX(B)*SF(B)*RPOCASF)
     .      /BL(IWC,3) /1000. /86400.
     .      + FR_RSUSPX(B)*SCOVERX(B)*SF_RPOCX(B)/BL(IWC,3) /1000. 
     .      /86400.  !add resuspension
          SF_RPOCX(B) = (1. - FR_RSUSPX(B))*SF_RPOCX(B)  ! remove resuspension

          DTRPOP(IWC) = DTRPOP(IWC) - (FILTCT*SCOVERX(B)*SF(B)*RPOPASF)
     .      /BL(IWC,3) /1000. /86400.
     .      + FR_RSUSPX(B)*SCOVERX(B)*SF_RPOPX(B)/BL(IWC,3) /1000. 
     .      /86400.  !add resuspension
          SF_RPOPX(B) = (1. - FR_RSUSPX(B))*SF_RPOPX(B)  ! remove resuspension

          DTRPON(IWC) = DTRPON(IWC) - (FILTCT*SCOVERX(B)*SF(B)*RPONASF)
     .      /BL(IWC,3) /1000. /86400.
     .      + FR_RSUSPX(B)*SCOVERX(B)*SF_RPONX(B)/BL(IWC,3) /1000. 
     .      /86400.  !add resuspension
          SF_RPONX(B) = (1. - FR_RSUSPX(B))*SF_RPONX(B)  ! remove resuspension

          IF (SEDKIN .EQ. 'SSI') THEN
            DTSSI(IWC) = DTSSI(IWC) - 
     .        (1. - FR_RSUSPX(B))*SCOVERX(B)*SF_SSIX(B)
     .        /BL(IWC,3) /1000. /86400.
            SF_SSIX(B) = (1. - FR_RSUSPX(B))*SF_SSIX(B)  ! remove resuspension
          ELSE
            DTSCLY(IWC) = DTSCLY(IWC) - SF_CLYX(B)*SCOVERX(B)
     .                       /BL(IWC,3) /1000. /86400.   ! resuspension in SEDROMS
            DTSSLT(IWC) = DTSSLT(IWC) - SF_SLTX(B)*SCOVERX(B)
     .                       /BL(IWC,3) /1000. /86400.
            DTSORG(IWC) = DTSORG(IWC) - SF_ORGX(B)*SCOVERX(B)
     .                       /BL(IWC,3) /1000. /86400.
          END IF	    

          DTPIP(IWC) = DTPIP(IWC) - (1. - FR_RSUSPX(B))
     .      *SCOVERX(B)*SF_PIPX(B) /BL(IWC,3) /1000. /86400.
          SF_PIPX(B) = (1. - FR_RSUSPX(B)) * SF_PIPX(B)

c calculate respiration fluxes

C NUTRIENT LOSS THROUGH RESPIRATION CALCULATED VIA MASS BALANCE

          JNH4SFX(B) = NFILT - NFECES - RNFECES - NPSFEC - RNPSFEC
     .      - SFGC/SFCNX
     .      + (RESPCT*SF(B)+RFSFX*SFGC)/SFCNX                 ! units: mg/m2/d
          JPO4SFX(B) = PFILT - PFECES - RPFECES - PPSFEC - RPPSFEC
     .      - SFGC/SFCPX
     .      + (RESPCT*SF(B)+RFSFX*SFGC)/SFCPX 
          SODSFX(B)  = (RESPCT*SF(B)+RFSFX*SFGC)*2.67/1000.   ! units: g/m2/d

C        TAKE INTEGRATION STEP FOR SUSPENSION FEEDERS

          SF(B) = SF(B) +  DTDAY * ( (1.-RFSFX)*SFGC          ! units: mgC/m2
     .      - RESPCT*SF(B) - RMORT*SF(B) - PREDCT)

C DONT LET GO NEGATIVE

          SF(B) = MAX(SF(B),REFUGE)

CMBM 961226 diagnostic arrays
          SFFILTCT(B,N) = FILTCT
          SFRESPCT(B,N) = RESPCT + RFSFX*SFGC/SF(B)
          SFPREDCT(B,N) = PREDCT
          SFRATEI(B,N)  = RATEI
          SFGCMAX(B,N)  = GCMAX
          SFGMIN(B,N)   = GMIN
          SFCFECES(B,N) = CFECES
          SFNFECES(B,N) = NFECES
          SFPFECES(B,N) = PFECES
          SFCPSFEC(B,N) = CPSFEC
          SFNPSFEC(B,N) = NPSFEC
          SFPPSFEC(B,N) = PPSFEC
          SF_SFGC(B,N)  = SFGC
          SF_RESP(B,N)  = RESPCT*SF(B) + RFSFX*SFGC
          SF_PRED(B,N)  = PREDCT
          SF_RMORT(B,N) = RMORT*SF(B)
          CHARV(B,N)    = HARVESTX(B)*SF(B)*SFA(B)*SCOVERX(B)/1000.       ! G/D
	  
C OYSTER-SPECIFIC DIAGONOSTICS

C          IF (N .EQ. 1) THEN
C            OYCFILT(B) = CFILT
C            OYNFILT(B) = NFILT
C            OYPFILT(B) = PFILT
C            OYSSI(B)   = SF_SSIX(B)
C            OYNH4(B)   = JNH4SFX(B)
C            OYPO4(B)   = JPO4SFX(B)
C            OYSOD(B)   = SODSFX(B)
C            OYCFLUX(B) = SFLUXCX(B) + SF_RPOCX(B)
C            OYNFLUX(B) = SFLUXNX(B) + SF_RPONX(B)
C            OYPFLUX(B) = SFLUXPX(B) + SF_RPOPX(B)
C	  END IF
	  	  
 256    CONTINUE
        
c CONVERT BACK INTO SAVED ARRAYS

      DO B=1,NBB
        SFEED(B,N)=SF(B)
      ENDDO

C ADD UP EACH SPECIES FLUX CONTRIBUTION
c Partic. fluxes (labile, refrac. C,N,P,Inorg solids,sorbed P) 

      DO B=1,NBB
       JNH4SF(B)=JNH4SF(B)+(JNH4SFX(B)+FRDOCSF*SFLUXNX(B))*SCOVERX(B)
       JPO4SF(B)=JPO4SF(B)+(JPO4SFX(B)+FRDOCSF*SFLUXPX(B))*SCOVERX(B)
       SODSF(B)=SODSF(B)+SODSFX(B)*SCOVERX(B)
       SFLUXC(B)=SFLUXC(B)+(1.0-FRDOCSF)*SFLUXCX(B)*SCOVERX(B)
       SFLUXN(B)=SFLUXN(B)+(1.0-FRDOCSF)*SFLUXNX(B)*SCOVERX(B)
       SFLUXP(B)=SFLUXP(B)+(1.0-FRDOCSF)*SFLUXPX(B)*SCOVERX(B)
       SF_LDOC(B)=SF_LDOC(B)+FRDOCSF*SFLUXCX(B)*SCOVERX(B)
       SF_RPOC(B)=SF_RPOC(B)+SF_RPOCX(B)*SCOVERX(B)
       SF_RPON(B)=SF_RPON(B)+SF_RPONX(B)*SCOVERX(B)
       SF_RPOP(B)=SF_RPOP(B)+SF_RPOPX(B)*SCOVERX(B)
       SF_SSI(B)=SF_SSI(B)+SF_SSIX(B)*SCOVERX(B)
       SF_CLY(B)=SF_CLY(B)+SF_CLYX(B)*SCOVERX(B)                  ! mg/m2/d
       SF_SLT(B)=SF_SLT(B)+SF_SLTX(B)*SCOVERX(B)
       SF_ORG(B)=SF_ORG(B)+SF_ORGX(B)*SCOVERX(B)
       SF_PIP(B)=SF_PIP(B)+SF_PIPX(B)*SCOVERX(B)
       SF_CFILT(B)=SF_CFILT(B)+SF_CFILTX(B)
       SF_NFILT(B)=SF_NFILT(B)+SF_NFILTX(B)
       SF_PFILT(B)=SF_PFILT(B)+SF_PFILTX(B)
      ENDDO
      
c Create two ROMS variables in appropriate units (kg/m2/s)

      IF (N .EQ. NSPECIES .AND. SEDKIN .NE. 'SSI') THEN
        DO B=1,NBB
	  SF_FC(1,B) = SF_CLY(B)/1.E6/86400.
	  SF_FC(2,B) = SF_SLT(B)/1.E6/86400.
	  SF_FC(3,B) = 0.0
	  SF_FC(4,B) = SF_ORG(B)/1.E6/86400.
	END DO
      END IF

      END   

